/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.ruler;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.ruler.GuideLine;
import com.jaspersoft.ireport.designer.ruler.GuideLineChangedListener;
import com.jaspersoft.ireport.designer.utils.Unit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.visual.widget.Scene;

public class RulerPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
Scene.SceneListener,
ComponentListener {
    public static final Color BORDER_COLOR = new Color(127, 157, 185);
    private List<GuideLineChangedListener> guideLineChangedListeners = new ArrayList<GuideLineChangedListener>();
    private double unitPixels = 1.0;
    private double zoomFactor = 1.0;
    private int lastMousePosition = -1;
    private boolean vertical = false;
    private BufferedImage savedImage = null;
    private List guideLines = new ArrayList();
    private GuideLine editingGuideLine = null;
    private static final ImageIcon hGuideLineIcon = new ImageIcon(RulerPanel.class.getResource("/com/jaspersoft/ireport/designer/ruler/rulestop_horizontal.png"));
    private static final ImageIcon vGuideLineIcon = new ImageIcon(RulerPanel.class.getResource("/com/jaspersoft/ireport/designer/ruler/rulestop_vertical.png"));
    private double zeroPos = 0.0;
    static int[] normal_intervals = new int[]{1, 2, 5, 10, 25, 50, 100, 200, 500, 1000, 2500, 5000, 10000};
    private AbstractReportObjectScene scene = null;
    private JScrollPane sceneScrollPane = null;

    public void addGuideLineChangedListener(GuideLineChangedListener listener) {
        if (!this.guideLineChangedListeners.contains(listener)) {
            this.guideLineChangedListeners.add(listener);
        }
    }

    public List getGuideLines() {
        return this.guideLines;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public AbstractReportObjectScene getScene() {
        return this.scene;
    }

    public void setScene(AbstractReportObjectScene scene) {
        this.scene = scene;
    }

    public RulerPanel(AbstractReportObjectScene scene) {
        this.initComponents();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.scene = scene;
        String newUnitName = IReportManager.getPreferences().get(I18n.getString("RulerPanel.Value.Unit"), I18n.getString("RulerPanel.Measure.inches"));
        this.unitPixels = Unit.getUnit(newUnitName).getConversionValue();
        IReportManager.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent evt) {
                if (evt.getKey() != null && evt.getKey().equals(I18n.getString("RulerPanel.Value.Unit"))) {
                    String newUnitName = IReportManager.getPreferences().get(I18n.getString("RulerPanel.Value.Unit"), I18n.getString("RulerPanel.Measure.inches"));
                    RulerPanel.this.setUnitPixels(Unit.getUnit(newUnitName).getConversionValue());
                    RulerPanel.this.repaint();
                }
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        if (this.getScene() == null) {
            return;
        }
        this.getScene().addSceneListener(this);
        JComponent viewComponent = this.getScene().getView();
        viewComponent.addComponentListener(this);
        this.refreshRuler();
    }

    public void removeNotify() {
        if (this.getScene() != null) {
            this.getScene().getView().removeComponentListener(this);
            this.getScene().removeSceneListener(this);
        }
        super.removeNotify();
    }

    public void addGuideLine(GuideLine guide) {
        this.getGuideLines().add(guide);
        this.fireGuideLineAdded(guide);
    }

    public void removeGuideLine(GuideLine guide) {
        this.getGuideLines().remove(guide);
        this.fireGuideLineRemoved(guide);
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.setMinimumSize(new Dimension(20, 20));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 221, Short.MAX_VALUE));
    }

    public double getUnitPixels() {
        return this.unitPixels;
    }

    public void setUnitPixels(double unitPixels) {
        this.unitPixels = unitPixels;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public void paint(Graphics gx) {
        super.paint(gx);
        Graphics2D g = (Graphics2D)gx;
        Paint oldp = g.getPaint();
        double zeroPos = this.getZeroPos();
        JasperDesign jd = null;
        JScrollPane scrollPane = null;
        if (this.getScene() != null && this.getScene().getJasperDesign() != null) {
            if (this.getScene() instanceof ReportObjectScene) {
                jd = this.getScene().getJasperDesign();
            }
            scrollPane = this.findScrollPane(this.getScene().getView());
        }
        if (jd != null) {
            g.setPaint(new Color(128, 128, 128, 128));
            if (this.isVertical()) {
                int scroll;
                int n = scroll = scrollPane == null || scrollPane.getVerticalScrollBar() == null ? 0 : scrollPane.getVerticalScrollBar().getValue();
                if (this.getZeroPos() > 0.0) {
                    g.fillRect(0, 0, this.getWidth(), (int)this.getZeroPos());
                }
                List<JRBand> bands = ModelUtils.getBands(jd);
                int y0 = (int)this.getZeroPos();
                int lastY = 10 + jd.getTopMargin();
                boolean gray = false;
                Color superLight = new Color(255, 200, 200, 160);
                for (JRBand b : bands) {
                    if (b == null || b.getHeight() == 0) continue;
                    int y1 = (int)Math.round((double)(lastY += b.getHeight()) * this.getZoomFactor()) - scroll;
                    g.setPaint(gray ? superLight : Color.WHITE);
                    g.fillRect(0, y0, this.getWidth(), y1 - y0);
                    boolean bl = gray = !gray;
                    y0 = y1;
                    if (y0 <= this.getHeight()) continue;
                    break;
                }
                g.setPaint(new Color(128, 128, 128, 128));
                if (y0 < this.getHeight()) {
                    g.fillRect(0, y0, this.getWidth(), this.getHeight());
                }
            } else {
                int x1;
                if (this.getZeroPos() > 0.0) {
                    g.fillRect(0, 0, (int)this.getZeroPos(), this.getHeight());
                }
                if ((x1 = (int)Math.round((double)(10 + jd.getPageWidth() - jd.getRightMargin()) * this.getZoomFactor() - (double)(scrollPane == null || scrollPane.getHorizontalScrollBar() == null ? 0 : scrollPane.getHorizontalScrollBar().getValue()))) < this.getWidth()) {
                    g.fillRect(x1, 0, this.getWidth(), this.getHeight());
                }
            }
        }
        GradientPaint p = this.isVertical() ? new GradientPaint((int)((double)this.getWidth() * 0.2), 0.0f, new Color(150, 150, 150, 128), this.getWidth(), 0.0f, new Color(255, 255, 255, 0)) : new GradientPaint(0.0f, (int)((double)this.getHeight() * 0.2), new Color(200, 200, 200, 128), 0.0f, this.getHeight(), new Color(255, 255, 255, 0));
        g.setPaint(p);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        p = this.isVertical() ? new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 255), (int)((double)this.getWidth() * 0.3), 0.0f, new Color(255, 255, 255, 0)) : new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 255), 0.0f, (int)((double)this.getHeight() * 0.3), new Color(255, 255, 255, 0));
        g.setPaint(p);
        if (this.isVertical()) {
            g.fillRect(1, 0, 1 + (int)((double)this.getWidth() * 0.3), this.getHeight());
        } else {
            g.fillRect(0, 1, this.getWidth(), 1 + (int)((double)this.getHeight() * 0.3));
        }
        g.setPaint(oldp);
        int interval = 1;
        int interval2 = 1;
        while ((double)interval * this.unitPixels * this.zoomFactor <= 3.0) {
            ++interval;
        }
        interval = this.normalizeInterval(interval);
        interval2 = this.calculateLabelsInterval(interval);
        double firstUnit = (int)(zeroPos / (this.unitPixels * this.zoomFactor)) + 1;
        double interval_len = (double)interval * this.unitPixels * this.zoomFactor;
        double newZeroPos = zeroPos;
        if (this.isVertical() && jd != null) {
            int scroll = scrollPane == null || scrollPane.getVerticalScrollBar() == null ? 0 : scrollPane.getVerticalScrollBar().getValue();
            List<JRBand> bands = ModelUtils.getBands(jd);
            int lastY = 10 + jd.getTopMargin();
            for (JRBand b : bands) {
                double pos;
                if (b == null || b.getHeight() == 0) continue;
                int y1 = (int)Math.round((double)(lastY += b.getHeight()) * this.getZoomFactor()) - scroll;
                double unit = 0.0;
                while (!((pos = unit * this.unitPixels * this.zoomFactor + newZeroPos) > (double)y1)) {
                    this.paintUnitTicks(g, unit, pos, interval_len, unit % (double)(interval * interval2) == 0.0 && (unit == 0.0 || (double)y1 - pos > 30.0), Math.max(1, y1));
                    unit += (double)interval;
                }
                newZeroPos = y1;
                if (!(newZeroPos > (double)this.getHeight())) continue;
                break;
            }
            if (newZeroPos < (double)this.getHeight()) {
                double pos;
                double unit = 0.0;
                while (!((pos = unit * this.unitPixels * this.zoomFactor + newZeroPos) > (double)this.getHeight())) {
                    this.paintUnitTicks(g, unit, pos, interval_len, unit % (double)(interval * interval2) == 0.0, -1);
                    unit += (double)interval;
                }
            }
        } else {
            double unit = 0.0;
            while (true) {
                double pos = unit * this.unitPixels * this.zoomFactor + newZeroPos;
                if (this.isVertical() && pos > (double)this.getHeight() || !this.isVertical() && pos > (double)this.getWidth()) break;
                this.paintUnitTicks(g, unit, pos, interval_len, unit % (double)(interval * interval2) == 0.0, -1);
                unit += (double)interval;
            }
        }
        double unit = -interval;
        while (true) {
            double pos = unit * this.unitPixels * this.zoomFactor + zeroPos;
            this.paintUnitTicks(g, unit, pos, interval_len, unit % (double)(interval * interval2) == 0.0, -1);
            if (pos < (double)(-interval)) break;
            unit -= (double)interval;
        }
        g.setColor(BORDER_COLOR);
        if (this.isVertical()) {
            g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
        } else {
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        }
        for (int i = 0; i < this.getGuideLines().size(); ++i) {
            GuideLine pos = (GuideLine)this.getGuideLines().get(i);
            if (pos == this.editingGuideLine) continue;
            int posI = (int)((double)pos.getPosition() * this.getZoomFactor() + zeroPos);
            if (this.isVertical()) {
                g.drawImage(vGuideLineIcon.getImage(), this.getWidth() - 16, posI - 4, this);
                continue;
            }
            g.drawImage(hGuideLineIcon.getImage(), posI - 4, this.getHeight() - 16, this);
        }
        this.lastMousePosition = -1;
    }

    private void paintUnitTicks(Graphics2D g, double unit, double x, double width, boolean printLabel, int limit) {
        int lineHeight = 5;
        if (unit == (double)((int)unit)) {
            lineHeight = 7;
        }
        if (this.getUnitPixels() == 1.0) {
            lineHeight = 5;
        }
        if (printLabel) {
            String unitStr = "" + (int)unit;
            this.printLabel(g, unitStr, x);
            lineHeight = 8;
        }
        Rectangle2D.Double rect = this.isVertical() ? new Rectangle2D.Double(this.getWidth() - 1 - lineHeight, x, lineHeight, 0.0) : new Rectangle2D.Double(x, this.getHeight() - 1 - lineHeight, 0.0, lineHeight);
        g.draw(rect);
        this.paintSubunit(g, unit, x, width, 6, 1, limit);
    }

    private void paintSubunit(Graphics2D g, double unit, double x, double width, int tickHeight, int level, int limit) {
        Color c = g.getColor();
        if (level > 1) {
            g.setColor(Color.GRAY);
        }
        if (level > 2) {
            g.setColor(Color.LIGHT_GRAY);
        }
        if (width >= 30.0) {
            double pos = x;
            this.paintSubunit(g, unit, pos, width / 10.0, tickHeight - 2, level + 1, limit);
            DecimalFormat dnf = new DecimalFormat("0.0");
            for (int i = 1; i < 10; ++i) {
                String unitStr;
                int realTickHeight = tickHeight - 2;
                pos = x + width / 10.0 * (double)i;
                if (limit > 0 && pos >= (double)limit) {
                    g.setColor(c);
                    return;
                }
                if (i == 5) {
                    realTickHeight = tickHeight;
                    if (level == 1 && width > 150.0 && (limit <= 0 || (double)limit - pos > 30.0)) {
                        unitStr = dnf.format(unit + 0.5);
                        this.printLabel(g, unitStr, pos);
                    }
                }
                if (level == 1 && width > 500.0 && i != 5 && (limit <= 0 || (double)limit - pos > 30.0)) {
                    unitStr = dnf.format(unit + (double)i * 0.1);
                    this.printLabel(g, unitStr, pos);
                }
                this.paintSubunit(g, unit, pos, width / 10.0, tickHeight - 2, level + 1, limit);
                Rectangle2D.Double rect = this.isVertical() ? new Rectangle2D.Double(this.getWidth() - realTickHeight - 1, pos, realTickHeight, 0.0) : new Rectangle2D.Double(pos, this.getHeight() - realTickHeight - 1, 0.0, realTickHeight);
                g.draw(rect);
            }
        } else if (width >= 10.0) {
            double pos = x + width / 2.0;
            Rectangle2D.Double rect = this.isVertical() ? new Rectangle2D.Double(this.getWidth() - tickHeight - 1, pos, tickHeight, 0.0) : new Rectangle2D.Double(pos, this.getHeight() - tickHeight - 1, 0.0, tickHeight);
            g.draw(rect);
        }
        g.setColor(c);
    }

    private void printLabel(Graphics2D g, String unitStr, double x) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D r = fm.getStringBounds(unitStr, g);
        if (this.isVertical()) {
            this.writeRotateString(g, (float)this.getWidth() - 10.0f, x, unitStr);
        } else {
            g.drawString(unitStr, (float)x - (float)r.getWidth() / 2.0f, (float)this.getHeight() - 10.0f);
        }
    }

    private int normalizeInterval(int interval) {
        for (int i = 0; i < normal_intervals.length - 1; ++i) {
            if (interval > normal_intervals[i]) continue;
            return normal_intervals[i];
        }
        return interval;
    }

    private double getZeroPos() {
        return this.zeroPos;
    }

    private double setZeroPos(double d) {
        this.zeroPos = d;
        return this.zeroPos;
    }

    private int calculateLabelsInterval(int interval) {
        int interval2 = 1;
        for (int i = 0; i < normal_intervals.length - 1; ++i) {
            if (!((double)(normal_intervals[i] * interval) * this.unitPixels * this.zoomFactor >= 30.0)) continue;
            return normal_intervals[i];
        }
        while ((double)(interval2 * interval) * this.unitPixels * this.zoomFactor >= 30.0) {
            ++interval2;
        }
        return interval2;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent evt) {
        this.updateMousePosition(-1);
        this.editingGuideLine = null;
        for (int i = 0; i < this.getGuideLines().size(); ++i) {
            int mousePos;
            GuideLine pos = (GuideLine)this.getGuideLines().get(i);
            int posI = (int)Math.round((double)pos.getPosition() * this.zoomFactor + this.getZeroPos());
            int n = mousePos = this.isVertical() ? evt.getY() : evt.getX();
            if (mousePos <= posI - 3 || mousePos >= posI + 3) continue;
            this.editingGuideLine = pos;
            break;
        }
        this.savedImage = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
        Graphics2D savedGraphics = this.savedImage.createGraphics();
        this.paint(savedGraphics);
        if (this.editingGuideLine == null) {
            this.editingGuideLine = new GuideLine(this.getLogicalPosition(this.isVertical() ? evt.getY() : evt.getX()), this.isVertical());
            this.addGuideLine(this.editingGuideLine);
        } else {
            this.getGraphics().drawImage(this.savedImage, 0, 0, this);
        }
        if (!this.isVertical()) {
            this.getGraphics().drawImage(hGuideLineIcon.getImage(), evt.getX() - 4, this.getHeight() - 16, this);
        } else {
            this.getGraphics().drawImage(vGuideLineIcon.getImage(), this.getWidth() - 16, evt.getY() - 4, this);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.editingGuideLine == null) {
            return;
        }
        if (!this.isVertical()) {
            if (evt.getX() > 0 && evt.getX() < this.getWidth()) {
                this.editingGuideLine.setPosition(this.getLogicalPosition(evt.getX()));
                this.repaint();
            } else {
                this.removeGuideLine(this.editingGuideLine);
            }
        } else if (evt.getY() > 0 && evt.getY() < this.getHeight()) {
            this.editingGuideLine.setPosition(this.getLogicalPosition(evt.getY()));
            this.repaint();
        } else {
            this.removeGuideLine(this.editingGuideLine);
        }
        this.editingGuideLine = null;
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        this.updateMousePosition(e.getX());
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent evt) {
        if (evt.getSource() == this) {
            if (this.editingGuideLine == null) {
                return;
            }
            this.editingGuideLine.setPosition(this.getLogicalPosition(this.isVertical() ? Math.max(0, evt.getY()) : Math.max(0, evt.getX())));
            this.fireGuideLineMoved(this.editingGuideLine);
            this.getGraphics().drawImage(this.savedImage, 0, 0, this);
            int realPosition = (int)((double)Math.round((double)this.editingGuideLine.getPosition() * this.zoomFactor) + this.zeroPos);
            if (!this.isVertical()) {
                this.getGraphics().drawImage(hGuideLineIcon.getImage(), realPosition - 4, this.getHeight() - 16, this);
            } else {
                this.getGraphics().drawImage(vGuideLineIcon.getImage(), this.getWidth() - 16, realPosition - 4, this);
            }
        } else {
            Component c = evt.getComponent();
            Point p = new Point(0, 0);
            if (c != null) {
                p.x = evt.getX() + c.getLocationOnScreen().x;
                p.y = evt.getY() + c.getLocationOnScreen().y;
            }
            SwingUtilities.convertPointFromScreen(p, this);
            this.updateMousePosition(this.isVertical() ? p.y : p.x);
        }
    }

    public void mouseMoved(MouseEvent e) {
        Component c = e.getComponent();
        Point p = new Point(0, 0);
        if (c != null) {
            p.x = e.getX() + c.getLocationOnScreen().x;
            p.y = e.getY() + c.getLocationOnScreen().y;
        }
        SwingUtilities.convertPointFromScreen(p, this);
        this.updateMousePosition(this.isVertical() ? p.y : p.x);
    }

    public void updateMousePosition(int newPosition) {
        if (this.lastMousePosition == newPosition) {
            return;
        }
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        g.setXORMode(Color.PINK.darker());
        if (this.lastMousePosition >= 0) {
            if (this.isVertical()) {
                g.drawLine(0, this.lastMousePosition, this.getWidth(), this.lastMousePosition);
            } else {
                g.drawLine(this.lastMousePosition, 0, this.lastMousePosition, this.getHeight());
            }
        }
        this.lastMousePosition = newPosition;
        if (this.isVertical()) {
            g.drawLine(0, this.lastMousePosition, this.getWidth(), this.lastMousePosition);
        } else {
            g.drawLine(this.lastMousePosition, 0, this.lastMousePosition, this.getHeight());
        }
        g.setPaintMode();
    }

    public void writeRotateString(Graphics2D g2, double x, double yCenter, String s) {
        Rectangle2D sb = g2.getFontMetrics().getStringBounds(s, g2);
        double sw = sb.getWidth();
        double sh = sb.getHeight();
        Color c = g2.getColor();
        g2.setColor(Color.RED);
        sb.setRect(x - sw / 2.0, yCenter - sh, sw, sh);
        g2.setColor(c);
        AffineTransform oldAr = g2.getTransform();
        double rotX = x - sw / 2.0;
        double rotY = yCenter - sh;
        AffineTransform at = g2.getTransform();
        at.rotate(-1.5707963267948966, x, yCenter);
        g2.setTransform(at);
        g2.drawString(s, (float)sb.getX(), (float)(sb.getY() + sb.getHeight()));
        g2.setTransform(oldAr);
    }

    public int getLogicalPosition(int p) {
        return (int)Math.round(((double)p - this.getZeroPos()) / this.zoomFactor);
    }

    public void sceneRepaint() {
        JasperDesign jd;
        boolean needRefresh = false;
        if (this.getScene().getZoomFactor() != this.zoomFactor) {
            needRefresh = true;
        }
        if ((jd = this.getScene().getJasperDesign()) != null && !needRefresh) {
            this.sceneScrollPane = this.findScrollPane(this.getScene().getView());
            double newZeroPos = 0.0;
            newZeroPos = this.isVertical() ? (10.0 + (double)jd.getTopMargin()) * this.zoomFactor - (double)this.sceneScrollPane.getVerticalScrollBar().getValue() : (10.0 + (double)jd.getLeftMargin()) * this.zoomFactor - (double)this.sceneScrollPane.getHorizontalScrollBar().getValue();
            if (newZeroPos != this.zeroPos) {
                needRefresh = true;
            }
        }
        if (needRefresh) {
            this.refreshRuler();
        }
    }

    public void sceneValidating() {
    }

    public void sceneValidated() {
    }

    public void componentResized(ComponentEvent e) {
        this.refreshRuler();
    }

    public void componentMoved(ComponentEvent e) {
        this.refreshRuler();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    private JScrollPane findScrollPane(JComponent component) {
        while (component != null) {
            if (component instanceof JScrollPane) {
                return (JScrollPane)component;
            }
            Container parent = component.getParent();
            if (!(parent instanceof JComponent)) {
                return null;
            }
            component = (JComponent)parent;
        }
        return null;
    }

    public void refreshRuler() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (RulerPanel.this.getScene() != null) {
                    RulerPanel.this.zoomFactor = RulerPanel.this.getScene().getZoomFactor();
                    JasperDesign jd = RulerPanel.this.getScene().getJasperDesign();
                    if (jd != null) {
                        RulerPanel.this.sceneScrollPane = RulerPanel.this.findScrollPane(RulerPanel.this.getScene().getView());
                        if (RulerPanel.this.isVertical()) {
                            RulerPanel.this.zeroPos = (10.0 + (double)jd.getTopMargin()) * RulerPanel.this.zoomFactor - (double)RulerPanel.this.sceneScrollPane.getVerticalScrollBar().getValue();
                        } else {
                            RulerPanel.this.zeroPos = (10.0 + (double)jd.getLeftMargin()) * RulerPanel.this.zoomFactor - (double)RulerPanel.this.sceneScrollPane.getHorizontalScrollBar().getValue();
                        }
                    }
                }
                RulerPanel.this.repaint();
            }
        });
    }

    public void fireGuideLineAdded(GuideLine guideLine) {
        for (GuideLineChangedListener listener : this.guideLineChangedListeners) {
            listener.guideLineAdded(guideLine);
        }
    }

    public void fireGuideLineRemoved(GuideLine guideLine) {
        for (GuideLineChangedListener listener : this.guideLineChangedListeners) {
            listener.guideLineRemoved(guideLine);
        }
    }

    public void fireGuideLineMoved(GuideLine guideLine) {
        for (GuideLineChangedListener listener : this.guideLineChangedListeners) {
            listener.guideLineMoved(guideLine);
        }
    }
}

