/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.outline.nodes.CrosstabNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementGroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNameVisitor;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.outline.nodes.FrameNode;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import java.beans.PropertyChangeListener;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.design.JRDesignBreak;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignEllipse;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignLine;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.util.Lookup;

public class ElementNodeVisitor
implements JRVisitor {
    public static final String ICON_BASE = "com/jaspersoft/ireport/designer/resources/";
    public static final String ICON_BREAK = "com/jaspersoft/ireport/designer/resources/break-16.png";
    public static final String ICON_CROSSTAB = "com/jaspersoft/ireport/designer/resources/crosstab-16.png";
    public static final String ICON_FRAME = "com/jaspersoft/ireport/designer/resources/frame-16.png";
    public static final String ICON_ELLIPSE = "com/jaspersoft/ireport/designer/resources/ellipse-16.png";
    public static final String ICON_LINE = "com/jaspersoft/ireport/designer/resources/line-16.png";
    public static final String ICON_RECTANGLE = "com/jaspersoft/ireport/designer/resources/rectangle-16.png";
    public static final String ICON_ROUND_RECTANGLE = "com/jaspersoft/ireport/designer/resources/roundrectangle-16.png";
    public static final String ICON_IMAGE = "com/jaspersoft/ireport/designer/resources/image-16.png";
    public static final String ICON_SUBREPORT = "com/jaspersoft/ireport/designer/resources/subreport-16.png";
    public static final String ICON_STATIC_TEXT = "com/jaspersoft/ireport/designer/resources/statictext-16.png";
    public static final String ICON_TEXT_FIELD = "com/jaspersoft/ireport/designer/resources/textfield-16.png";
    public static final String ICON_CHART = "com/jaspersoft/ireport/designer/resources/chart-16.png";
    private JasperDesign jasperDesign = null;
    private ElementNameVisitor nameVisitor = null;
    private IRIndexedNode node = null;
    private Lookup doLkp = null;

    public ElementNodeVisitor(JasperDesign jasperDesign, Lookup doLkp) {
        this.doLkp = doLkp;
        this.jasperDesign = jasperDesign;
        this.nameVisitor = new ElementNameVisitor(jasperDesign);
    }

    public IRIndexedNode getNode(JRVisitable visitable) {
        visitable.visit((JRVisitor)this);
        this.node.setDisplayName(this.nameVisitor.getName(visitable));
        return this.node;
    }

    public void visitBreak(JRBreak breakElement) {
        this.node = new ElementNode(this.jasperDesign, (JRDesignElement)((JRDesignBreak)breakElement), this.doLkp);
        this.node.setIconBaseWithExtension(ICON_BREAK);
    }

    public void visitChart(JRChart chart) {
        this.node = new ElementNode(this.jasperDesign, (JRDesignElement)((JRDesignChart)chart), this.doLkp);
        this.node.setIconBaseWithExtension(ICON_CHART);
        ((JRBaseChartPlot)((JRDesignChart)chart).getPlot()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this.node));
    }

    public void visitCrosstab(JRCrosstab crosstab) {
        this.node = new CrosstabNode(this.jasperDesign, (JRDesignCrosstab)crosstab, this.doLkp);
        this.node.setIconBaseWithExtension(ICON_CROSSTAB);
    }

    public void visitElementGroup(JRElementGroup elementGroup) {
        this.node = new ElementGroupNode(this.jasperDesign, (JRDesignElementGroup)elementGroup, this.doLkp);
    }

    public void visitEllipse(JREllipse ellipse) {
        this.node = new ElementNode(this.jasperDesign, (JRDesignElement)((JRDesignEllipse)ellipse), this.doLkp);
        this.node.setIconBaseWithExtension(ICON_ELLIPSE);
    }

    public void visitFrame(JRFrame frame) {
        this.node = new FrameNode(this.jasperDesign, (JRDesignFrame)frame, this.doLkp);
        this.node.setIconBaseWithExtension(ICON_FRAME);
    }

    public void visitImage(JRImage image) {
        this.node = new ElementNode(this.jasperDesign, (JRDesignElement)((JRDesignImage)image), this.doLkp);
        this.node.setIconBaseWithExtension(ICON_IMAGE);
    }

    public void visitLine(JRLine line) {
        this.node = new ElementNode(this.jasperDesign, (JRDesignElement)((JRDesignLine)line), this.doLkp);
        this.node.setIconBaseWithExtension(ICON_LINE);
    }

    public void visitRectangle(JRRectangle rectangle) {
        this.node = new ElementNode(this.jasperDesign, (JRDesignElement)((JRDesignRectangle)rectangle), this.doLkp);
        if (rectangle.getRadius() > 0) {
            this.node.setIconBaseWithExtension(ICON_ROUND_RECTANGLE);
        } else {
            this.node.setIconBaseWithExtension(ICON_RECTANGLE);
        }
    }

    public void visitStaticText(JRStaticText staticText) {
        this.node = new ElementNode(this.jasperDesign, (JRDesignElement)((JRDesignStaticText)staticText), this.doLkp);
        this.node.setIconBaseWithExtension(ICON_STATIC_TEXT);
    }

    public void visitSubreport(JRSubreport subreport) {
        this.node = new ElementNode(this.jasperDesign, (JRDesignElement)((JRDesignSubreport)subreport), this.doLkp);
        this.node.setIconBaseWithExtension(ICON_SUBREPORT);
    }

    public void visitTextField(JRTextField textField) {
        this.node = new ElementNode(this.jasperDesign, (JRDesignElement)((JRDesignTextField)textField), this.doLkp);
        this.node.setIconBaseWithExtension(ICON_TEXT_FIELD);
    }
}

