/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.errorhandler;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.JrxmlVisualViewActivatedListener;
import com.jaspersoft.ireport.designer.errorhandler.ErrorLocator;
import com.jaspersoft.ireport.designer.errorhandler.NodeCellRenderer;
import com.jaspersoft.ireport.designer.errorhandler.ProblemIconTableCellRenderer;
import com.jaspersoft.ireport.designer.errorhandler.ProblemItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.openide.nodes.Node;

public class ErrorHandlerPanel
extends JPanel
implements JrxmlVisualViewActivatedListener {
    private ErrorLocator locator = null;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public ErrorHandlerPanel() {
        this.initComponents();
        this.jTable1.getColumnModel().getColumn(0).setMinWidth(20);
        this.jTable1.getColumnModel().getColumn(0).setMaxWidth(20);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.jTable1.getColumnModel().getColumn(0).setCellRenderer(new ProblemIconTableCellRenderer());
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(500);
        this.jTable1.getColumnModel().getColumn(2).setPreferredWidth(250);
        this.jTable1.getColumnModel().getColumn(2).setCellRenderer(new NodeCellRenderer());
        IReportManager.getInstance().addJrxmlVisualViewActivatedListener(this);
        this.refreshErrors();
        this.locator = new ErrorLocator();
    }

    void refreshErrors() {
        JrxmlVisualView view = IReportManager.getInstance().getActiveVisualView();
        if (view != null) {
            List<ProblemItem> items = view.getReportProblems();
            ((DefaultTableModel)this.jTable1.getModel()).setRowCount(0);
            for (ProblemItem item : items) {
                Object errorSource = item.getProblemReference();
                Node node = IReportManager.getInstance().findNodeOf(errorSource, view.getExplorerManager().getRootContext());
                if (node != null) {
                    errorSource = node;
                }
                ((DefaultTableModel)this.jTable1.getModel()).addRow(new Object[]{item, item.getDescription(), errorSource});
            }
        } else {
            ((DefaultTableModel)this.jTable1.getModel()).setRowCount(0);
        }
        this.jTable1.updateUI();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new BorderLayout());
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Description", "Object"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ErrorHandlerPanel.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        JrxmlVisualView view;
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2 && this.jTable1.getSelectedRowCount() > 0 && (view = IReportManager.getInstance().getActiveVisualView()) != null) {
            ProblemItem item = (ProblemItem)this.jTable1.getValueAt(this.jTable1.getSelectedRow(), 0);
            this.locator.locateError(IReportManager.getInstance().getActiveVisualView(), item);
        }
    }

    public void jrxmlVisualViewActivated(JrxmlVisualView view) {
        this.refreshErrors();
    }
}

