/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.gui.ConnectionDialog;
import com.jaspersoft.ireport.designer.data.WizardFieldsProvider;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.wizards.ConnectionSelectionWizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;

public final class ConnectionSelectionVisualPanel
extends JPanel {
    private ConnectionSelectionWizardPanel panel = null;
    private boolean useQuery = false;
    private JButton jButton1;
    private JButton jButtonDesign;
    private JButton jButtonLoadQuery;
    private JButton jButtonSaveQuery;
    private JComboBox jComboBoxConnections;
    private JEditorPane jEditorPaneQuery;
    private JLabel jLabel1;
    private JLabel jLabelLanguageName;
    private JPanel jPanel1;
    private JPanel jPanelMain;
    private JPanel jPanelQuery;
    private JScrollPane jScrollPane1;

    public ConnectionSelectionVisualPanel(ConnectionSelectionWizardPanel panel) {
        this.panel = panel;
        this.initComponents();
        this.updateConnections();
        this.jEditorPaneQuery.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ConnectionSelectionVisualPanel.this.getPanel().fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                ConnectionSelectionVisualPanel.this.getPanel().fireChangeEvent();
            }

            public void changedUpdate(DocumentEvent e) {
                ConnectionSelectionVisualPanel.this.getPanel().fireChangeEvent();
            }
        });
    }

    private void updateConnections() {
        this.jComboBoxConnections.removeAllItems();
        List<IReportConnection> cons = IReportManager.getInstance().getConnections();
        for (IReportConnection con : cons) {
            this.jComboBoxConnections.addItem(con);
        }
    }

    public String getName() {
        return "Query";
    }

    public IReportConnection getConnection() {
        return (IReportConnection)this.jComboBoxConnections.getSelectedItem();
    }

    public String getQuery() {
        if (this.isUseQuery()) {
            return this.jEditorPaneQuery.getText();
        }
        return null;
    }

    private void initComponents() {
        this.jPanelQuery = new JPanel();
        this.jLabelLanguageName = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneQuery = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.jButtonDesign = new JButton();
        this.jButtonLoadQuery = new JButton();
        this.jButtonSaveQuery = new JButton();
        this.jLabel1 = new JLabel();
        this.jComboBoxConnections = new JComboBox();
        this.jButton1 = new JButton();
        this.jPanelMain = new JPanel();
        this.jPanelQuery.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabelLanguageName, (String)"Report query");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 4, 0);
        this.jPanelQuery.add((Component)this.jLabelLanguageName, gridBagConstraints);
        this.jEditorPaneQuery.setPreferredSize(new Dimension(20, 20));
        this.jScrollPane1.setViewportView(this.jEditorPaneQuery);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelQuery.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonDesign, (String)"Design query");
        this.jButtonDesign.setEnabled(false);
        this.jButtonDesign.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionSelectionVisualPanel.this.jButtonDesignActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jButtonDesign, gridBagConstraints);
        this.jButtonLoadQuery.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/data/folder_database.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonLoadQuery, (String)"Load query");
        this.jButtonLoadQuery.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonLoadQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionSelectionVisualPanel.this.jButtonLoadQueryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jButtonLoadQuery, gridBagConstraints);
        this.jButtonSaveQuery.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/data/database_save.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSaveQuery, (String)"Save query");
        this.jButtonSaveQuery.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonSaveQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionSelectionVisualPanel.this.jButtonSaveQueryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jButtonSaveQuery, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanelQuery.add((Component)this.jPanel1, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)"Connections / Data Sources");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 4, 0, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBoxConnections.setMinimumSize(new Dimension(28, 20));
        this.jComboBoxConnections.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionSelectionVisualPanel.this.jComboBoxConnectionsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.jComboBoxConnections, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)"New");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionSelectionVisualPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jPanelMain.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jPanelMain, gridBagConstraints);
    }

    private void jComboBoxConnectionsActionPerformed(ActionEvent evt) {
        IReportConnection con = (IReportConnection)this.jComboBoxConnections.getSelectedItem();
        if (con instanceof WizardFieldsProvider) {
            WizardFieldsProvider wFieldsProvider = (WizardFieldsProvider)((Object)con);
            String lang = wFieldsProvider.getQueryLanguage();
            if (lang == null) {
                this.jPanelMain.removeAll();
                this.setUseQuery(false);
            } else {
                this.jLabelLanguageName.setText("Query (" + lang + ")");
                this.jEditorPaneQuery.setText("");
                this.jPanelMain.add((Component)this.jPanelQuery, "Center");
                this.jButtonDesign.setEnabled(wFieldsProvider.supportsDesign());
                this.setUseQuery(true);
            }
        } else {
            this.jPanelMain.removeAll();
            this.setUseQuery(false);
        }
        this.jPanelMain.updateUI();
        this.getPanel().fireChangeEvent();
    }

    private void jButtonLoadQueryActionPerformed(ActionEvent evt) {
        String query = Misc.loadSQLQuery(this);
        if (query != null) {
            this.jEditorPaneQuery.setText(query);
        }
    }

    private void jButtonSaveQueryActionPerformed(ActionEvent evt) {
        Misc.saveSQLQuery(this.jEditorPaneQuery.getText(), this);
    }

    private void jButtonDesignActionPerformed(ActionEvent evt) {
        WizardFieldsProvider wFieldsProvider;
        String q;
        IReportConnection con = (IReportConnection)this.jComboBoxConnections.getSelectedItem();
        if (con instanceof WizardFieldsProvider && (q = (wFieldsProvider = (WizardFieldsProvider)((Object)con)).designQuery(this.jEditorPaneQuery.getText())) != null) {
            this.jEditorPaneQuery.setText(q);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Window pWin = Misc.getParentWindow(this);
        ConnectionDialog cd = null;
        cd = pWin instanceof Dialog ? new ConnectionDialog((Dialog)pWin, true) : (pWin instanceof Frame ? new ConnectionDialog((Frame)pWin, true) : new ConnectionDialog((Dialog)null, true));
        cd.setVisible(true);
        if (cd.getDialogResult() == 0) {
            IReportConnection con = cd.getIReportConnection();
            IReportManager.getInstance().addConnection(con);
            IReportManager.getInstance().setDefaultConnection(con);
            IReportManager.getInstance().saveiReportConfiguration();
            this.updateConnections();
            this.jComboBoxConnections.setSelectedItem(con);
        }
    }

    public boolean isUseQuery() {
        return this.useQuery;
    }

    public void setUseQuery(boolean useQuery) {
        this.useQuery = useQuery;
    }

    public ConnectionSelectionWizardPanel getPanel() {
        return this.panel;
    }

    public void setPanel(ConnectionSelectionWizardPanel panel) {
        this.panel = panel;
    }
}

