/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.xmlrpc;

import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.net.xmlrpc.RPCServer;
import groovy.net.xmlrpc.XMLRPCMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import uk.co.wilson.net.MinMLSocketServer;
import uk.co.wilson.net.MinMLThreadPool;
import uk.co.wilson.net.http.MinMLHTTPServer;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;

public class XMLRPCServer
extends RPCServer {
    private byte[] base64 = new byte[600];
    protected static final String xmlDeclaration = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
    protected static final byte[] userAgent = "User-Agent: Groovy XML-RPC\r\n".getBytes();
    protected static final byte[] contentTypeXML = "Content-Type: text/xml\r\n".getBytes();
    protected static final byte[] contentLength = "Content-Length: ".getBytes();
    protected MinMLSocketServer server;
    protected final int minWorkers;
    protected final int maxWorkers;
    protected final int maxKeepAlives;
    protected final int workerIdleLife;
    protected final int socketReadTimeout;

    public byte[] getBase64() {
        return this.base64;
    }

    public XMLRPCServer(int minWorkers, int maxWorkers, int maxKeepAlives, int workerIdleLife, int socketReadTimeout) {
        for (int i = 0; i != this.base64.length; ++i) {
            this.base64[i] = (byte)i;
        }
        this.server = null;
        this.minWorkers = minWorkers;
        this.maxWorkers = maxWorkers;
        this.maxKeepAlives = maxKeepAlives;
        this.workerIdleLife = workerIdleLife;
        this.socketReadTimeout = socketReadTimeout;
    }

    public XMLRPCServer() {
        this(2, 10, 8, 60000, 60000);
    }

    public void startServer(ServerSocket serverSocket) throws IOException {
        if (this.server != null) {
            this.stopServer();
        }
        final MinMLHTTPServer server = new MinMLHTTPServer(serverSocket, this.minWorkers, this.maxWorkers, this.maxKeepAlives, this.workerIdleLife, this.socketReadTimeout){

            protected MinMLThreadPool.Worker makeNewWorker() {
                return new MinMLHTTPServer.HTTPWorker(){

                    protected void processPost(InputStream in, OutputStream out, String uri, String version) throws Exception {
                        try {
                            XMLRPCMessageProcessor requestParser = new XMLRPCMessageProcessor();
                            out.write(version.getBytes());
                            out.write(okMessage);
                            out.write(userAgent);
                            out.write(host);
                            out.write(contentTypeXML);
                            this.writeKeepAlive(out);
                            out.write(contentLength);
                            requestParser.parseMessage(in);
                            String methodName = requestParser.getMethodname();
                            List params = requestParser.getParams();
                            Closure closure = (Closure)(this).XMLRPCServer.this.registeredMethods.get(methodName);
                            Object result = null;
                            if ((this).XMLRPCServer.this.preCallMethod != null) {
                                (this).XMLRPCServer.this.preCallMethod.call(new Object[]{methodName, params.toArray()});
                            }
                            if (closure == null) {
                                if ((this).XMLRPCServer.this.defaultMethod == null) {
                                    throw new GroovyRuntimeException("Method " + methodName + " is not supported on this server");
                                }
                                result = (this).XMLRPCServer.this.defaultMethod.call(new Object[]{methodName, params.toArray()});
                            } else {
                                result = closure.call(params.toArray());
                            }
                            if (result == null) {
                                result = new Integer(0);
                            }
                            if ((this).XMLRPCServer.this.postCallMethod != null) {
                                (this).XMLRPCServer.this.postCallMethod.call(new Object[]{methodName, result});
                            }
                            byte[] response = XMLRPCMessageProcessor.emitResult(new StringBuffer(XMLRPCServer.xmlDeclaration), result).toString().getBytes("ISO-8859-1");
                            out.write(String.valueOf(response.length).getBytes());
                            out.write(endOfLine);
                            out.write(endOfLine);
                            out.write(response);
                        }
                        catch (Throwable e) {
                            int codeValue;
                            String message;
                            if (e instanceof InvokerInvocationException) {
                                e = ((InvokerInvocationException)e).getCause();
                            }
                            if (e instanceof XMLRPCFailException) {
                                message = ((XMLRPCFailException)e).getFaultString();
                                codeValue = ((XMLRPCFailException)e).getFaultCode();
                            } else {
                                message = e.getMessage();
                                codeValue = 0;
                            }
                            if ((this).XMLRPCServer.this.faultMethod != null) {
                                try {
                                    (this).XMLRPCServer.this.faultMethod.call(new Object[]{message, new Integer(codeValue)});
                                }
                                catch (Throwable e1) {
                                    // empty catch block
                                }
                            }
                            byte[] error = XMLRPCMessageProcessor.emitError(new StringBuffer(XMLRPCServer.xmlDeclaration), codeValue, message == null ? e.getClass().getName() : message).toString().getBytes("ISO-8859-1");
                            out.write(String.valueOf(error.length).getBytes());
                            out.write(endOfLine);
                            out.write(endOfLine);
                            out.write(error);
                        }
                    }
                };
            }
        };
        this.server = server;
        Thread startingThread = new Thread(){

            public void run() {
                server.start();
            }
        };
        startingThread.setDaemon(false);
        startingThread.setName("XML-RPC Server main thread");
        startingThread.start();
    }

    public void stopServer() throws IOException {
        this.server.shutDown();
    }
}

