/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.InvalidClassFormatException;

public abstract class VerificationTypeInfo {
    private int tag;
    public static final int ITEM_Top = 0;
    public static final int ITEM_Integer = 1;
    public static final int ITEM_Float = 2;
    public static final int ITEM_Double = 3;
    public static final int ITEM_Long = 4;
    public static final int ITEM_Null = 5;
    public static final int ITEM_UninitializedThis = 6;
    public static final int ITEM_Object = 7;
    public static final int ITEM_Uninitialized = 8;

    static VerificationTypeInfo loadVerificationTypeInfo(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        switch (n) {
            case 0: {
                return new TopVariableInfo();
            }
            case 1: {
                return new IntegerVariableInfo();
            }
            case 2: {
                return new FloatVariableInfo();
            }
            case 4: {
                return new LongVariableInfo();
            }
            case 3: {
                return new DoubleVariableInfo();
            }
            case 5: {
                return new NullVariableInfo();
            }
            case 6: {
                return new UninitializedThisVariableInfo();
            }
            case 7: {
                int n2 = dataInputStream.readUnsignedShort();
                return new ObjectVariableInfo(constantPool.get(n2));
            }
            case 8: {
                int n3 = dataInputStream.readUnsignedShort();
                return new UninitializedVariableInfo(n3);
            }
        }
        throw new InvalidClassFormatException("invalid verification_type_info tag: " + n);
    }

    VerificationTypeInfo(int n) {
        this.tag = n;
    }

    public int getTag() {
        return this.tag;
    }

    public static final class DoubleVariableInfo
    extends VerificationTypeInfo {
        DoubleVariableInfo() {
            super(3);
        }
    }

    public static final class FloatVariableInfo
    extends VerificationTypeInfo {
        FloatVariableInfo() {
            super(2);
        }
    }

    public static final class IntegerVariableInfo
    extends VerificationTypeInfo {
        IntegerVariableInfo() {
            super(1);
        }
    }

    public static final class LongVariableInfo
    extends VerificationTypeInfo {
        LongVariableInfo() {
            super(4);
        }
    }

    public static final class NullVariableInfo
    extends VerificationTypeInfo {
        NullVariableInfo() {
            super(5);
        }
    }

    public static final class ObjectVariableInfo
    extends VerificationTypeInfo {
        CPEntry cpEntry;

        ObjectVariableInfo(CPEntry cPEntry) {
            super(7);
            this.cpEntry = cPEntry;
        }

        public CPEntry getConstantPoolEntry() {
            return this.cpEntry;
        }
    }

    public static final class TopVariableInfo
    extends VerificationTypeInfo {
        TopVariableInfo() {
            super(0);
        }
    }

    public static final class UninitializedThisVariableInfo
    extends VerificationTypeInfo {
        UninitializedThisVariableInfo() {
            super(6);
        }
    }

    public static final class UninitializedVariableInfo
    extends VerificationTypeInfo {
        int offset;

        UninitializedVariableInfo(int n) {
            super(7);
            this.offset = n;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

