/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.xml.cookies;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.parsers.SAXEntityParser;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.netbeans.spi.xml.cookies.ShareableInputSource;
import org.netbeans.spi.xml.cookies.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class SharedXMLSupport {
    private CookieObserver console;
    private final InputSource inputSource;
    private final int mode;
    private Locator locator;
    private int fatalErrors;
    private int errors;
    private boolean bogusSchemaRequest;
    private boolean reportBogusSchemaRequest = Boolean.getBoolean("netbeans.xml.reportBogusSchemaLocation");

    public SharedXMLSupport(InputSource inputSource) {
        this(inputSource, 3);
    }

    public SharedXMLSupport(InputSource inputSource, int n) {
        if (inputSource == null) {
            throw new NullPointerException();
        }
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException();
        }
        this.inputSource = inputSource;
        this.mode = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkXML(CookieObserver cookieObserver) {
        try {
            this.console = cookieObserver;
            this.parse(false);
            boolean bl = this.fatalErrors == 0;
            return bl;
        }
        finally {
            this.console = null;
            this.locator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateXML(CookieObserver cookieObserver) {
        try {
            this.console = cookieObserver;
            if (this.mode != 3) {
                this.sendMessage(Util.THIS.getString("MSG_not_a_doc"));
                boolean bl = false;
                return bl;
            }
            this.parse(true);
            boolean bl = this.errors == 0 && this.fatalErrors == 0;
            return bl;
        }
        finally {
            this.console = null;
            this.locator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(boolean bl) {
        this.fatalErrors = 0;
        this.errors = 0;
        String string = this.inputSource.getSystemId();
        this.sendMessage(Util.THIS.getString("MSG_checking", string));
        Handler handler = new Handler();
        InputSource inputSource = null;
        try {
            XMLReader xMLReader = this.createParser(bl);
            if (xMLReader == null) {
                ++this.fatalErrors;
                this.console.receive(new CookieMessage(Util.THIS.getString("MSG_cannot_create_parser"), 3));
                return;
            }
            if (bl) {
                inputSource = ShareableInputSource.create(this.createInputSource());
                String[] stringArray = this.getSchemaLocations(inputSource);
                try {
                    ((ShareableInputSource)inputSource).reset();
                }
                catch (IOException iOException) {
                    inputSource = this.createInputSource();
                }
                if (stringArray != null && stringArray.length > 0) {
                    boolean bl2 = true;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(bl2 ? stringArray[i] : " " + stringArray[i]);
                        bl2 = false;
                    }
                    xMLReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", stringBuffer.toString());
                }
            } else {
                inputSource = this.createInputSource();
            }
            xMLReader.setErrorHandler(handler);
            xMLReader.setContentHandler(handler);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(string + ":" + this.parserDescription(xMLReader));
            }
            if (this.mode == 1) {
                new SAXEntityParser(xMLReader, true).parse(inputSource);
            } else if (this.mode == 2) {
                new SAXEntityParser(xMLReader, false).parse(inputSource);
            } else {
                xMLReader.parse(inputSource);
            }
        }
        catch (SAXException sAXException) {
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            handler.fatalError(new SAXParseException(fileStateInvalidException.getLocalizedMessage(), this.locator, (Exception)((Object)fileStateInvalidException)));
        }
        catch (IOException iOException) {
            handler.fatalError(new SAXParseException(iOException.getLocalizedMessage(), this.locator, iOException));
        }
        catch (RuntimeException runtimeException) {
            handler.runtimeError(runtimeException);
        }
        finally {
            if (inputSource instanceof ShareableInputSource) {
                try {
                    ((ShareableInputSource)inputSource).closeAll();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected EntityResolver createEntityResolver() {
        UserCatalog userCatalog = UserCatalog.getDefault();
        return userCatalog == null ? null : userCatalog.getEntityResolver();
    }

    protected InputSource createInputSource() throws IOException {
        return this.inputSource;
    }

    protected XMLReader createParser(boolean bl) {
        Object object;
        XMLReader xMLReader = null;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(bl);
        if (bl) {
            try {
                sAXParserFactory.setFeature("http://apache.org/xml/features/validation/schema", bl);
            }
            catch (Exception exception) {
                this.sendMessage(Util.THIS.getString("MSG_parser_no_schema"));
            }
        }
        try {
            object = sAXParserFactory.newSAXParser();
            xMLReader = ((SAXParser)object).getXMLReader();
        }
        catch (Exception exception) {
            this.sendMessage(Util.THIS.getString("MSG_parser_err_1"));
            return null;
        }
        if (xMLReader != null && (object = this.createEntityResolver()) != null) {
            xMLReader.setEntityResolver(new VerboseEntityResolver((EntityResolver)object));
        }
        return xMLReader;
    }

    private String parserDescription(XMLReader xMLReader) {
        Class<?> clazz = xMLReader.getClass();
        try {
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null && (clazz.getClassLoader() == null || clazz.getClassLoader().equals(Object.class.getClassLoader()))) {
                return Util.THIS.getString("MSG_platform_parser");
            }
            if (codeSource == null) {
                return Util.THIS.getString("MSG_unknown_parser", clazz.getName());
            }
            URL uRL = codeSource.getLocation();
            return Util.THIS.getString("MSG_parser_plug", uRL.toExternalForm());
        }
        catch (SecurityException securityException) {
            return Util.THIS.getString("MSG_unknown_parser", clazz.getName());
        }
    }

    private void sendMessage(String string) {
        if (this.console != null) {
            this.console.receive(new CookieMessage(string));
        }
    }

    private String[] getSchemaLocations(InputSource inputSource) {
        EntityResolver entityResolver = this.createEntityResolver();
        if (entityResolver == null) {
            return null;
        }
        NsHandler nsHandler = this.getNamespaces(inputSource);
        String[] stringArray = nsHandler.getNamespaces();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (nsHandler.mapping.containsKey(string)) {
                arrayList.add(string + " " + nsHandler.mapping.get(string));
                continue;
            }
            try {
                Source source = ((URIResolver)((Object)entityResolver)).resolve(string, null);
                if (source == null) continue;
                arrayList.add(string + " " + source.getSystemId());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    private NsHandler getNamespaces(InputSource inputSource) {
        NsHandler nsHandler = new NsHandler();
        try {
            EntityResolver entityResolver;
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            xMLReader.setContentHandler(nsHandler);
            UserCatalog userCatalog = UserCatalog.getDefault();
            if (userCatalog != null && (entityResolver = userCatalog.getEntityResolver()) != null) {
                xMLReader.setEntityResolver(entityResolver);
            }
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().notify(1, (Throwable)sAXException);
        }
        return nsHandler;
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        public void warning(SAXParseException sAXParseException) {
            String string = sAXParseException.getLocalizedMessage();
            if (SharedXMLSupport.this.bogusSchemaRequest) {
                SharedXMLSupport.this.bogusSchemaRequest = false;
                if (string != null && string.indexOf("schema_reference.4") != -1) {
                    if (SharedXMLSupport.this.reportBogusSchemaRequest) {
                        SharedXMLSupport.this.reportBogusSchemaRequest = false;
                    } else {
                        return;
                    }
                }
            }
            CookieMessage cookieMessage = new CookieMessage(string, 1, new DefaultXMLProcessorDetail(sAXParseException));
            if (SharedXMLSupport.this.console != null) {
                SharedXMLSupport.this.console.receive(cookieMessage);
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Just diagnostic exception", sAXParseException);
            }
            if (SharedXMLSupport.this.errors++ == this.getMaxErrorCount()) {
                String string = Util.THIS.getString("MSG_too_many_errs");
                SharedXMLSupport.this.sendMessage(string);
                throw sAXParseException;
            }
            CookieMessage cookieMessage = new CookieMessage(sAXParseException.getLocalizedMessage(), 2, new DefaultXMLProcessorDetail(sAXParseException));
            if (SharedXMLSupport.this.console != null) {
                SharedXMLSupport.this.console.receive(cookieMessage);
            }
        }

        private void runtimeError(RuntimeException runtimeException) {
            Util.THIS.debug("Parser runtime exception", runtimeException);
            String string = Util.THIS.getString("EX_parser_ierr", runtimeException.getMessage());
            this.fatalError(new SAXParseException(string, SharedXMLSupport.this.locator, runtimeException));
        }

        public void fatalError(SAXParseException sAXParseException) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Just diagnostic exception", sAXParseException);
            }
            SharedXMLSupport.this.fatalErrors++;
            CookieMessage cookieMessage = new CookieMessage(sAXParseException.getLocalizedMessage(), 3, new DefaultXMLProcessorDetail(sAXParseException));
            if (SharedXMLSupport.this.console != null) {
                SharedXMLSupport.this.console.receive(cookieMessage);
            }
        }

        public void setDocumentLocator(Locator locator) {
            SharedXMLSupport.this.locator = locator;
        }

        private int getMaxErrorCount() {
            return 20;
        }
    }

    private static class NsHandler
    extends DefaultHandler {
        Set namespaces = new HashSet();
        private Map mapping = new HashMap();

        NsHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            StringTokenizer stringTokenizer;
            String string4;
            if (attributes.getLength() > 0 && (string4 = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation")) != null && (stringTokenizer = new StringTokenizer(string4)).countTokens() % 2 == 0) {
                while (stringTokenizer.hasMoreElements()) {
                    String string5 = stringTokenizer.nextToken();
                    String string6 = stringTokenizer.nextToken();
                    this.mapping.put(string5, string6);
                }
            }
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(string2)) {
                return;
            }
            this.namespaces.add(string2);
        }

        String[] getNamespaces() {
            String[] stringArray = new String[this.namespaces.size()];
            this.namespaces.toArray(stringArray);
            return stringArray;
        }
    }

    private class VerboseEntityResolver
    implements EntityResolver {
        private final EntityResolver peer;

        public VerboseEntityResolver(EntityResolver entityResolver) {
            if (entityResolver == null) {
                throw new NullPointerException();
            }
            this.peer = entityResolver;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            InputSource inputSource = this.peer.resolveEntity(string, string2);
            if (inputSource == null) {
                String string3;
                SharedXMLSupport.this.bogusSchemaRequest = string == null && string2 == null;
                if (SharedXMLSupport.this.bogusSchemaRequest) {
                    return null;
                }
                String string4 = string != null ? string : Util.THIS.getString("MSG_no_pid");
                try {
                    String string5 = new URL(string2).getFile();
                    string3 = string5 != null ? Util.THIS.getString("MSG_resolver_1", string4, string2) : Util.THIS.getString("MSG_resolver_2", string4, string2);
                }
                catch (MalformedURLException malformedURLException) {
                    string3 = Util.THIS.getString("MSG_resolver_3", string4, string2);
                }
                SharedXMLSupport.this.sendMessage(string3);
            }
            return inputSource;
        }
    }
}

