/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Table;

public class ForeignKey
extends Constraint {
    private Table referencedTable;
    private String referencedEntityName;
    private boolean cascadeDeleteEnabled;

    public String sqlConstraintString(Dialect dialect, String constraintName, String defaultCatalog, String defaultSchema) {
        String[] cols = new String[this.getColumnSpan()];
        String[] refcols = new String[this.getColumnSpan()];
        int i = 0;
        Iterator refiter = this.referencedTable.getPrimaryKey().getColumnIterator();
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            cols[i] = ((Column)iter.next()).getQuotedName(dialect);
            refcols[i] = ((Column)refiter.next()).getQuotedName(dialect);
            ++i;
        }
        String result = dialect.getAddForeignKeyConstraintString(constraintName, cols, this.referencedTable.getQualifiedName(dialect, defaultCatalog, defaultSchema), refcols);
        return this.cascadeDeleteEnabled ? result + " on delete cascade" : result;
    }

    public Table getReferencedTable() {
        return this.referencedTable;
    }

    private void appendColumns(StringBuffer buf, Iterator columns) {
        while (columns.hasNext()) {
            Column column = (Column)columns.next();
            buf.append(column.getName());
            if (!columns.hasNext()) continue;
            buf.append(",");
        }
    }

    public void setReferencedTable(Table referencedTable) throws MappingException {
        this.alignColumns(referencedTable);
        this.referencedTable = referencedTable;
    }

    private void alignColumns(Table referencedTable) {
        if (referencedTable.getPrimaryKey().getColumnSpan() != this.getColumnSpan()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Foreign key (").append(this.getName() + ":").append(this.getTable().getName()).append(" [");
            this.appendColumns(sb, this.getColumnIterator());
            sb.append("])").append(") must have same number of columns as the referenced primary key (").append(referencedTable.getName()).append(" [");
            this.appendColumns(sb, referencedTable.getPrimaryKey().getColumnIterator());
            sb.append("])");
            throw new MappingException(sb.toString());
        }
        Iterator fkCols = this.getColumnIterator();
        Iterator pkCols = referencedTable.getPrimaryKey().getColumnIterator();
        while (pkCols.hasNext()) {
            ((Column)fkCols.next()).setLength(((Column)pkCols.next()).getLength());
        }
    }

    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public String sqlDropString(Dialect dialect, String defaultCatalog, String defaultSchema) {
        return "alter table " + this.getTable().getQualifiedName(dialect, defaultCatalog, defaultSchema) + dialect.getDropForeignKeyString() + this.getName();
    }

    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    public void setCascadeDeleteEnabled(boolean cascadeDeleteEnabled) {
        this.cascadeDeleteEnabled = cascadeDeleteEnabled;
    }

    public boolean isPhysicalConstraint() {
        return this.referencedTable.isPhysicalTable() && this.getTable().isPhysicalTable() && !this.referencedTable.hasDenormalizedTables();
    }
}

