/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.util.JoinedIterator;

public class DenormalizedTable
extends Table {
    private final Table includedTable;

    public DenormalizedTable(Table includedTable) {
        this.includedTable = includedTable;
        includedTable.setHasDenormalizedTables();
    }

    public void createForeignKeys() {
        this.includedTable.createForeignKeys();
        Iterator iter = this.includedTable.getForeignKeyIterator();
        while (iter.hasNext()) {
            ForeignKey fk = (ForeignKey)iter.next();
            this.createForeignKey(fk.getName() + Integer.toHexString(this.getName().hashCode()), fk.getColumns(), fk.getReferencedEntityName());
        }
    }

    public Iterator getColumnIterator() {
        return new JoinedIterator(this.includedTable.getColumnIterator(), super.getColumnIterator());
    }

    public boolean containsColumn(Column column) {
        return super.containsColumn(column) || this.includedTable.containsColumn(column);
    }

    public PrimaryKey getPrimaryKey() {
        return this.includedTable.getPrimaryKey();
    }
}

