/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.actions;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.ui.InstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateSettings;
import org.netbeans.modules.autoupdate.ui.actions.AvailableUpdatesNotification;
import org.netbeans.modules.autoupdate.ui.actions.PluginManagerAction;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoupdateCheckScheduler {
    private static RequestProcessor.Task regularlyCheck = null;
    private static final RequestProcessor REGULARLY_CHECK_TIMER = new RequestProcessor("auto-checker-reqularly-timer", 1, true);
    private static final Logger err = Logger.getLogger(AutoupdateCheckScheduler.class.getName());
    private static Runnable doCheckAvailableUpdates = new Runnable(){

        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post(doCheckAvailableUpdates);
            }
            boolean bl = false;
            if (Utilities.shouldCheckAvailableUpdates()) {
                Collection collection = AutoupdateCheckScheduler.checkUpdateElements(OperationWizardModel.OperationType.UPDATE);
                boolean bl2 = bl = collection != null && !collection.isEmpty();
                if (bl) {
                    AutoupdateCheckScheduler.notifyAvailable(collection, OperationWizardModel.OperationType.UPDATE);
                }
            }
            if (!bl && Utilities.shouldCheckAvailableNewPlugins()) {
                AutoupdateCheckScheduler.notifyAvailable(AutoupdateCheckScheduler.checkUpdateElements(OperationWizardModel.OperationType.INSTALL), OperationWizardModel.OperationType.INSTALL);
            }
        }
    };
    private static Runnable doCheck = new Runnable(){

        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post(doCheck);
            }
            AutoupdateCheckScheduler.scheduleRefreshProviders();
        }
    };
    private static AvailableUpdatesNotification.UpdatesFlasher flasher;

    private AutoupdateCheckScheduler() {
    }

    public static void signOn() {
        AutoupdateSettings.getIdeIdentity();
        if (AutoupdateCheckScheduler.timeToCheck()) {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                public void run() {
                    RequestProcessor.getDefault().post(doCheck, 5000);
                }
            });
        } else {
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                public void run() {
                    RequestProcessor.getDefault().post(doCheckAvailableUpdates, 5000);
                }
            });
        }
    }

    private static void scheduleRefreshProviders() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run refreshProviders in EQ!";
        HashSet<RequestProcessor.Task> hashSet = new HashSet<RequestProcessor.Task>();
        for (UpdateUnitProvider updateUnitProvider : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
            RequestProcessor.Task task = RequestProcessor.getDefault().post(AutoupdateCheckScheduler.getRefresher(updateUnitProvider));
            hashSet.add(task);
        }
        err.log(Level.FINEST, "Waiting for all refreshTasks...");
        for (RequestProcessor.Task task : hashSet) {
            task.waitFinished();
        }
        err.log(Level.FINEST, "Waiting for all refreshTasks is done.");
        RequestProcessor.getDefault().post(doCheckAvailableUpdates, 500);
    }

    private static Runnable getRefresher(final UpdateUnitProvider updateUnitProvider) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    err.log(Level.FINE, "Start refresh " + updateUnitProvider.getName() + "[" + updateUnitProvider.getDisplayName() + "]");
                    updateUnitProvider.refresh(null, true);
                    PluginManagerUI pluginManagerUI = PluginManagerAction.getPluginManagerUI();
                    if (pluginManagerUI != null) {
                        pluginManagerUI.updateUnitsChanged();
                    }
                }
                catch (IOException iOException) {
                    err.log(Level.INFO, iOException.getMessage(), iOException);
                }
                finally {
                    err.log(Level.FINEST, "Refresh of " + updateUnitProvider.getName() + "[" + updateUnitProvider.getDisplayName() + "]" + " is finish.");
                }
            }
        };
    }

    private static Collection<UpdateElement> checkUpdateElements(OperationWizardModel.OperationType operationType) {
        List<UnitCategory> list;
        err.log(Level.FINEST, "Check UpdateElements for " + (Object)((Object)operationType));
        List list2 = UpdateManager.getDefault().getUpdateUnits(Utilities.getUnitTypes());
        boolean bl = OperationWizardModel.OperationType.UPDATE == operationType;
        List<UnitCategory> list3 = list = bl ? Utilities.makeUpdateCategories(list2, false) : Utilities.makeAvailableCategories(list2, false);
        if (list == null || list.isEmpty()) {
            err.log(Level.FINE, "findUpdateElements(" + (Object)((Object)operationType) + ") doesn't find any elements.");
            return null;
        }
        OperationContainer operationContainer = bl ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (UnitCategory unitCategory : list) {
            for (Unit unit : unitCategory.getUnits()) {
                UpdateElement updateElement = bl ? ((Unit.Update)unit).getRelevantElement() : ((Unit.Available)unit).getRelevantElement();
                UpdateUnit updateUnit = updateElement.getUpdateUnit();
                if (!operationContainer.canBeAdded(updateUnit, updateElement)) continue;
                OperationContainer.OperationInfo operationInfo = operationContainer.add(updateElement);
                operationContainer.add((Collection)operationInfo.getRequiredElements());
                HashSet hashSet2 = new HashSet();
                for (OperationContainer.OperationInfo operationInfo2 : operationContainer.listAll()) {
                    hashSet2.addAll(operationInfo2.getBrokenDependencies());
                }
                if (hashSet2.isEmpty() && operationContainer.listInvalid().isEmpty()) {
                    hashSet.add(updateElement);
                    continue;
                }
                operationContainer.removeAll();
                if (!hashSet2.isEmpty()) {
                    err.log(Level.WARNING, "Plugin " + updateElement + " cannot be installed, some dependencies can be satisfied: " + hashSet2);
                    continue;
                }
                err.log(Level.WARNING, "Plugin " + updateElement + " cannot be installed, Install Container contains invalid elements " + operationContainer.listInvalid());
            }
        }
        err.log(Level.FINE, "findUpdateElements(" + (Object)((Object)operationType) + ") returns " + hashSet.size() + " elements.");
        return hashSet;
    }

    public static boolean timeToCheck() {
        if (AutoupdateCheckScheduler.getReqularlyTimerTask() != null && AutoupdateCheckScheduler.getReqularlyTimerTask().getDelay() <= 0 && AutoupdateCheckScheduler.getWaitPeriod() > 0) {
            AutoupdateCheckScheduler.getReqularlyTimerTask().schedule(AutoupdateCheckScheduler.getWaitPeriod());
            return true;
        }
        if (AutoupdateSettings.getLastCheck() == null) {
            return true;
        }
        switch (AutoupdateSettings.getPeriod()) {
            case 0: {
                return true;
            }
            case 5: {
                return false;
            }
        }
        Date date = AutoupdateSettings.getLastCheck();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(10, 0);
        gregorianCalendar.set(9, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        switch (AutoupdateSettings.getPeriod()) {
            case 1: {
                gregorianCalendar.add(5, 1);
                break;
            }
            case 2: {
                gregorianCalendar.add(3, 1);
                break;
            }
            case 3: {
                gregorianCalendar.add(3, 2);
                break;
            }
            case 4: {
                gregorianCalendar.add(2, 1);
            }
        }
        return gregorianCalendar.getTime().before(new Date());
    }

    private static RequestProcessor.Task getReqularlyTimerTask() {
        if (regularlyCheck == null && AutoupdateCheckScheduler.getWaitPeriod() > 0) {
            int n;
            int n2 = n = AutoupdateCheckScheduler.getWaitPeriod();
            if (AutoupdateSettings.getLastCheck() != null) {
                n2 = n - (int)(System.currentTimeMillis() - AutoupdateSettings.getLastCheck().getTime());
            }
            if (n2 <= 0) {
                n2 = n;
            }
            regularlyCheck = REGULARLY_CHECK_TIMER.post(doCheck, n2, 1);
        }
        return regularlyCheck;
    }

    private static int getWaitPeriod() {
        switch (AutoupdateSettings.getPeriod()) {
            case 5: {
                return 0;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 86400000;
            }
            case 2: {
                return 604800000;
            }
            case 3: {
                return 1209600000;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    private static void notifyAvailable(final Collection<UpdateElement> collection, final OperationWizardModel.OperationType operationType) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                boolean bl = false;
                try {
                    object = OperationWizardModel.OperationType.UPDATE == operationType ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
                    object.add(collection);
                    bl = new InstallUnitWizard().invokeWizard(new InstallUnitWizardModel(operationType, (OperationContainer<InstallSupport>)object));
                }
                finally {
                    if (bl) {
                        object = PluginManagerAction.getPluginManagerUI();
                        if (object != null) {
                            ((PluginManagerUI)object).updateUnitsChanged();
                        }
                        if (flasher != null) {
                            flasher.disappear();
                        }
                    }
                }
            }
        };
        flasher = AvailableUpdatesNotification.getFlasher(runnable);
        assert (flasher != null) : "Updates Flasher cannot be null.";
        flasher.setToolTipText(collection.size() == 1 ? NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_UpdateFound_ToolTip", (Object)collection.size()) : NbBundle.getMessage(AutoupdateCheckScheduler.class, (String)"AutoupdateCheckScheduler_UpdatesFound_ToolTip", (Object)collection.size()));
        flasher.startFlashing();
    }
}

