/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawEngineLineView;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.Utilities;
import org.openide.util.NbBundle;

public class CodeFoldingSideBar
extends JComponent
implements SettingsChangeListener,
Accessible {
    protected JTextComponent component;
    protected Font font;
    protected Color foreColor;
    protected Color backColor;
    private boolean enabled;
    protected List visibleMarks = new ArrayList();
    public static final int PAINT_NOOP = 0;
    public static final int PAINT_MARK = 1;
    public static final int PAINT_LINE = 2;
    public static final int PAINT_END_MARK = 3;
    public static final int SINGLE_PAINT_MARK = 4;

    public CodeFoldingSideBar() {
        this.setOpaque(true);
    }

    public CodeFoldingSideBar(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        Settings.addSettingsChangeListener(this);
        this.settingsChange(null);
        FoldingMouseListener foldingMouseListener = new FoldingMouseListener();
        this.addMouseListener(foldingMouseListener);
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
        foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)new SideBarFoldHierarchyListener());
        Document document = this.getDocument();
        document.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!(documentEvent instanceof BaseDocumentEvent)) {
                    return;
                }
                BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
                if (baseDocumentEvent.getLFCount() > 0) {
                    CodeFoldingSideBar.this.repaint();
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!(documentEvent instanceof BaseDocumentEvent)) {
                    return;
                }
                BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
                if (baseDocumentEvent.getLFCount() > 0) {
                    CodeFoldingSideBar.this.repaint();
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.setOpaque(true);
    }

    private boolean enableSideBarComponent(boolean bl) {
        if (bl == this.enabled) {
            return false;
        }
        this.enabled = bl;
        this.updatePreferredSize();
        return true;
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setPreferredSize(new Dimension(this.getColoringFont().getSize(), this.component.getHeight()));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    private Font getDefaultColoringFont() {
        Coloring coloring;
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (coloring = editorUI.getDefaultColoring()) != null && coloring.getFont() != null) {
            return coloring.getFont();
        }
        return SettingsDefaults.defaultFont;
    }

    protected Font getColoringFont() {
        if (this.font == null) {
            Coloring coloring;
            EditorUI editorUI = this.getEditorUI();
            if (editorUI != null && (coloring = editorUI.getColoring("code-folding-bar")) != null && coloring.getFont() != null) {
                this.font = coloring.getFont();
            }
            if (this.font == null) {
                this.font = this.getDefaultColoringFont();
            }
        }
        return this.font;
    }

    public void update(Graphics graphics) {
    }

    protected Color getForeColor() {
        if (this.foreColor != null) {
            return this.foreColor;
        }
        Coloring coloring = this.getEditorUI().getColoring("code-folding-bar");
        if (coloring != null && coloring.getForeColor() != null) {
            this.foreColor = coloring.getForeColor();
            return this.foreColor;
        }
        this.foreColor = this.getDefaultForeColor();
        return this.foreColor;
    }

    private Color getDefaultForeColor() {
        Coloring coloring = this.getEditorUI().getDefaultColoring();
        if (coloring != null && coloring.getForeColor() != null) {
            return coloring.getForeColor();
        }
        return SettingsDefaults.defaultForeColor;
    }

    private Color getDefaultBackColor() {
        Coloring coloring;
        EditorUI editorUI = this.getEditorUI();
        if (editorUI != null && (coloring = editorUI.getDefaultColoring()) != null) {
            return coloring.getBackColor();
        }
        return SettingsDefaults.defaultBackColor;
    }

    protected Color getBackColor() {
        if (this.backColor != null) {
            return this.backColor;
        }
        Coloring coloring = this.getEditorUI().getColoring("code-folding-bar");
        if (coloring != null && coloring.getBackColor() != null) {
            this.backColor = coloring.getBackColor();
            return this.backColor;
        }
        this.backColor = this.getDefaultBackColor();
        return this.backColor;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        Boolean bl;
        boolean bl2;
        EditorUI editorUI = this.getEditorUI();
        if (editorUI == null) {
            return;
        }
        Document document = this.component.getDocument();
        Class clazz = document instanceof BaseDocument ? Utilities.getKitClass(this.component) : BaseKit.class;
        Font font = this.font;
        Coloring coloring = editorUI.getColoring("code-folding-bar");
        if (coloring != null) {
            this.font = coloring.getFont();
            this.foreColor = coloring.getForeColor();
            this.backColor = coloring.getBackColor();
        }
        if (this.font == null) {
            this.font = this.getDefaultColoringFont();
        }
        if (this.foreColor == null) {
            this.foreColor = this.getDefaultForeColor();
        }
        if (this.backColor == null) {
            this.backColor = this.getDefaultBackColor();
        }
        if (!(bl2 = this.enableSideBarComponent((bl = (Boolean)Settings.getValue(clazz, "code-folding-enable")) != null ? bl : false))) {
            if (this.font != null && this.font.equals(font)) {
                this.repaint();
            } else {
                this.updatePreferredSize();
                this.revalidate();
            }
        }
    }

    protected void collectPaintInfos(Fold fold, Map map, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        View view = Utilities.getDocumentView(this.component);
        if (view == null) {
            return;
        }
        for (n6 = 0; n6 < fold.getFoldCount(); ++n6) {
            n5 = view.getViewIndex(fold.getFold(n6).getStartOffset(), Position.Bias.Forward);
            n4 = view.getViewIndex(fold.getFold(n6).getEndOffset(), Position.Bias.Forward);
            if (n4 < n2 || n5 > n3) continue;
            this.collectPaintInfos(fold.getFold(n6), map, n + 1, n2, n3);
        }
        n6 = fold.getStartOffset();
        n5 = fold.getEndOffset();
        if (n5 > (n4 = view.getDocument().getLength())) {
            return;
        }
        int n7 = view.getViewIndex(n6, Position.Bias.Forward);
        int n8 = view.getViewIndex(n5, Position.Bias.Forward);
        try {
            int n9;
            Rectangle rectangle;
            View view2;
            Rectangle rectangle2;
            BaseTextUI baseTextUI = (BaseTextUI)this.component.getUI();
            int n10 = -1;
            int n11 = -1;
            if (n2 <= n7 && (rectangle2 = baseTextUI.modelToView(this.component, (view2 = view.getView(n7)).getStartOffset())) != null) {
                rectangle = rectangle2.getBounds();
                n11 = rectangle.y + rectangle.height;
                int n12 = n9 = n7 == n8 ? 1 : 0;
                if (fold.isCollapsed() || n9 != 0) {
                    map.put(new Integer(rectangle.y), new PaintInfo(n9 != 0 ? 4 : 1, n, rectangle.y, rectangle.height, fold.isCollapsed()));
                    return;
                }
                n10 = rectangle.y;
                map.put(new Integer(rectangle.y), new PaintInfo(1, n, rectangle.y, rectangle.height, fold.isCollapsed()));
            }
            if (n == 0) {
                n9 = n7 < n2 ? n2 : n7 + 1;
                int n13 = n8 > n3 ? n3 : n8;
                rectangle = null;
                for (int i = n9; i <= n13; ++i) {
                    view2 = view.getView(i);
                    if (view2 instanceof DrawEngineLineView && n11 > -1) {
                        int n14 = (int)((DrawEngineLineView)view2).getLayoutMajorAxisPreferredSpan();
                        rectangle = new Rectangle(0, n11, 0, n14);
                        if (i < n13 && n13 > n9) {
                            n11 += n14;
                        }
                    } else {
                        rectangle2 = baseTextUI.modelToView(this.component, view2.getStartOffset());
                        if (rectangle2 != null) {
                            rectangle = rectangle2.getBounds();
                            if (i < n13 && n13 > n9) {
                                n11 = rectangle.y + rectangle.height;
                            }
                        }
                    }
                    if (rectangle == null || map.containsKey(new Integer(rectangle.y))) continue;
                    map.put(new Integer(rectangle.y), new PaintInfo(2, n, rectangle.y, rectangle.height));
                }
            }
            if (n8 <= n3) {
                PaintInfo paintInfo;
                view2 = view.getView(n8);
                rectangle = null;
                if (view2 instanceof DrawEngineLineView && n11 > -1 && n == 0) {
                    n9 = (int)((DrawEngineLineView)view2).getLayoutMajorAxisPreferredSpan();
                    rectangle = new Rectangle(0, n11, 0, n9);
                    n11 += n9;
                } else {
                    rectangle2 = baseTextUI.modelToView(this.component, view2.getStartOffset());
                    if (rectangle2 != null) {
                        rectangle = rectangle2.getBounds();
                        n11 = rectangle.y + rectangle.height;
                    }
                }
                if (rectangle != null && n10 != rectangle.y && ((paintInfo = (PaintInfo)map.get(new Integer(rectangle.y))) == null || paintInfo.getPaintOperation() != 1 && paintInfo.getPaintOperation() != 4 || n >= paintInfo.getInnerLevel())) {
                    map.put(new Integer(rectangle.y), new PaintInfo(3, n, rectangle.y, rectangle.height));
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getPaintInfo(int n, int n2) {
        ArrayList arrayList = new ArrayList();
        List list = this.getFoldList(n, n2);
        if (list.size() == 0) {
            return arrayList;
        }
        BaseTextUI baseTextUI = (BaseTextUI)this.component.getUI();
        Element element = baseTextUI.getRootView(this.component).getElement();
        View view = Utilities.getDocumentView(this.component);
        if (view == null) {
            return arrayList;
        }
        Document document = this.component.getDocument();
        if (!(document instanceof BaseDocument)) {
            return arrayList;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        HashMap hashMap = new HashMap();
        baseDocument.readLock();
        try {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)this.component);
            foldHierarchy.lock();
            try {
                int n3 = view.getViewIndex(n, Position.Bias.Forward);
                int n4 = view.getViewIndex(n2, Position.Bias.Forward);
                for (int i = 0; i < list.size(); ++i) {
                    Fold fold = (Fold)list.get(i);
                    this.collectPaintInfos(fold, hashMap, 0, n3, n4);
                }
            }
            finally {
                foldHierarchy.unlock();
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return new ArrayList(hashMap.values());
    }

    protected EditorUI getEditorUI() {
        return Utilities.getEditorUI(this.component);
    }

    protected Document getDocument() {
        return this.component.getDocument();
    }

    private Fold getLastLineFold(FoldHierarchy foldHierarchy, int n, int n2) {
        Fold fold = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)n);
        while (fold != null && fold.getStartOffset() < n2) {
            Fold fold2 = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)(fold.isCollapsed() ? fold.getEndOffset() : fold.getStartOffset() + 1));
            if (fold2 == fold) {
                return fold;
            }
            if (fold2 != null && fold2.getStartOffset() < n2) {
                fold = fold2;
                continue;
            }
            return fold;
        }
        return fold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Mark mark) {
        BaseTextUI baseTextUI = (BaseTextUI)this.component.getUI();
        Element element = baseTextUI.getRootView(this.component).getElement();
        View view = Utilities.getDocumentView(this.component);
        if (view == null) {
            return;
        }
        try {
            int n = view.getViewIndex(baseTextUI.getPosFromY(mark.y + mark.size / 2), Position.Bias.Forward);
            View view2 = view.getView(n);
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)this.component);
            AbstractDocument abstractDocument = (AbstractDocument)foldHierarchy.getComponent().getDocument();
            abstractDocument.readLock();
            try {
                foldHierarchy.lock();
                try {
                    int n2 = view2.getStartOffset();
                    int n3 = javax.swing.text.Utilities.getRowStart(this.component, n2);
                    int n4 = javax.swing.text.Utilities.getRowEnd(this.component, n2);
                    Fold fold = this.getLastLineFold(foldHierarchy, n3, n4);
                    if (fold != null && fold.getStartOffset() < view2.getEndOffset()) {
                        foldHierarchy.toggle(fold);
                    }
                }
                finally {
                    foldHierarchy.unlock();
                }
            }
            finally {
                abstractDocument.readUnlock();
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    protected int getMarkSize(Graphics graphics) {
        FontMetrics fontMetrics;
        if (graphics != null && (fontMetrics = graphics.getFontMetrics(this.getColoringFont())) != null) {
            int n = fontMetrics.getAscent() - fontMetrics.getDescent();
            return n - n % 2;
        }
        return -1;
    }

    protected void paintComponent(Graphics graphics) {
        if (!this.enabled) {
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        this.visibleMarks.clear();
        graphics.setColor(this.getBackColor());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(this.getForeColor());
        TextUI textUI = this.component.getUI();
        if (!(textUI instanceof BaseTextUI)) {
            return;
        }
        BaseTextUI baseTextUI = (BaseTextUI)textUI;
        try {
            int n = baseTextUI.getPosFromY(rectangle.y);
            int n2 = baseTextUI.viewToModel(this.component, 16383, rectangle.y + rectangle.height);
            List list = this.getPaintInfo(n, n2);
            Font font = this.getColoringFont();
            for (int i = 0; i < list.size(); ++i) {
                PaintInfo paintInfo = (PaintInfo)list.get(i);
                if (paintInfo.getPaintOperation() == 0 && paintInfo.getInnerLevel() == 0) continue;
                boolean bl = paintInfo.isCollapsed();
                int n3 = paintInfo.getPaintY();
                int n4 = paintInfo.getPaintHeight();
                int n5 = this.getMarkSize(graphics);
                int n6 = n5 / 2;
                int n7 = (font.getSize() - n5) / 2;
                int n8 = n3 + graphics.getFontMetrics(font).getDescent();
                int n9 = (int)Math.round((double)n5 / 3.8);
                int n10 = n7 + n6;
                int n11 = paintInfo.getPaintOperation();
                if (n11 == 1 || n11 == 4) {
                    graphics.drawRect(n7, n8, n5, n5);
                    graphics.drawLine(n9 + n7, n8 + n6, n5 + n7 - n9, n8 + n6);
                    if (bl) {
                        graphics.drawLine(n10, n8 + n9, n10, n8 + n5 - n9);
                    } else if (n11 != 4) {
                        graphics.drawLine(n10, n8 + n5, n10, n3 + n4);
                    }
                    if (paintInfo.getInnerLevel() > 0) {
                        graphics.drawLine(n10, n3, n10, n8);
                        graphics.drawLine(n10, n8 + n5, n10, n3 + n4);
                    }
                    this.visibleMarks.add(new Mark(n7, n8, n5, bl));
                    continue;
                }
                if (n11 == 2) {
                    graphics.drawLine(n10, n3, n10, n3 + n4);
                    continue;
                }
                if (n11 != 3) continue;
                graphics.drawLine(n10, n3, n10, n3 + n4 / 2);
                graphics.drawLine(n10, n3 + n4 / 2, n10 + n6, n3 + n4 / 2);
                if (paintInfo.getInnerLevel() <= 0) continue;
                graphics.drawLine(n10, n3 + n4 / 2, n10, n3 + n4);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getFoldList(int n, int n2) {
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)this.component);
        foldHierarchy.lock();
        try {
            Fold fold;
            Fold fold2 = new ArrayList();
            Fold fold3 = foldHierarchy.getRootFold();
            int n3 = fold3.getFoldCount();
            for (int i = FoldUtilities.findFoldEndIndex((Fold)fold3, (int)n); i < n3 && (fold = fold3.getFold(i)).getStartOffset() <= n2; ++i) {
                fold2.add(fold);
            }
            fold = fold2;
            return fold;
        }
        finally {
            foldHierarchy.unlock();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
            this.accessibleContext.setAccessibleName(NbBundle.getMessage(CodeFoldingSideBar.class, (String)"ACSN_CodeFoldingSideBar"));
            this.accessibleContext.setAccessibleDescription(NbBundle.getMessage(CodeFoldingSideBar.class, (String)"ACSD_CodeFoldingSideBar"));
        }
        return this.accessibleContext;
    }

    class FoldingMouseListener
    extends MouseAdapter {
        private Mark getClickedMark(MouseEvent mouseEvent) {
            if (mouseEvent == null || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return null;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            for (int i = 0; i < CodeFoldingSideBar.this.visibleMarks.size(); ++i) {
                Mark mark = (Mark)CodeFoldingSideBar.this.visibleMarks.get(i);
                if (n < mark.x || n > mark.x + mark.size || n2 < mark.y || n2 > mark.y + mark.size) continue;
                return mark;
            }
            return null;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Mark mark = this.getClickedMark(mouseEvent);
            if (mark != null) {
                mouseEvent.consume();
                CodeFoldingSideBar.this.performAction(mark);
            }
        }
    }

    public class Mark {
        public int x;
        public int y;
        public int size;
        public boolean isFolded;

        public Mark(int n, int n2, int n3, boolean bl) {
            this.x = n;
            this.y = n2;
            this.size = n3;
            this.isFolded = bl;
        }
    }

    public class PaintInfo {
        int paintOperation;
        int innerLevel;
        int paintY;
        int paintHeight;
        boolean isCollapsed;

        public PaintInfo(int n, int n2, int n3, int n4, boolean bl) {
            this.paintOperation = n;
            this.innerLevel = n2;
            this.paintY = n3;
            this.paintHeight = n4;
            this.isCollapsed = bl;
        }

        public PaintInfo(int n, int n2, int n3, int n4) {
            this(n, n2, n3, n4, false);
        }

        public int getPaintOperation() {
            return this.paintOperation;
        }

        public int getInnerLevel() {
            return this.innerLevel;
        }

        public int getPaintY() {
            return this.paintY;
        }

        public int getPaintHeight() {
            return this.paintHeight;
        }

        public boolean isCollapsed() {
            return this.isCollapsed;
        }

        public void setPaintOperation(int n) {
            this.paintOperation = n;
        }

        public void setInnerLevel(int n) {
            this.innerLevel = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("");
            if (this.paintOperation == 0) {
                stringBuffer.append("PAINT_NOOP\n");
            } else if (this.paintOperation == 1) {
                stringBuffer.append("PAINT_MARK\n");
            } else if (this.paintOperation == 2) {
                stringBuffer.append("PAINT_LINE\n");
            } else if (this.paintOperation == 3) {
                stringBuffer.append("PAINT_END_MARK\n");
            }
            stringBuffer.append("level:" + this.innerLevel);
            stringBuffer.append("\ncollapsedFold:" + this.isCollapsed);
            return stringBuffer.toString();
        }
    }

    class SideBarFoldHierarchyListener
    implements FoldHierarchyListener {
        public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
            CodeFoldingSideBar.this.repaint();
        }
    }
}

