/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * TimeZoneDialog.java
 * 
 * Created on 17 novembre 2004, 1.07
 *
 */

package com.jaspersoft.ireport.designer.tools;
import java.util.Vector;

/**
 * 
 * @author  Administrator
 */
public class TimeZoneDialog extends javax.swing.JDialog {
    
    private int dialogResult = javax.swing.JOptionPane.CANCEL_OPTION;
    
    private String reportTimeZoneId = null;
    
    /** Creates new form NewLocaleFileDialog */
    public TimeZoneDialog(java.awt.Dialog parent, boolean modal) {
        super(parent, modal);
        initAll();
    }
    
     public TimeZoneDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initAll();
    }
     
    @SuppressWarnings("unchecked")
     public void initAll()
     {
         initComponents();
        
        
        String[] tzids = java.util.TimeZone.getAvailableIDs();
        
        java.util.Arrays.sort( tzids );
       
        Vector v = new Vector();
        v.add( "Default"); //I18n.getString("timezone.default",
        for (int i=0; i<tzids.length; ++i)
        {
            java.util.TimeZone tz = java.util.TimeZone.getTimeZone(tzids[i]);
            v.add(new TimeZoneWrapper(tz));
        }
        
        jListTimeZones.setListData( v );
        
        jListTimeZones.setSelectedIndex(0);
        
        setLocationRelativeTo(null);
        
        javax.swing.KeyStroke escape =  javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0, false);
        javax.swing.Action escapeAction = new javax.swing.AbstractAction() {
            public void actionPerformed(java.awt.event.ActionEvent e) {
                jButton2ActionPerformed(e);
            }
        };
       
        getRootPane().getInputMap(javax.swing.JComponent.WHEN_IN_FOCUSED_WINDOW).put(escape, "ESCAPE");
        getRootPane().getActionMap().put("ESCAPE", escapeAction);

        //applyI18n();
        //to make the default button ...
        this.getRootPane().setDefaultButton(this.jButton1);
     }
    
    public int getDialogResult() {
        return dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getReportTimeZoneId() {
        return reportTimeZoneId;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel2 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jListTimeZones = new javax.swing.JList();
        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Time Zone", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
        jPanel2.setMinimumSize(new java.awt.Dimension(350, 80));
        jPanel2.setPreferredSize(new java.awt.Dimension(400, 300));
        jListTimeZones.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListTimeZonesValueChanged(evt);
            }
        });

        jScrollPane1.setViewportView(jListTimeZones);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(jScrollPane1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jPanel2, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jButton1.setText("OK");
        jButton1.setEnabled(false);
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 4);
        jPanel1.add(jButton1, gridBagConstraints);

        jButton2.setText("Cancel");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 4);
        jPanel1.add(jButton2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jListTimeZonesValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListTimeZonesValueChanged

        if (jListTimeZones.getSelectedIndex() >=0) jButton1.setEnabled(true);
        
    }//GEN-LAST:event_jListTimeZonesValueChanged

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
       this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        

        if (jListTimeZones.getSelectedIndex() <= 0)
        {
            this.reportTimeZoneId = null;
        }
        else
        {
            this.reportTimeZoneId = ((TimeZoneWrapper)jListTimeZones.getSelectedValue()).getTimeZone().getID(); 
        }   

        this.setDialogResult(javax.swing.JOptionPane.OK_OPTION);
        
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_jButton1ActionPerformed


    public void setReportTimeZoneId(String reportTimeZoneId) {
        this.reportTimeZoneId = reportTimeZoneId;
        
        for (int i=1; i<jListTimeZones.getModel().getSize(); ++i)
        {
            TimeZoneWrapper tzw = (TimeZoneWrapper) jListTimeZones.getModel().getElementAt(i);
            if (tzw.getTimeZone().getID().equals(reportTimeZoneId))
            {
                jListTimeZones.setSelectedIndex(i);
                jListTimeZones.ensureIndexIsVisible(i);
                return;
            }
        }
        
        if (jListTimeZones.getModel().getSize() > 0) jListTimeZones.setSelectedIndex(0);
    }

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JList jListTimeZones;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    
    /*
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jButton1.setText(I18n.getString("timeZoneDialog.button1","OK"));
                jButton2.setText(I18n.getString("timeZoneDialog.button2","Cancel"));
                // End autogenerated code ----------------------
                ((javax.swing.border.TitledBorder)jPanel2.getBorder()).setTitle( it.businesslogic.ireport.util.I18n.getString("timeZoneDialog.panelBorder.TimeZone","Time Zone") );
                
                jButton1.setMnemonic(I18n.getString("timeZoneDialog.button1Mnemonic","o").charAt(0));
                jButton2.setMnemonic(I18n.getString("timeZoneDialog.button2Mnemonic","c").charAt(0));
    }
     */
    
    
}
