/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.jasperserver.Encrypter;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.RepoImageCache;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.sf.jasperreports.engine.util.JRProperties;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class JasperServerManager {
    private static JasperServerManager mainInstance = null;
    public static String REQUIRED_VERSION = "";
    public static String CURRENT_VERSION = "";
    public static final String PROPERTY_CHECK_FOR_UPDATE = "PROPERTY_CHECK_FOR_UPDATE";
    public static final String PROPERTY_USE_PROXY = "PROPERTY_USE_PROXY";
    public static final String PROPERTY_PROXY_URL = "PROPERTY_PROXY_URL";
    public static final String PROPERTY_PROXY_USE_AUTH = "PROPERTY_PROXY_USE_AUTH";
    public static final String PROPERTY_PROXY_USERNAME = "PROPERTY_PROXY_USERNAME";
    public static final String PROPERTY_PROXY_PASSWORD = "PROPERTY_PROXY_PASSWORD";
    private List jServers = new ArrayList();
    private Properties properties = new Properties();
    private Properties brandingProperties = new Properties();
    private static ResourceBundle oLanguage = null;
    private static Locale pluginLocale = null;

    public static JasperServerManager getMainInstance() {
        if (mainInstance == null) {
            mainInstance = new JasperServerManager();
        }
        return mainInstance;
    }

    private JasperServerManager() {
        this.loadConfiguration();
        this.applyProxySettings();
        pluginLocale = Locale.getDefault();
        if (JRProperties.getProperty((String)"net.sf.jasperreports.query.executer.factory.sl") == null) {
            JRProperties.setProperty((String)"net.sf.jasperreports.query.executer.factory.sl", (String)"net.sf.jasperreports.engine.query.JRJdbcQueryExecuterFactory");
        }
        IReportManager.getInstance().getFileResolvers().add(RepoImageCache.getInstance());
    }

    public void applyProxySettings() {
        Properties props = this.getProperties();
        System.getProperties().remove("proxySet");
        System.getProperties().remove("proxyHost");
        System.getProperties().remove("proxyPort");
        System.getProperties().remove("http.proxyHost");
        System.getProperties().remove("http.proxyPort");
        System.getProperties().remove("http.proxyUser");
        System.getProperties().remove("http.proxyPassword");
        System.getProperties().remove("https.proxyHost");
        System.getProperties().remove("https.proxyPort");
        if (props.getProperty(PROPERTY_USE_PROXY, "false").equals("true")) {
            String urlProxy = props.getProperty(PROPERTY_PROXY_URL, "");
            String port = "8080";
            String server = urlProxy;
            if (urlProxy.indexOf(":") > 0) {
                port = urlProxy.substring(urlProxy.indexOf(":") + 1);
                server = urlProxy.substring(0, urlProxy.indexOf(":"));
            }
            System.getProperties().put("http.proxyHost", server);
            System.getProperties().put("http.proxyPort", port);
            if (props.getProperty(PROPERTY_PROXY_USE_AUTH, "false").equals("true")) {
                String userName = props.getProperty(PROPERTY_PROXY_USERNAME, "");
                String userPass = props.getProperty(PROPERTY_PROXY_PASSWORD, "");
                System.getProperties().put("http.proxyUser", userName);
                System.getProperties().put("http.proxyPassword", userPass);
            }
        }
    }

    public void loadConfiguration() {
        try {
            int i;
            this.setProperties(new Properties());
            Preferences prefs = NbPreferences.forModule(JasperServerManager.class);
            String[] keys = prefs.keys();
            Properties props = this.getProperties();
            for (i = 0; i < keys.length; ++i) {
                props.put(keys[i], prefs.get(keys[i], null));
            }
            i = 0;
            while (props.getProperty("server." + i + ".name") != null) {
                JServer server = new JServer();
                server.setName(props.getProperty("server." + i + ".name"));
                server.setUrl(props.getProperty("server." + i + ".url"));
                server.setUsername(props.getProperty("server." + i + ".username"));
                String pwd = null;
                if (props.getProperty("server." + i + ".password.enc") != null) {
                    Encrypter enc = new Encrypter(this.getBrandingProperties().getProperty("irplugin.encrypt.passwords.key", "54fj245vn3vfdsmce4mg0jvs"));
                    pwd = enc.decrypt(props.getProperty("server." + i + ".password.enc"));
                } else {
                    pwd = props.getProperty("server." + i + ".password");
                }
                server.setPassword(pwd);
                server.setLocale(Locale.getDefault().toString());
                this.getJServers().add(server);
                ++i;
            }
            this.addProperties("/com/jaspersoft/ireport/jasperserver/default.jasperserver_irplugin.properties", this.getBrandingProperties());
            this.addProperties("/com/jaspersoft/ireport/jasperserver/jasperserver_irplugin.properties", this.getBrandingProperties());
            REQUIRED_VERSION = this.getBrandingProperties().getProperty("irplugin.server.required.version");
            CURRENT_VERSION = this.getBrandingProperties().getProperty("irplugin.version");
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void addProperties(String resourceUri, Properties props) {
        try {
            InputStream is = this.getClass().getResourceAsStream(resourceUri);
            if (is == null) {
                return;
            }
            props.load(is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean saveConfiguration() {
        Preferences prefs = NbPreferences.forModule(JasperServerManager.class);
        try {
            prefs.clear();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        for (int i = 0; i < this.getJServers().size(); ++i) {
            JServer server = (JServer)this.getJServers().get(i);
            prefs.put("server." + i + ".name", server.getName());
            prefs.put("server." + i + ".url", server.getUrl());
            prefs.put("server." + i + ".username", server.getUsername());
            if (this.getBrandingProperties().getProperty("irplugin.encrypt.passwords", "true").equals("true")) {
                Encrypter enc = new Encrypter(this.getBrandingProperties().getProperty("irplugin.encrypt.passwords.key", "54fj245vn3vfdsmce4mg0jvs"));
                prefs.put("server." + i + ".password.enc", enc.encrypt(server.getPassword()));
                continue;
            }
            prefs.put("server." + i + ".password", server.getPassword());
        }
        return true;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public List getJServers() {
        return this.jServers;
    }

    public void setJServers(List jServers) {
        this.jServers = jServers;
    }

    public static String createTmpFileName(String filePrefix, String fileExtension) {
        filePrefix = filePrefix == null ? "" : filePrefix + "_";
        if (fileExtension != null && !fileExtension.startsWith(".")) {
            fileExtension = "." + fileExtension;
        }
        if (fileExtension == null) {
            fileExtension = ".tmp";
        }
        String tmpDirectory = System.getProperty("java.io.tmpdir");
        File tmpDirectoryFile = new File(tmpDirectory = tmpDirectory + File.separator + "jstmp");
        if (!tmpDirectoryFile.exists()) {
            tmpDirectoryFile.mkdirs();
        }
        return tmpDirectoryFile + File.separator + filePrefix + new Date().getTime() + fileExtension;
    }

    public Properties getBrandingProperties() {
        return this.brandingProperties;
    }

    public void setBrandingProperties(Properties brandingProperties) {
        this.brandingProperties = brandingProperties;
    }

    public static boolean isValidUrl(String url) {
        String strRegex = "((([0-9]{1,3}\\.){3})[0-9]{1,3})|(([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.?)++(:[0-9]{1,4})?";
        return url.matches(strRegex);
    }

    public static String getFormattedString(String cID, String defaultValue, Object[] args) {
        String pattern = JasperServerManager.getString(cID, defaultValue);
        MessageFormat mf = new MessageFormat(pattern, Locale.getDefault());
        return mf.format(args);
    }

    public static String getString(String cID, String defaultValue) {
        try {
            String newKey;
            String s = NbBundle.getMessage(JasperServerManager.class, (String)cID);
            if (s != null && s.startsWith("${") && s.endsWith("}") && (newKey = s.substring(2, s.length() - 1)).length() > 0) {
                return JasperServerManager.getString(newKey, defaultValue);
            }
            return s;
        }
        catch (MissingResourceException ex) {
            System.out.println("JS Explorer: Can't find the translation for key = " + cID + ": using default (" + defaultValue + ")");
        }
        catch (Exception ex) {
            System.out.println("JS Explorer: Exception loading cID = " + cID + ": " + ex.getMessage());
        }
        return defaultValue;
    }

    public List getSupportedQueryLanguages() {
        Iterator<Object> iter = this.getBrandingProperties().keySet().iterator();
        ArrayList<Object> list = new ArrayList<Object>();
        while (iter.hasNext()) {
            String key = "" + iter.next();
            if (!key.startsWith("query.language.") || key.endsWith(".enabled")) continue;
            String language = key.substring(15);
            if (!this.getBrandingProperties().getProperty(key + ".enabled", "true").equals("true")) continue;
            list.add(new Tag((Object)language, this.getBrandingProperties().getProperty(key)));
        }
        Object[] tobeordered = list.toArray();
        Arrays.sort(tobeordered, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Tag)o1).getName().compareTo(((Tag)o2).getName());
            }

            public boolean equals(Object obj) {
                return obj != null && this.equals(obj);
            }
        });
        list.clear();
        for (int i = 0; i < tobeordered.length; ++i) {
            list.add(tobeordered[i]);
        }
        return list;
    }
}

