/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.ByteArray;
import org.hsqldb.DatabaseRowOutput;
import org.hsqldb.TextCache;

class TextDatabaseRowOutput
extends DatabaseRowOutput {
    protected String fieldSep;
    protected String varSep;
    protected String longvarSep;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private String nextSep = "";
    private boolean nextSepEnd;
    private ByteArrayOutputStream byteOut = (ByteArrayOutputStream)this.out;

    public TextDatabaseRowOutput(String string, String string2, String string3) throws IOException {
        super(new ByteArrayOutputStream());
        this.skipSystemId = true;
        if (string.endsWith("\n")) {
            this.fieldSepEnd = true;
            string = string.substring(0, string.length() - 1);
        }
        if (string2.endsWith("\n")) {
            this.varSepEnd = true;
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string3.endsWith("\n")) {
            this.longvarSepEnd = true;
            string3 = string3.substring(0, string3.length() - 1);
        }
        this.fieldSep = string;
        this.varSep = string2;
        this.longvarSep = string3;
    }

    public void writePos(int n) throws IOException {
    }

    public void writeSize(int n) throws IOException {
    }

    public void writeType(int n) throws IOException {
    }

    private void writeNull() throws IOException {
        this.writeBytes(this.nextSep);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    private void writeVarNull() throws IOException {
        this.writeBytes(this.nextSep);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    private void writeLongVarNull() throws IOException {
        this.writeBytes(this.nextSep);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    public void writeString(String string) throws IOException {
        this.writeBytes(this.nextSep);
        this.writeBytes(string);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    protected void writeVarString(String string) throws IOException {
        this.writeBytes(this.nextSep);
        this.writeBytes(string);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    protected void writeLongVarString(String string) throws IOException {
        this.writeBytes(this.nextSep);
        this.writeBytes(string);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    protected void writeByteArray(byte[] byArray) throws IOException {
        this.writeBytes(this.nextSep);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    protected void writeVarByteArray(byte[] byArray) throws IOException {
        this.writeBytes(this.nextSep);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    protected void writeLongVarByteArray(byte[] byArray) throws IOException {
        this.writeBytes(this.nextSep);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    public void writeIntData(int n) throws IOException {
        this.writeBytes(this.nextSep + n);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    protected void writeFieldType(int n) throws IOException {
    }

    protected void writeNull(int n) throws IOException {
        switch (n) {
            case -3: 
            case 12: 
            case 100: {
                this.writeVarNull();
                break;
            }
            case -4: 
            case -1: {
                this.writeLongVarNull();
                break;
            }
            default: {
                this.writeNull();
            }
        }
    }

    protected void writeChar(String string, int n) throws IOException {
        switch (n) {
            case 1: {
                this.writeString(string);
                return;
            }
            case 12: 
            case 100: {
                this.writeVarString(string);
                return;
            }
        }
        this.writeLongVarString(string);
    }

    protected void writeSmallint(Number number) throws IOException, SQLException {
        this.writeString(number.toString());
    }

    protected void writeInteger(Number number) throws IOException, SQLException {
        this.writeString(number.toString());
    }

    protected void writeBigint(Number number) throws IOException, SQLException {
        this.writeString(number.toString());
    }

    protected void writeReal(Double d, int n) throws IOException, SQLException {
        this.writeString(d.toString());
    }

    protected void writeDecimal(BigDecimal bigDecimal) throws IOException, SQLException {
        this.writeString(bigDecimal.toString());
    }

    protected void writeBit(Boolean bl) throws IOException, SQLException {
        this.writeString(bl.toString());
    }

    protected void writeDate(Date date) throws IOException, SQLException {
        this.writeString(date.toString());
    }

    protected void writeTime(Time time) throws IOException, SQLException {
        this.writeString(time.toString());
    }

    protected void writeTimestamp(Timestamp timestamp) throws IOException, SQLException {
        this.writeString(timestamp.toString());
    }

    protected void writeOther(Object object) throws IOException, SQLException {
        byte[] byArray = ByteArray.serialize(object);
        this.writeByteArray(byArray);
    }

    protected void writeBinary(byte[] byArray, int n) throws IOException, SQLException {
        switch (n) {
            default: 
        }
        this.writeByteArray(byArray);
    }

    public byte[] toByteArray() throws IOException {
        if (this.nextSepEnd) {
            this.writeBytes(this.nextSep);
        }
        this.nextSep = "";
        this.nextSepEnd = false;
        this.writeBytes(TextCache.NL);
        byte[] byArray = this.byteOut.toByteArray();
        this.byteOut.reset();
        return byArray;
    }
}

