/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import org.openide.nodes.PropertySupport;

public class PdfEncodingProperty
extends PropertySupport.ReadWrite {
    private final JRDesignTextElement element;
    PropertyEditor editor = null;

    public PdfEncodingProperty(JRDesignTextElement element) {
        super("pdfEncoding", String.class, "Pdf Encoding", "Pdf Encoding");
        this.element = element;
        this.setValue("canEditAsText", true);
        this.setValue("oneline", true);
        this.setValue("suppressCustomEditor", false);
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.element.getPdfEncoding();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || val instanceof String) {
            if ((val + "").trim().length() == 0) {
                val = null;
            }
            String oldValue = this.element.getOwnPdfEncoding();
            String newValue = (String)val;
            this.element.setPdfEncoding(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "PdfEncoding", String.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.element.getOwnPdfEncoding() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> encodings = new ArrayList<Tag>();
            encodings.add(new Tag("Cp1250", "CP1250 (Central European)"));
            encodings.add(new Tag("Cp1251", "CP1251 (Cyrillic)"));
            encodings.add(new Tag("Cp1252", "CP1252 (Western European ANSI aka WinAnsi)"));
            encodings.add(new Tag("Cp1253", "CP1253 (Greek)"));
            encodings.add(new Tag("Cp1254", "CP1254 (Turkish)"));
            encodings.add(new Tag("Cp1255", "CP1255 (Hebrew)"));
            encodings.add(new Tag("Cp1256", "CP1256 (Arabic)"));
            encodings.add(new Tag("Cp1257", "CP1257 (Baltic)"));
            encodings.add(new Tag("Cp1258", "CP1258 (Vietnamese)"));
            encodings.add(new Tag("UniGB-UCS2-H", "UniGB-UCS2-H (Chinese Simplified)"));
            encodings.add(new Tag("UniGB-UCS2-V", "UniGB-UCS2-V (Chinese Simplified)"));
            encodings.add(new Tag("UniCNS-UCS2-H", "UniCNS-UCS2-H (Chinese traditional)"));
            encodings.add(new Tag("UniCNS-UCS2-V", "UniCNS-UCS2-V (Chinese traditional)"));
            encodings.add(new Tag("UniJIS-UCS2-H", "UniJIS-UCS2-H (Japanese)"));
            encodings.add(new Tag("UniJIS-UCS2-V", "UniJIS-UCS2-V (Japanese)"));
            encodings.add(new Tag("UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-H (Japanese)"));
            encodings.add(new Tag("UniJIS-UCS2-HW-V", "UniJIS-UCS2-HW-V (Japanese)"));
            encodings.add(new Tag("UniKS-UCS2-H", "UniKS-UCS2-H (Korean)"));
            encodings.add(new Tag("UniKS-UCS2-V", "UniKS-UCS2-V (Korean)"));
            encodings.add(new Tag("Identity-H", "Identity-H (Unicode with horizontal writing)"));
            encodings.add(new Tag("Identity-V", "Identity-V (Unicode with vertical writing)"));
            this.editor = new ComboBoxPropertyEditor(true, encodings);
        }
        return this.editor;
    }
}

