/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.palette.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.crosstab.CrosstabObjectScene;
import com.jaspersoft.ireport.designer.palette.PaletteItemAction;
import com.jaspersoft.ireport.designer.undo.AddElementUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import javax.swing.JOptionPane;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.util.Mutex;

public abstract class CreateReportElementAction
extends PaletteItemAction {
    public void drop(DropTargetDropEvent dtde) {
        JRDesignElement element = this.createReportElement(this.getJasperDesign());
        if (element == null) {
            return;
        }
        if (this.getScene() instanceof ReportObjectScene) {
            Point p = this.getScene().convertViewToScene(dtde.getLocation());
            p.x -= 10;
            p.y -= 10;
            JRDesignBand b = ModelUtils.getBandAt(this.getJasperDesign(), p);
            if (b != null) {
                element.setX(p.x - this.getJasperDesign().getLeftMargin());
                element.setY(p.y - ModelUtils.getBandLocation((JRBand)b, this.getJasperDesign()));
                b.addElement(element);
                AddElementUndoableEdit edit = new AddElementUndoableEdit(element, b);
                IReportManager.getInstance().addUndoableEdit(edit);
            }
        } else if (this.getScene() instanceof CrosstabObjectScene) {
            Point p = this.getScene().convertViewToScene(dtde.getLocation());
            p.x -= 10;
            p.y -= 10;
            if (element instanceof JRCrosstab || element instanceof JRChart || element instanceof JRBreak || element instanceof JRSubreport) {
                Runnable r = new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(Misc.getMainFrame(), "You can use this kind of element inside a crosstab.", "Error", 2);
                    }
                };
                Mutex.EVENT.readAccess(r);
                return;
            }
            JRDesignCrosstab crosstab = ((CrosstabObjectScene)this.getScene()).getDesignCrosstab();
            JRDesignCellContents cell = ModelUtils.getCellAt(crosstab, p, true);
            if (cell != null) {
                Point base = ModelUtils.getCellLocation(crosstab, cell);
                element.setX(p.x - base.x);
                element.setY(p.y - base.y);
                String styleName = "Crosstab Data Text";
                if (this.getJasperDesign().getStylesMap().containsKey(styleName)) {
                    element.setStyle((JRStyle)this.getJasperDesign().getStylesMap().get(styleName));
                }
                cell.addElement(element);
                AddElementUndoableEdit edit = new AddElementUndoableEdit(element, cell);
                IReportManager.getInstance().addUndoableEdit(edit);
            }
        }
    }

    public abstract JRDesignElement createReportElement(JasperDesign var1);
}

