/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.crosstab.widgets;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.borders.ReportBorder;
import com.jaspersoft.ireport.designer.crosstab.CrosstabObjectScene;
import com.jaspersoft.ireport.designer.palette.actions.DefaultCellElementsLayout;
import com.jaspersoft.ireport.designer.utils.Java2DUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class CrosstabWidget
extends Widget
implements PropertyChangeListener {
    public static Color CELL_LABEL_COLOR = new Color(210, 210, 210, 100);
    private int gridSize = 13;
    private JRDesignCrosstab crosstab = null;
    private TexturePaint gridTexture = null;
    private static final BasicStroke GRID_STROKE = new BasicStroke(0.0f, 2, 2, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);

    public CrosstabWidget(CrosstabObjectScene scene, JRDesignCrosstab crosstab) {
        super((Scene)scene);
        this.crosstab = crosstab;
        this.setBorder(new ReportBorder());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setCheckClipping(true);
        this.updateBounds();
        crosstab.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.updateCellListeners();
    }

    public void updateBounds() {
        int width = this.getCrosstabDesignWidth();
        width = Math.max(width, this.getCrosstab().getWidth());
        int height = this.getCrosstabDesignHeight();
        height = Math.max(height, this.getCrosstab().getHeight());
        this.setPreferredSize(new Dimension(width + 20, height + 20));
    }

    public JasperDesign getJasperDesign() {
        return ((AbstractReportObjectScene)this.getScene()).getJasperDesign();
    }

    protected void paintWidget() {
        int i;
        super.paintWidget();
        Graphics2D g = this.getGraphics();
        if (((AbstractReportObjectScene)this.getScene()).isGridVisible()) {
            this.paintGrid(g);
        }
        Stroke oldStroke = g.getStroke();
        double zoom = this.getScene().getZoomFactor();
        Stroke bs = Java2DUtils.getInvertedZoomedStroke(oldStroke, this.getScene().getZoomFactor());
        g.setStroke(bs);
        g.setFont(new Font("Arial", 0, 8));
        int header_width = ModelUtils.getHeaderCellWidth(this.getCrosstab());
        int header_height = ModelUtils.getHeaderCellHeight(this.getCrosstab());
        JRCrosstabRowGroup[] row_groups = this.getCrosstab().getRowGroups();
        JRCrosstabColumnGroup[] col_groups = this.getCrosstab().getColumnGroups();
        this.paintCell(g, "Crosstab header", 0, 0, this.getCrosstab().getHeaderCell());
        int x = header_width;
        int y = header_height;
        JRCrosstabCell[][] cells = ModelUtils.normalizeCell(this.getCrosstab().getCells(), row_groups, col_groups);
        for (int i2 = cells.length - 1; i2 >= 0; --i2) {
            x = header_width;
            for (int k = cells[i2].length - 1; k >= 0; --k) {
                JRCrosstabCell cell = cells[i2][k];
                if (cell != null) {
                    String title = (cell.getRowTotalGroup() == null ? "Detail" : cell.getRowTotalGroup()) + " / " + (cell.getColumnTotalGroup() == null ? "Detail" : cell.getColumnTotalGroup());
                    this.paintCell(g, title, x, y, cell.getContents());
                }
                x += ModelUtils.findColumnWidth(cells, k);
            }
            y += ModelUtils.findRowHeight(cells, i2);
        }
        int data_width = x - header_width;
        int data_height = y - header_height;
        x = 0;
        y = header_height;
        for (i = 0; i < row_groups.length; ++i) {
            switch (row_groups[i].getTotalPosition()) {
                case 1: {
                    this.paintCell(g, row_groups[i].getName() + " total header", x, y, row_groups[i].getTotalHeader());
                    data_height -= row_groups[i].getTotalHeader().getHeight();
                    y += row_groups[i].getTotalHeader().getHeight();
                    break;
                }
                case 2: {
                    int y_loc = y + data_height - row_groups[i].getTotalHeader().getHeight();
                    this.paintCell(g, row_groups[i].getName() + " total header", x, y_loc, row_groups[i].getTotalHeader());
                    data_height -= row_groups[i].getTotalHeader().getHeight();
                    break;
                }
            }
            this.paintCell(g, row_groups[i].getName() + " header", x, y, row_groups[i].getHeader());
            x += row_groups[i].getHeader().getWidth();
        }
        x = header_width;
        y = 0;
        for (i = 0; i < col_groups.length; ++i) {
            switch (col_groups[i].getTotalPosition()) {
                case 1: {
                    this.paintCell(g, col_groups[i].getName() + " total header", x, y, col_groups[i].getTotalHeader());
                    data_width -= col_groups[i].getTotalHeader().getWidth();
                    x += col_groups[i].getTotalHeader().getWidth();
                    break;
                }
                case 2: {
                    int x_loc = x + data_width - col_groups[i].getTotalHeader().getWidth();
                    this.paintCell(g, col_groups[i].getName() + " total header", x_loc, y, col_groups[i].getTotalHeader());
                    data_width -= col_groups[i].getTotalHeader().getWidth();
                    break;
                }
            }
            this.paintCell(g, col_groups[i].getName() + " header", x, y, col_groups[i].getHeader());
            y += col_groups[i].getHeader().getHeight();
        }
        g.setStroke(oldStroke);
    }

    private void paintCell(Graphics2D g, String title, int x, int y, JRCellContents contents) {
        if (contents == null) {
            return;
        }
        int width = contents.getWidth();
        int height = contents.getHeight();
        int txt_height = g.getFontMetrics().getHeight() / 2;
        Paint oldPaint = g.getPaint();
        Shape oldClip = g.getClip();
        g.setPaint(CELL_LABEL_COLOR);
        g.drawRect(x, y, width, height);
        g.setPaint(oldPaint);
        g.setPaint(AbstractReportObjectScene.DESIGN_LINE_COLOR);
        AffineTransform af = g.getTransform();
        AffineTransform new_af = (AffineTransform)af.clone();
        AffineTransform translate = AffineTransform.getTranslateInstance(x, y);
        new_af.concatenate(translate);
        g.setTransform(new_af);
        JRFrame frame = this.getCrosstabCellFrame(new ReportConverter((JRReport)this.getJasperDesign(), true, false), contents, x, y, x == 0 && this.crosstab.getRunDirection() == 0, x == 0 && this.crosstab.getRunDirection() == 1, false);
        if (frame != null && ((CrosstabObjectScene)this.getScene()).getDrawVisitor() != null) {
            ((CrosstabObjectScene)this.getScene()).getDrawVisitor().setGraphics2D(g);
            ((CrosstabObjectScene)this.getScene()).getDrawVisitor().visitFrame(frame);
        }
        g.setTransform(af);
        g.clipRect(x, y, width - 2, height - 2);
        Color cc = contents.getBackcolor() != null ? contents.getBackcolor() : Color.WHITE;
        cc = cc.darker();
        g.setPaint(cc);
        if (IReportManager.getPreferences().getBoolean("PROPERTY_SHOW_CELL_NAMES", false)) {
            g.drawString(title, x + 3, y + txt_height + 3);
        }
        g.setClip(oldClip);
        g.setPaint(oldPaint);
    }

    private JRFrame getCrosstabCellFrame(ReportConverter reportConverter, JRCellContents cell, int x, int y, boolean left, boolean right, boolean top) {
        JRDesignFrame frame = new JRDesignFrame(cell.getDefaultStyleProvider());
        frame.setX(x);
        frame.setY(y);
        frame.setWidth(cell.getWidth());
        frame.setHeight(cell.getHeight());
        frame.setMode(cell.getMode());
        frame.setBackcolor(cell.getBackcolor());
        JRLineBox box = cell.getLineBox();
        if (box != null) {
            boolean copyTop;
            frame.copyBox(box);
            boolean copyLeft = left && box.getLeftPen().getLineWidth().floatValue() <= 0.0f && box.getRightPen().getLineWidth().floatValue() > 0.0f;
            boolean copyRight = right && box.getRightPen().getLineWidth().floatValue() <= 0.0f && box.getLeftPen().getLineWidth().floatValue() > 0.0f;
            boolean bl = copyTop = top && box.getTopPen().getLineWidth().floatValue() <= 0.0f && box.getBottomPen().getLineWidth().floatValue() > 0.0f;
            if (copyLeft) {
                ((JRBaseLineBox)frame.getLineBox()).copyLeftPen(box.getRightPen());
            }
            if (copyRight) {
                ((JRBaseLineBox)frame.getLineBox()).copyRightPen(box.getLeftPen());
            }
            if (copyTop) {
                ((JRBaseLineBox)frame.getLineBox()).copyTopPen(box.getBottomPen());
            }
        }
        return frame;
    }

    protected void paintGrid(Graphics2D g) {
        Paint oldPaint = g.getPaint();
        g.setPaint(this.getGridTexture());
        g.fill(this.getClientArea());
        g.setPaint(oldPaint);
    }

    private TexturePaint getGridTexture() {
        if (this.gridTexture == null || this.gridTexture.getImage().getWidth() != this.getGridSize()) {
            BufferedImage img = new BufferedImage(this.getGridSize(), this.getGridSize(), 1);
            Graphics2D g2 = img.createGraphics();
            g2.setColor(new Color(255, 255, 255, 255));
            g2.fill(this.getClientArea());
            g2.setColor(ReportObjectScene.GRID_LINE_COLOR);
            g2.setStroke(GRID_STROKE);
            g2.drawLine(this.getGridSize() - 1, 0, this.getGridSize() - 1, this.getGridSize() - 1);
            g2.drawLine(0, this.getGridSize() - 1, this.getGridSize() - 1, this.getGridSize() - 1);
            this.gridTexture = new TexturePaint(img, new Rectangle(0, 0, this.getGridSize(), this.getGridSize()));
        }
        return this.gridTexture;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public JRDesignCrosstab getCrosstab() {
        return this.crosstab;
    }

    public int getCrosstabDesignWidth() {
        int i;
        JRCrosstabCell[][] cells = this.getCrosstab().getCells();
        int width = 0;
        JRCrosstabRowGroup[] row_groups = this.getCrosstab().getRowGroups();
        for (i = 0; i < row_groups.length; ++i) {
            width += row_groups[i].getWidth();
        }
        for (i = 0; i < cells[0].length; ++i) {
            width += ModelUtils.findColumnWidth(cells, i);
        }
        return width;
    }

    public int getCrosstabDesignHeight() {
        int i;
        JRCrosstabCell[][] cells = this.getCrosstab().getCells();
        int height = 0;
        JRCrosstabColumnGroup[] column_groups = this.getCrosstab().getColumnGroups();
        for (i = 0; i < column_groups.length; ++i) {
            height += column_groups[i].getHeight();
        }
        for (i = 0; i < cells.length; ++i) {
            height += ModelUtils.findRowHeight(cells, i);
        }
        return height;
    }

    private void updateCellListeners() {
        int i;
        List<JRDesignCellContents> cells = ModelUtils.getAllCells(this.crosstab);
        for (JRDesignCellContents content : cells) {
            if (content == null) continue;
            content.getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
            content.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        JRCrosstabRowGroup[] groups = this.crosstab.getRowGroups();
        for (i = 0; i < groups.length; ++i) {
            ((JRDesignCrosstabGroup)groups[i]).getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
            ((JRDesignCrosstabGroup)groups[i]).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        groups = this.crosstab.getColumnGroups();
        for (i = 0; i < groups.length; ++i) {
            ((JRDesignCrosstabGroup)groups[i]).getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
            ((JRDesignCrosstabGroup)groups[i]).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        JRDesignCellContents cellContent;
        if (evt.getPropertyName().equals("cells") || evt.getPropertyName().equals("headerCell") || evt.getPropertyName().equals("rowGroups") || evt.getPropertyName().equals("columnGroups") || evt.getPropertyName().equals("whenNoDataCell") || evt.getPropertyName().equals("totalPosition") || evt.getPropertyName().equals("header") || evt.getPropertyName().equals("totalHeader")) {
            this.updateCellListeners();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((CrosstabObjectScene)CrosstabWidget.this.getScene()).rebuildDocument();
                }
            });
            return;
        }
        boolean refreshCell = false;
        if (evt.getPropertyName().equals("children")) {
            refreshCell = true;
            cellContent = evt.getSource() instanceof JRDesignCellContents ? (JRDesignCellContents)evt.getSource() : null;
        } else if (evt.getPropertyName().equals("style") || evt.getPropertyName().equals("box") || evt.getPropertyName().equals("mode") || evt.getPropertyName().equals("backcolor")) {
            refreshCell = true;
            cellContent = null;
        } else {
            cellContent = null;
        }
        if (refreshCell) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((CrosstabObjectScene)CrosstabWidget.this.getScene()).refreshCells();
                    if (cellContent != null) {
                        DefaultCellElementsLayout.doLayout(cellContent, (CrosstabObjectScene)CrosstabWidget.this.getScene());
                    }
                }
            });
        }
    }
}

