/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.crosstab;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.tools.DatasetParametersTableCellRenderer;
import com.jaspersoft.ireport.designer.tools.JRDatasetParameterDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetParameter;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;

public class CrosstabDataDialog
extends JDialog {
    private JRDesignCrosstab currentSelectedCrosstabElement = null;
    private int dialogResult = 0;
    private JasperDesign jasperDesign = null;
    private ExpressionContext expressionContext = null;
    private boolean init = false;
    private JButton jButtonAddParameter;
    private JButton jButtonClose;
    private JButton jButtonModParameter;
    private JButton jButtonRemParameter;
    private JCheckBox jCheckBoxPreSorted;
    private JComboBox jComboBoxDatasetConnectionType;
    private JComboBox jComboBoxIncrementGroup;
    private JComboBox jComboBoxIncrementType;
    private JComboBox jComboBoxResetGroup;
    private JComboBox jComboBoxResetType;
    private JComboBox jComboBoxSubDataset;
    private JLabel jLabel26;
    private JLabel jLabel41;
    private JLabel jLabelIncrementGroup;
    private JLabel jLabelIncrementType;
    private JLabel jLabelIncrementType1;
    private JLabel jLabelIncrementType2;
    private JLabel jLabelResetGroup;
    private JLabel jLabelResetType;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel16;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanelData;
    private JPanel jPanelDataset;
    private ExpressionEditorArea jRTextExpressionAreaFilterExpression;
    private ExpressionEditorArea jRTextExpressionAreaMapExpression;
    private ExpressionEditorArea jRTextExpressionAreaTextConnectionExpression;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPaneSubDataset;
    private JTable jTableDatasetParameters;

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public void setCrosstabElement(JRDesignCrosstab crosstabReportElement, JasperDesign jd) {
        this.setInit(true);
        this.jasperDesign = jd;
        try {
            this.currentSelectedCrosstabElement = crosstabReportElement;
            if (this.currentSelectedCrosstabElement != null) {
                this.updateGroups();
                this.updateSubDatasets();
                this.jCheckBoxPreSorted.setSelected(this.currentSelectedCrosstabElement.getDataset().isDataPreSorted());
                Misc.setComboboxSelectedTagValue(this.jComboBoxIncrementType, new Byte(this.currentSelectedCrosstabElement.getDataset().getIncrementType()));
                this.jComboBoxIncrementGroup.setEnabled(this.currentSelectedCrosstabElement.getDataset().getIncrementType() == 4);
                if (this.currentSelectedCrosstabElement.getDataset().getIncrementType() == 4) {
                    this.jComboBoxIncrementGroup.setSelectedItem(this.currentSelectedCrosstabElement.getDataset().getIncrementGroup().getName());
                }
                Misc.setComboboxSelectedTagValue(this.jComboBoxResetType, new Byte(this.currentSelectedCrosstabElement.getDataset().getResetType()));
                this.jComboBoxResetGroup.setEnabled(this.currentSelectedCrosstabElement.getDataset().getResetType() == 4);
                if (this.currentSelectedCrosstabElement.getDataset().getResetType() == 4) {
                    this.jComboBoxResetGroup.setSelectedItem(this.currentSelectedCrosstabElement.getDataset().getResetGroup().getName());
                }
                this.jRTextExpressionAreaFilterExpression.setText(Misc.getExpressionText(this.currentSelectedCrosstabElement.getDataset().getIncrementWhenExpression()));
                JRDesignDataset dataset = (JRDesignDataset)this.getJasperDesign().getMainDataset();
                if (this.currentSelectedCrosstabElement.getDataset().getDatasetRun() != null) {
                    JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)this.currentSelectedCrosstabElement.getDataset().getDatasetRun();
                    this.jComboBoxSubDataset.setSelectedItem(datasetRun.getDatasetName());
                    if (this.jPanel7.getComponentCount() == 0) {
                        GridBagConstraints gridBagConstraints = new GridBagConstraints();
                        gridBagConstraints.gridy = 1;
                        gridBagConstraints.gridwidth = 2;
                        gridBagConstraints.fill = 1;
                        gridBagConstraints.weightx = 1.0;
                        gridBagConstraints.weighty = 1.0;
                        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
                        this.jPanel7.add((Component)this.jTabbedPaneSubDataset, gridBagConstraints);
                        this.jPanel7.updateUI();
                    }
                    this.jRTextExpressionAreaMapExpression.setText(Misc.getExpressionText(datasetRun.getParametersMapExpression()));
                    int connectionType = 0;
                    if (datasetRun.getConnectionExpression() != null) {
                        connectionType = 1;
                    }
                    if (datasetRun.getDataSourceExpression() != null) {
                        connectionType = 2;
                    }
                    if (connectionType == 0) {
                        this.jComboBoxDatasetConnectionType.setSelectedIndex(0);
                        this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
                        this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
                        this.jRTextExpressionAreaTextConnectionExpression.setText("");
                    } else if (connectionType == 1) {
                        this.jComboBoxDatasetConnectionType.setSelectedIndex(1);
                        this.jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
                        this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
                        this.jRTextExpressionAreaTextConnectionExpression.setText(Misc.getExpressionText(datasetRun.getConnectionExpression()));
                    } else {
                        this.jComboBoxDatasetConnectionType.setSelectedIndex(2);
                        this.jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
                        this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
                        this.jRTextExpressionAreaTextConnectionExpression.setText(Misc.getExpressionText(datasetRun.getDataSourceExpression()));
                    }
                    DefaultTableModel dtm = (DefaultTableModel)this.jTableDatasetParameters.getModel();
                    dtm.setRowCount(0);
                    JRDatasetParameter[] params = datasetRun.getParameters();
                    for (int i = 0; i < params.length; ++i) {
                        JRDatasetParameter parameter = params[i];
                        Vector<Object> row = new Vector<Object>();
                        row.addElement(parameter);
                        row.addElement(Misc.getExpressionText(parameter.getExpression()));
                        dtm.addRow(row);
                    }
                    dataset = (JRDesignDataset)this.getJasperDesign().getDatasetMap().get(datasetRun.getDatasetName());
                } else {
                    DefaultTableModel dtm = (DefaultTableModel)this.jTableDatasetParameters.getModel();
                    dtm.setRowCount(0);
                    this.jComboBoxDatasetConnectionType.setSelectedIndex(0);
                    this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
                    this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
                    this.jRTextExpressionAreaTextConnectionExpression.setText("");
                    this.jRTextExpressionAreaMapExpression.setText("");
                    this.jComboBoxSubDataset.setSelectedIndex(0);
                    this.jPanel7.remove(this.jTabbedPaneSubDataset);
                }
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 4;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(4, 4, 4, 4);
                this.setExpressionContext(new ExpressionContext(ModelUtils.getDatasetFromCrosstabDataset((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset(), jd)));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ExpressionContext docEc = new ExpressionContext(jd.getMainDesignDataset());
        this.jRTextExpressionAreaMapExpression.setExpressionContext(docEc);
        this.jRTextExpressionAreaTextConnectionExpression.setExpressionContext(docEc);
        this.setInit(false);
    }

    public CrosstabDataDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public CrosstabDataDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, -1, -1, -1);
        this.jComboBoxResetType.addItem(new Tag(new Byte(5), "None"));
        this.jComboBoxResetType.addItem(new Tag(new Byte(1), "Report"));
        this.jComboBoxResetType.addItem(new Tag(new Byte(2), "Page"));
        this.jComboBoxResetType.addItem(new Tag(new Byte(3), "Column"));
        this.jComboBoxResetType.addItem(new Tag(new Byte(4), "Group"));
        this.jComboBoxIncrementType.addItem(new Tag(new Byte(5), "None"));
        this.jComboBoxIncrementType.addItem(new Tag(new Byte(1), "Report"));
        this.jComboBoxIncrementType.addItem(new Tag(new Byte(2), "Page"));
        this.jComboBoxIncrementType.addItem(new Tag(new Byte(3), "Column"));
        this.jComboBoxIncrementType.addItem(new Tag(new Byte(4), "Group"));
        this.jComboBoxDatasetConnectionType.addItem(new Tag("Don't use connection or datasource", "Don't use connection or datasource"));
        this.jComboBoxDatasetConnectionType.addItem(new Tag("Use connection expression", "Use connection expression"));
        this.jComboBoxDatasetConnectionType.addItem(new Tag("Use datasource expression", "Use datasource expression"));
        this.jRTextExpressionAreaMapExpression.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                CrosstabDataDialog.this.jRTextExpressionAreaMapExpressionTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                CrosstabDataDialog.this.jRTextExpressionAreaMapExpressionTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                CrosstabDataDialog.this.jRTextExpressionAreaMapExpressionTextChanged();
            }
        });
        this.jRTextExpressionAreaFilterExpression.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                CrosstabDataDialog.this.jRTextExpressionAreaFilterExpressionTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                CrosstabDataDialog.this.jRTextExpressionAreaFilterExpressionTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                CrosstabDataDialog.this.jRTextExpressionAreaFilterExpressionTextChanged();
            }
        });
        this.jRTextExpressionAreaTextConnectionExpression.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                CrosstabDataDialog.this.jRTextExpressionAreaTextConnectionExpressionTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                CrosstabDataDialog.this.jRTextExpressionAreaTextConnectionExpressionTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                CrosstabDataDialog.this.jRTextExpressionAreaTextConnectionExpressionTextChanged();
            }
        });
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableDatasetParameters.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                CrosstabDataDialog.this.jTableDatasetParametersListSelectionValueChanged(e);
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                CrosstabDataDialog.this.jButtonCloseActionPerformed(e);
            }
        };
        DatasetParametersTableCellRenderer dpcr = new DatasetParametersTableCellRenderer();
        ((DefaultTableColumnModel)this.jTableDatasetParameters.getColumnModel()).getColumn(0).setCellRenderer(dpcr);
        ((DefaultTableColumnModel)this.jTableDatasetParameters.getColumnModel()).getColumn(1).setCellRenderer(dpcr);
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    public void jRTextExpressionAreaMapExpressionTextChanged() {
        JRDesignDatasetRun datasetRun;
        if (this.isInit()) {
            return;
        }
        if (this.currentSelectedCrosstabElement != null && (datasetRun = (JRDesignDatasetRun)this.currentSelectedCrosstabElement.getDataset().getDatasetRun()) != null) {
            JRDesignExpression exp = null;
            if (this.jRTextExpressionAreaMapExpression.getText().trim().length() > 0) {
                exp = new JRDesignExpression();
                exp.setValueClassName("java.util.Map");
                exp.setText(this.jRTextExpressionAreaMapExpression.getText());
            }
            datasetRun.setParametersMapExpression(exp);
            this.notifyChange();
        }
    }

    public void jRTextExpressionAreaFilterExpressionTextChanged() {
        if (this.isInit()) {
            return;
        }
        if (this.currentSelectedCrosstabElement != null) {
            JRDesignExpression exp = null;
            if (this.jRTextExpressionAreaFilterExpression.getText().trim().length() > 0) {
                exp = new JRDesignExpression();
                exp.setValueClassName("java.lang.Boolean");
                exp.setText(this.jRTextExpressionAreaFilterExpression.getText());
            }
            ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setIncrementWhenExpression((JRExpression)exp);
            this.notifyChange();
        }
    }

    public void jRTextExpressionAreaTextConnectionExpressionTextChanged() {
        if (this.isInit()) {
            return;
        }
        if (this.currentSelectedCrosstabElement != null) {
            int index;
            JRDesignExpression exp = null;
            if (this.jRTextExpressionAreaTextConnectionExpression.getText().trim().length() > 0) {
                exp = new JRDesignExpression();
                exp.setText(this.jRTextExpressionAreaMapExpression.getText());
            }
            if ((index = this.jComboBoxDatasetConnectionType.getSelectedIndex()) == 1) {
                if (exp != null) {
                    exp.setValueClassName("java.sql.Connection");
                }
                ((JRDesignDatasetRun)this.currentSelectedCrosstabElement.getDataset().getDatasetRun()).setConnectionExpression((JRExpression)exp);
            } else if (index == 2) {
                if (exp != null) {
                    exp.setValueClassName("net.sf.jasperreports.engine.JRDataSource");
                }
                ((JRDesignDatasetRun)this.currentSelectedCrosstabElement.getDataset().getDatasetRun()).setDataSourceExpression((JRExpression)exp);
            }
            this.notifyChange();
        }
    }

    public void jTableDatasetParametersListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableDatasetParameters.getSelectedRowCount() > 0) {
            this.jButtonModParameter.setEnabled(true);
            this.jButtonRemParameter.setEnabled(true);
        } else {
            this.jButtonModParameter.setEnabled(false);
            this.jButtonRemParameter.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jPanelData = new JPanel();
        this.jPanelDataset = new JPanel();
        this.jCheckBoxPreSorted = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jLabelResetType = new JLabel();
        this.jComboBoxResetType = new JComboBox();
        this.jLabelResetGroup = new JLabel();
        this.jComboBoxResetGroup = new JComboBox();
        this.jLabelIncrementType = new JLabel();
        this.jComboBoxIncrementType = new JComboBox();
        this.jLabelIncrementGroup = new JLabel();
        this.jComboBoxIncrementGroup = new JComboBox();
        this.jLabelIncrementType2 = new JLabel();
        this.jRTextExpressionAreaFilterExpression = new ExpressionEditorArea();
        this.jPanel1 = new JPanel();
        this.jLabelIncrementType1 = new JLabel();
        this.jComboBoxSubDataset = new JComboBox();
        this.jPanel7 = new JPanel();
        this.jTabbedPaneSubDataset = new JTabbedPane();
        this.jPanel4 = new JPanel();
        this.jPanel16 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTableDatasetParameters = new JTable();
        this.jPanel10 = new JPanel();
        this.jButtonAddParameter = new JButton();
        this.jButtonModParameter = new JButton();
        this.jButtonRemParameter = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel26 = new JLabel();
        this.jRTextExpressionAreaMapExpression = new ExpressionEditorArea();
        this.jPanel6 = new JPanel();
        this.jLabel41 = new JLabel();
        this.jComboBoxDatasetConnectionType = new JComboBox();
        this.jRTextExpressionAreaTextConnectionExpression = new ExpressionEditorArea();
        this.jPanel8 = new JPanel();
        this.jButtonClose = new JButton();
        this.setTitle("Crosstab data");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CrosstabDataDialog.this.formWindowClosing(evt);
            }

            public void windowOpened(WindowEvent evt) {
                CrosstabDataDialog.this.formWindowOpened(evt);
            }
        });
        this.jPanelData.setLayout(new GridBagLayout());
        this.jPanelDataset.setLayout(new GridBagLayout());
        this.jCheckBoxPreSorted.setText("Data is pre-sorted");
        this.jCheckBoxPreSorted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabDataDialog.this.jCheckBoxPreSortedActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanelDataset.add((Component)this.jCheckBoxPreSorted, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Dataset"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabelResetType.setText("Reset type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabelResetType, gridBagConstraints);
        this.jComboBoxResetType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabDataDialog.this.jComboBoxResetTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jComboBoxResetType, gridBagConstraints);
        this.jLabelResetGroup.setText("Reset group");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabelResetGroup, gridBagConstraints);
        this.jComboBoxResetGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabDataDialog.this.jComboBoxResetGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jComboBoxResetGroup, gridBagConstraints);
        this.jLabelIncrementType.setText("Increment type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabelIncrementType, gridBagConstraints);
        this.jComboBoxIncrementType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabDataDialog.this.jComboBoxIncrementTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jComboBoxIncrementType, gridBagConstraints);
        this.jLabelIncrementGroup.setText("Increment group");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabelIncrementGroup, gridBagConstraints);
        this.jComboBoxIncrementGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabDataDialog.this.jComboBoxIncrementGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jComboBoxIncrementGroup, gridBagConstraints);
        this.jLabelIncrementType2.setText("Increment When expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabelIncrementType2, gridBagConstraints);
        this.jRTextExpressionAreaFilterExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaFilterExpression.setMinimumSize(new Dimension(400, 50));
        this.jRTextExpressionAreaFilterExpression.setPreferredSize(new Dimension(400, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel2.add((Component)this.jRTextExpressionAreaFilterExpression, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelDataset.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Dataset run"));
        this.jPanel1.setPreferredSize(new Dimension(329, 192));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelIncrementType1.setText("Sub dataset");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel1.add((Component)this.jLabelIncrementType1, gridBagConstraints);
        this.jComboBoxSubDataset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabDataDialog.this.jComboBoxSubDatasetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jComboBoxSubDataset, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel16.setLayout(new GridBagLayout());
        this.jScrollPane2.setMinimumSize(new Dimension(300, 50));
        this.jScrollPane2.setPreferredSize(new Dimension(300, 50));
        this.jTableDatasetParameters.setModel(new DefaultTableModel(new Object[0][], new String[]{"Parameter", "Expression"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableDatasetParameters.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CrosstabDataDialog.this.jTableDatasetParametersMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableDatasetParameters);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel16.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel10.setMinimumSize(new Dimension(100, 10));
        this.jPanel10.setPreferredSize(new Dimension(100, 69));
        this.jPanel10.setLayout(new GridBagLayout());
        this.jButtonAddParameter.setText("Add");
        this.jButtonAddParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabDataDialog.this.jButtonAddParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel10.add((Component)this.jButtonAddParameter, gridBagConstraints);
        this.jButtonModParameter.setText("Modify");
        this.jButtonModParameter.setEnabled(false);
        this.jButtonModParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabDataDialog.this.jButtonModParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel10.add((Component)this.jButtonModParameter, gridBagConstraints);
        this.jButtonRemParameter.setText("Remove");
        this.jButtonRemParameter.setEnabled(false);
        this.jButtonRemParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabDataDialog.this.jButtonRemParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel10.add((Component)this.jButtonRemParameter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel16.add((Component)this.jPanel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jPanel16, gridBagConstraints);
        this.jTabbedPaneSubDataset.addTab("Parameters", this.jPanel4);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel26.setHorizontalAlignment(2);
        this.jLabel26.setText("Parameters Map Expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 8, 0, 0);
        this.jPanel5.add((Component)this.jLabel26, gridBagConstraints);
        this.jRTextExpressionAreaMapExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaMapExpression.setMinimumSize(new Dimension(0, 0));
        this.jRTextExpressionAreaMapExpression.setPreferredSize(new Dimension(300, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel5.add((Component)this.jRTextExpressionAreaMapExpression, gridBagConstraints);
        this.jTabbedPaneSubDataset.addTab("Parameters map exp", this.jPanel5);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jLabel41.setText("Connection / Datasource Expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.jPanel6.add((Component)this.jLabel41, gridBagConstraints);
        this.jComboBoxDatasetConnectionType.setMinimumSize(new Dimension(300, 20));
        this.jComboBoxDatasetConnectionType.setPreferredSize(new Dimension(300, 20));
        this.jComboBoxDatasetConnectionType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabDataDialog.this.jComboBoxDatasetConnectionTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 6);
        this.jPanel6.add((Component)this.jComboBoxDatasetConnectionType, gridBagConstraints);
        this.jRTextExpressionAreaTextConnectionExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
        this.jRTextExpressionAreaTextConnectionExpression.setMinimumSize(new Dimension(300, 50));
        this.jRTextExpressionAreaTextConnectionExpression.setPreferredSize(new Dimension(300, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel6.add((Component)this.jRTextExpressionAreaTextConnectionExpression, gridBagConstraints);
        this.jTabbedPaneSubDataset.addTab("Connection/Datasource exp", this.jPanel6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel7.add((Component)this.jTabbedPaneSubDataset, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 100;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelDataset.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelData.add((Component)this.jPanelDataset, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanelData, "Center");
        this.jPanel8.setLayout(new GridBagLayout());
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabDataDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel8.add((Component)this.jButtonClose, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel8, "South");
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void formWindowClosing(WindowEvent evt) {
        this.notifyChange();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.notifyChange();
        this.setVisible(false);
        this.dispose();
    }

    private void jTableDatasetParametersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && evt.getButton() == 1 && this.jTableDatasetParameters.getSelectedRowCount() > 0) {
            this.jButtonModParameterActionPerformed(null);
        }
    }

    private void jButtonRemParameterActionPerformed(ActionEvent evt) {
        if (this.isInit()) {
            return;
        }
        if (this.currentSelectedCrosstabElement == null) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.jTableDatasetParameters.getModel();
        JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)this.currentSelectedCrosstabElement.getDataset().getDatasetRun();
        while (this.jTableDatasetParameters.getSelectedRowCount() > 0) {
            int i = this.jTableDatasetParameters.getSelectedRow();
            datasetRun.removeParameter(((JRDatasetParameter)this.jTableDatasetParameters.getValueAt(i, 0)).getName());
            dtm.removeRow(i);
        }
        this.notifyChange();
    }

    private void jButtonModParameterActionPerformed(ActionEvent evt) {
        if (this.isInit()) {
            return;
        }
        if (this.currentSelectedCrosstabElement == null) {
            return;
        }
        int rowNumber = this.jTableDatasetParameters.getSelectedRow();
        JRDesignDatasetParameter parameter = (JRDesignDatasetParameter)this.jTableDatasetParameters.getValueAt(this.jTableDatasetParameters.getSelectedRow(), 0);
        HashMap<String, JRDatasetParameter> map = new HashMap<String, JRDatasetParameter>();
        List<JRDatasetParameter> params = Arrays.asList(this.currentSelectedCrosstabElement.getDataset().getDatasetRun().getParameters());
        for (JRDatasetParameter p : params) {
            map.put(p.getName(), p);
        }
        Window pWin = SwingUtilities.windowForComponent(this);
        JRDatasetParameterDialog jrpd = null;
        jrpd = pWin instanceof Dialog ? new JRDatasetParameterDialog((Dialog)pWin, map) : new JRDatasetParameterDialog((Frame)pWin, map);
        ExpressionContext docEc = new ExpressionContext(this.getJasperDesign().getMainDesignDataset());
        jrpd.setExpressionContext(docEc);
        jrpd.setParameter(parameter);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            parameter.setName(jrpd.getParameter().getName());
            parameter.setExpression(jrpd.getParameter().getExpression());
            DefaultTableModel dtm = (DefaultTableModel)this.jTableDatasetParameters.getModel();
            dtm.setValueAt(parameter, rowNumber, 0);
            dtm.setValueAt(parameter.getExpression(), rowNumber, 1);
            this.jTableDatasetParameters.updateUI();
            this.notifyChange();
        }
    }

    private void jButtonAddParameterActionPerformed(ActionEvent evt) {
        if (this.isInit()) {
            return;
        }
        if (this.currentSelectedCrosstabElement == null) {
            return;
        }
        HashMap<String, JRDatasetParameter> map = new HashMap<String, JRDatasetParameter>();
        List<JRDatasetParameter> params = Arrays.asList(this.currentSelectedCrosstabElement.getDataset().getDatasetRun().getParameters());
        for (JRDatasetParameter p : params) {
            map.put(p.getName(), p);
        }
        Window pWin = SwingUtilities.windowForComponent(this);
        JRDatasetParameterDialog jrpd = null;
        jrpd = pWin instanceof Dialog ? new JRDatasetParameterDialog((Dialog)pWin, map) : new JRDatasetParameterDialog((Frame)pWin, map);
        ExpressionContext docEc = new ExpressionContext(this.getJasperDesign().getMainDesignDataset());
        jrpd.setExpressionContext(docEc);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            JRDesignDatasetParameter parameter = jrpd.getParameter();
            try {
                ((JRDesignDatasetRun)this.currentSelectedCrosstabElement.getDataset().getDatasetRun()).addParameter((JRDatasetParameter)parameter);
                DefaultTableModel dtm = (DefaultTableModel)this.jTableDatasetParameters.getModel();
                dtm.addRow(new Object[]{parameter, parameter.getExpression()});
                this.notifyChange();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jComboBoxSubDatasetActionPerformed(ActionEvent evt) {
        if (this.isInit()) {
            return;
        }
        if (this.currentSelectedCrosstabElement != null) {
            if (this.jComboBoxSubDataset.getSelectedIndex() > 0) {
                if (this.currentSelectedCrosstabElement.getDataset().getDatasetRun() == null || !("" + this.jComboBoxSubDataset.getSelectedItem()).equals(this.currentSelectedCrosstabElement.getDataset().getDatasetRun().getDatasetName())) {
                    JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)this.currentSelectedCrosstabElement.getDataset().getDatasetRun();
                    if (datasetRun == null) {
                        datasetRun = new JRDesignDatasetRun();
                        ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setDatasetRun((JRDatasetRun)datasetRun);
                        this.setInit(true);
                        this.jComboBoxDatasetConnectionType.setSelectedIndex(0);
                        this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
                        this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
                        this.jRTextExpressionAreaTextConnectionExpression.setText("");
                        this.jRTextExpressionAreaMapExpression.setText("");
                        this.setInit(false);
                        GridBagConstraints gridBagConstraints = new GridBagConstraints();
                        gridBagConstraints.gridy = 1;
                        gridBagConstraints.gridwidth = 2;
                        gridBagConstraints.fill = 1;
                        gridBagConstraints.weightx = 1.0;
                        gridBagConstraints.weighty = 1.0;
                        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
                        this.jPanel7.add((Component)this.jTabbedPaneSubDataset, gridBagConstraints);
                        this.jPanel7.updateUI();
                    }
                    datasetRun.setDatasetName("" + this.jComboBoxSubDataset.getSelectedItem());
                }
            } else {
                ExpressionContext ec = new ExpressionContext(this.getJasperDesign().getMainDesignDataset());
                ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setDatasetRun(null);
                this.setExpressionContext(ec);
                DefaultTableModel dtm = (DefaultTableModel)this.jTableDatasetParameters.getModel();
                dtm.setRowCount(0);
                this.setInit(true);
                this.jComboBoxDatasetConnectionType.setSelectedIndex(0);
                this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
                this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
                this.jRTextExpressionAreaTextConnectionExpression.setText("");
                this.jRTextExpressionAreaMapExpression.setText("");
                this.setInit(false);
                this.jPanel7.remove(this.jTabbedPaneSubDataset);
                this.jPanel7.updateUI();
            }
        }
        this.notifyChange();
    }

    private void jComboBoxDatasetConnectionTypeActionPerformed(ActionEvent evt) {
        if (this.isInit() || this.currentSelectedCrosstabElement == null) {
            return;
        }
        JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)this.currentSelectedCrosstabElement.getDataset().getDatasetRun();
        if (this.jComboBoxDatasetConnectionType.getSelectedIndex() == 0) {
            this.jRTextExpressionAreaTextConnectionExpression.setText("");
            this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
            this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
            datasetRun.setConnectionExpression(null);
            datasetRun.setDataSourceExpression(null);
        } else if (this.jComboBoxDatasetConnectionType.getSelectedIndex() == 1) {
            this.jRTextExpressionAreaTextConnectionExpression.setText("$P{REPORT_CONNECTION}");
            this.jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
            this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
            datasetRun.setDataSourceExpression(null);
            JRDesignExpression exp = new JRDesignExpression();
            exp.setValueClassName("java.sql.Connection");
            exp.setText("$P{REPORT_CONNECTION}");
            datasetRun.setConnectionExpression((JRExpression)exp);
        } else if (this.jComboBoxDatasetConnectionType.getSelectedIndex() == 2) {
            this.jRTextExpressionAreaTextConnectionExpression.setText("$P{MyDataource}");
            this.jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
            this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
            datasetRun.setConnectionExpression(null);
            JRDesignExpression exp = new JRDesignExpression();
            exp.setValueClassName("net.sf.jasperreports.engine.JRDataSource");
            exp.setText("new net.sf.jasperreports.engine.JREmptyDataSource(1)");
            datasetRun.setDataSourceExpression((JRExpression)exp);
        }
        this.notifyChange();
    }

    private void jComboBoxIncrementGroupActionPerformed(ActionEvent evt) {
        if (this.isInit() || this.currentSelectedCrosstabElement == null) {
            return;
        }
        String name = (String)this.jComboBoxIncrementGroup.getSelectedItem();
        if (name != null && name.trim().length() != 0) {
            ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setIncrementGroup((JRGroup)this.getJasperDesign().getGroupsMap().get(name));
        } else {
            ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setIncrementGroup(null);
        }
    }

    private void jComboBoxIncrementTypeActionPerformed(ActionEvent evt) {
        if (this.isInit() || this.currentSelectedCrosstabElement == null) {
            return;
        }
        byte val = (Byte)((Tag)this.jComboBoxIncrementType.getSelectedItem()).getValue();
        if (val == 4) {
            if (this.getJasperDesign().getGroupsList().size() == 0) {
                this.setInit(true);
                Misc.setComboboxSelectedTagValue(this.jComboBoxIncrementType, new Byte(this.currentSelectedCrosstabElement.getDataset().getIncrementType()));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(CrosstabDataDialog.this.jComboBoxIncrementGroup, "No groups available");
                    }
                });
                this.setInit(false);
                return;
            }
            ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setIncrementType(val);
            this.jComboBoxIncrementGroup.setEnabled(true);
            this.jComboBoxIncrementGroup.setSelectedIndex(0);
        } else {
            ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setIncrementType(val);
            ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setIncrementGroup(null);
            this.jComboBoxIncrementGroup.setEnabled(false);
            this.jComboBoxIncrementGroup.setSelectedItem(null);
        }
    }

    private void jComboBoxResetGroupActionPerformed(ActionEvent evt) {
        if (this.isInit() || this.currentSelectedCrosstabElement == null) {
            return;
        }
        String name = (String)this.jComboBoxResetGroup.getSelectedItem();
        if (name != null && name.trim().length() != 0) {
            ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setResetGroup((JRGroup)this.getJasperDesign().getGroupsMap().get(name));
        } else {
            ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setResetGroup(null);
        }
    }

    private void jComboBoxResetTypeActionPerformed(ActionEvent evt) {
        if (this.isInit() || this.currentSelectedCrosstabElement == null) {
            return;
        }
        byte val = (Byte)((Tag)this.jComboBoxResetType.getSelectedItem()).getValue();
        if (val == 4) {
            if (this.getJasperDesign().getGroupsList().size() == 0) {
                this.setInit(true);
                Misc.setComboboxSelectedTagValue(this.jComboBoxResetType, new Byte(this.currentSelectedCrosstabElement.getDataset().getResetType()));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(CrosstabDataDialog.this.jComboBoxResetGroup, "No groups available");
                    }
                });
                this.setInit(false);
                return;
            }
            ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setResetType(val);
            this.jComboBoxResetGroup.setEnabled(true);
            this.jComboBoxResetGroup.setSelectedIndex(0);
        } else {
            ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setResetType(val);
            ((JRDesignCrosstabDataset)this.currentSelectedCrosstabElement.getDataset()).setResetGroup(null);
            this.jComboBoxResetGroup.setEnabled(false);
            this.jComboBoxResetGroup.setSelectedItem(null);
        }
    }

    private void jCheckBoxPreSortedActionPerformed(ActionEvent evt) {
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void updateGroups() {
        if (this.getJasperDesign() == null) {
            this.jComboBoxResetGroup.removeAllItems();
        } else {
            ArrayList<String> groupNames = new ArrayList<String>();
            for (int i = 0; i < this.getJasperDesign().getGroupsList().size(); ++i) {
                groupNames.add(((JRGroup)this.getJasperDesign().getGroupsList().get(i)).getName());
            }
            Misc.updateComboBox(this.jComboBoxResetGroup, groupNames);
            Misc.updateComboBox(this.jComboBoxIncrementGroup, groupNames);
        }
    }

    public void updateSubDatasets() {
        if (this.getJasperDesign() == null) {
            this.jComboBoxSubDataset.removeAllItems();
            this.jComboBoxSubDataset.addItem("");
        } else {
            ArrayList<String> datasetNames = new ArrayList<String>();
            for (int i = 0; i < this.getJasperDesign().getDatasetsList().size(); ++i) {
                datasetNames.add(((JRDataset)this.getJasperDesign().getDatasetsList().get(i)).getName());
            }
            Misc.updateComboBox(this.jComboBoxSubDataset, datasetNames, true);
        }
    }

    public void setExpressionContext(ExpressionContext ec) {
        this.expressionContext = ec;
        this.jRTextExpressionAreaFilterExpression.setExpressionContext(ec);
    }

    public boolean isInit() {
        return this.init || this.currentSelectedCrosstabElement == null;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public void notifyChange() {
        IReportManager.getInstance().notifyReportChange();
    }
}

