/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.gui.JDBCNBConnectionEditor;
import com.jaspersoft.ireport.designer.data.WizardFieldsProvider;
import com.jaspersoft.ireport.designer.data.fieldsproviders.SQLFieldsProvider;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCNBConnection
extends IReportConnection
implements WizardFieldsProvider {
    private String name;
    private String url;

    @Override
    public Connection getConnection() {
        Connection c = null;
        try {
            final DatabaseConnection dbconn = ConnectionManager.getDefault().getConnection(this.url);
            if (dbconn == null) {
                throw new Exception("Connection " + this.url + " not found.");
            }
            c = dbconn.getJDBCConnection();
            if (c == null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    ConnectionManager.getDefault().showConnectionDialog(dbconn);
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ConnectionManager.getDefault().showConnectionDialog(dbconn);
                        }
                    });
                }
                c = dbconn.getJDBCConnection();
            }
            if (c == null) {
                throw new Exception("Unable to connect.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.showErrorMessage(Misc.formatString("{0}\nGeneral problem: {1}\nPlease check your username and password. The DBMS is running?!", new Object[]{"" + this.url, "" + ex.getMessage()}), "Exception", ex);
        }
        return c;
    }

    private void showErrorMessage(String errorMsg, String title, Throwable theException) {
        final JXErrorPane pane = new JXErrorPane();
        String[] lines = errorMsg.split("\r\n|\n|\r");
        String shortMessage = errorMsg;
        if (lines.length > 4) {
            shortMessage = "";
            for (int i = 0; i < 4; ++i) {
                shortMessage = shortMessage + lines[i] + "\n";
            }
            shortMessage = shortMessage.trim() + "\n...";
        }
        final ErrorInfo ei = new ErrorInfo(title, shortMessage, null, null, theException, null, null);
        Runnable r = new Runnable(){

            public void run() {
                pane.setErrorInfo(ei);
                JXErrorPane.showDialog((Component)Misc.getMainWindow(), (JXErrorPane)pane);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } else {
            r.run();
        }
    }

    @Override
    public JRDataSource getJRDataSource() {
        return new JREmptyDataSource();
    }

    @Override
    public boolean isJDBCConnection() {
        return true;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Url", Misc.nvl(this.getUrl(), ""));
        return map;
    }

    @Override
    public void loadProperties(HashMap map) {
        this.setUrl((String)map.get("Url"));
    }

    @Override
    public String getDescription() {
        return "NetBeans Database JDBC connection";
    }

    @Override
    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JDBCNBConnectionEditor();
    }

    @Override
    public void test() throws Exception {
        Connection conn = null;
        conn = this.getConnection();
        if (conn == null) {
            throw new Exception("");
        }
        JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
    }

    @Override
    public String getQueryLanguage() {
        return "SQL";
    }

    @Override
    public List<JRDesignField> readFields(String query) throws Exception {
        SQLFieldsProvider provider = new SQLFieldsProvider();
        ArrayList<JRDesignField> result = new ArrayList<JRDesignField>();
        JRDesignDataset dataset = new JRDesignDataset(true);
        JRDesignQuery dquery = new JRDesignQuery();
        dquery.setLanguage("SQL");
        dquery.setText(query);
        dataset.setQuery(dquery);
        JRField[] fields = provider.getFields(this, (JRDataset)dataset, new HashMap());
        for (int i = 0; i < fields.length; ++i) {
            result.add((JRDesignField)fields[i]);
        }
        return result;
    }

    @Override
    public boolean supportsDesign() {
        return true;
    }

    @Override
    public String designQuery(String query) {
        try {
            SQLFieldsProvider provider = new SQLFieldsProvider();
            return provider.designQuery(this, query, null);
        }
        catch (Exception ex) {
            return query;
        }
    }
}

