/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;

public class SimpleNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean nativeConnectionNecessaryForNativeStatements = false;
    private boolean nativeConnectionNecessaryForNativePreparedStatements = false;
    private boolean nativeConnectionNecessaryForNativeCallableStatements = false;

    public void setNativeConnectionNecessaryForNativeStatements(boolean nativeConnectionNecessaryForNativeStatements) {
        this.nativeConnectionNecessaryForNativeStatements = nativeConnectionNecessaryForNativeStatements;
    }

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return this.nativeConnectionNecessaryForNativeStatements;
    }

    public void setNativeConnectionNecessaryForNativePreparedStatements(boolean nativeConnectionNecessary) {
        this.nativeConnectionNecessaryForNativePreparedStatements = nativeConnectionNecessary;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return this.nativeConnectionNecessaryForNativePreparedStatements;
    }

    public void setNativeConnectionNecessaryForNativeCallableStatements(boolean nativeConnectionNecessary) {
        this.nativeConnectionNecessaryForNativeCallableStatements = nativeConnectionNecessary;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return this.nativeConnectionNecessaryForNativeCallableStatements;
    }

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        Connection nativeCon = con.getMetaData().getConnection();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning native Connection [" + nativeCon + "] for given Connection handle [" + con + "]"));
        }
        return nativeCon;
    }
}

