/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.QuerySpec;
import mondrian.rolap.sql.SqlQuery;

public abstract class AbstractQuerySpec
implements QuerySpec {
    private final RolapStar star;

    protected AbstractQuerySpec(RolapStar star) {
        this.star = star;
    }

    protected SqlQuery newSqlQuery() {
        return this.getStar().getSqlQuery();
    }

    public RolapStar getStar() {
        return this.star;
    }

    protected abstract void addMeasure(int var1, SqlQuery var2);

    protected abstract boolean isAggregate();

    protected void nonDistinctGenerateSql(SqlQuery sqlQuery, boolean ordered, boolean countOnly) {
        int i;
        RolapStar.Column[] columns = this.getColumns();
        int arity = columns.length;
        if (countOnly) {
            sqlQuery.addSelect("count(*)");
        }
        for (i = 0; i < arity; ++i) {
            RolapStar.Column column = columns[i];
            RolapStar.Table table = column.getTable();
            if (table.isFunky()) continue;
            table.addToFrom(sqlQuery, false, true);
            String expr = column.generateExprString(sqlQuery);
            StarColumnPredicate predicate = this.getColumnPredicate(i);
            String where = RolapStar.Column.createInExpr(expr, predicate, column.getDatatype(), sqlQuery.getDialect());
            if (!where.equals("true")) {
                sqlQuery.addWhere(where);
            }
            if (countOnly) continue;
            SqlQuery.Dialect dialect = sqlQuery.getDialect();
            if (dialect.isAS400()) {
                sqlQuery.addSelect(expr, null);
            } else {
                sqlQuery.addSelect(expr, this.getColumnAlias(i));
            }
            if (this.isAggregate()) {
                sqlQuery.addGroupBy(expr);
            }
            if (!ordered) continue;
            sqlQuery.addOrderBy(expr, true, false, false);
        }
        if (!countOnly) {
            int count = this.getMeasureCount();
            for (i = 0; i < count; ++i) {
                this.addMeasure(i, sqlQuery);
            }
        }
    }
}

