/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.aggmatcher.AggGen;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;
import org.eigenbase.util.property.TriggerBase;

public class FastBatchingCellReader
implements CellReader {
    private static final Logger LOGGER = Logger.getLogger(FastBatchingCellReader.class);
    private static boolean generateAggregateSql = MondrianProperties.instance().GenerateAggregateSql.get();
    private final RolapCube cube;
    private final Map<BatchKey, Batch> batches;
    private int requestCount;
    final AggregationManager aggMgr = AggregationManager.instance();
    private final RolapAggregationManager.PinSet pinnedSegments = this.aggMgr.createPinSet();
    private boolean dirty;
    private static final Logger BATCH_LOGGER;

    public FastBatchingCellReader(RolapCube cube) {
        this.cube = cube;
        this.batches = new HashMap<BatchKey, Batch>();
    }

    public Object get(Evaluator evaluator) {
        RolapEvaluator rolapEvaluator = (RolapEvaluator)evaluator;
        Member[] currentMembers = rolapEvaluator.getMembers();
        CellRequest request = RolapAggregationManager.makeRequest(currentMembers, false, false);
        if (request == null || request.isUnsatisfiable()) {
            return Util.nullValue;
        }
        Object o = this.aggMgr.getCellFromCache(request, this.pinnedSegments);
        if (o == Boolean.TRUE) {
            return RolapUtil.valueNotReadyException;
        }
        if (o != null) {
            return o;
        }
        this.recordCellRequest(request);
        return RolapUtil.valueNotReadyException;
    }

    public int getMissCount() {
        return this.requestCount;
    }

    void recordCellRequest(CellRequest request) {
        if (request.isUnsatisfiable()) {
            return;
        }
        ++this.requestCount;
        BitKey bitkey = request.getConstrainedColumnsBitKey();
        BatchKey key = new BatchKey(bitkey, request.getMeasure().getStar());
        Batch batch = this.batches.get(key);
        if (batch == null) {
            batch = new Batch(request);
            this.batches.put(key, batch);
            if (LOGGER.isDebugEnabled()) {
                RolapStar.Column[] columns;
                StringBuilder buf = new StringBuilder(100);
                buf.append("FastBatchingCellReader: bitkey=");
                buf.append(request.getConstrainedColumnsBitKey());
                buf.append(Util.nl);
                for (RolapStar.Column column : columns = request.getConstrainedColumns()) {
                    buf.append("  ");
                    buf.append(column);
                    buf.append(Util.nl);
                }
                LOGGER.debug((Object)buf.toString());
            }
        }
        batch.add(request);
    }

    boolean isDirty() {
        return this.dirty || !this.batches.isEmpty();
    }

    boolean loadAggregations() {
        return this.loadAggregations(null);
    }

    boolean loadAggregations(Query query) {
        long t1 = System.currentTimeMillis();
        this.requestCount = 0;
        if (this.batches.isEmpty() && !this.dirty) {
            return false;
        }
        ArrayList<Batch> batchList = new ArrayList<Batch>(this.batches.values());
        Collections.sort(batchList, BatchComparator.instance);
        for (Batch batch : batchList) {
            if (query != null) {
                query.checkCancelOrTimeout();
            }
            batch.loadAggregation();
        }
        this.batches.clear();
        if (LOGGER.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            LOGGER.debug((Object)("loadAggregation (millis): " + (t2 - t1)));
        }
        this.dirty = false;
        return true;
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    static {
        MondrianProperties.instance().GenerateAggregateSql.addTrigger((Trigger)new TriggerBase(true){

            public void execute(Property property, String value) {
                generateAggregateSql = property.booleanValue();
            }
        });
        BATCH_LOGGER = Logger.getLogger(Batch.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueColumnConstraintComparator
    implements Comparator<ValueColumnPredicate> {
        static final ValueColumnConstraintComparator instance = new ValueColumnConstraintComparator();

        private ValueColumnConstraintComparator() {
        }

        @Override
        public int compare(ValueColumnPredicate o1, ValueColumnPredicate o2) {
            Object v1 = o1.getValue();
            Object v2 = o2.getValue();
            if (v1.getClass() == v2.getClass() && v1 instanceof Comparable) {
                return ((Comparable)v1).compareTo(v2);
            }
            return v1.toString().compareTo(v2.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BatchComparator
    implements Comparator<Batch> {
        static final BatchComparator instance = new BatchComparator();

        private BatchComparator() {
        }

        @Override
        public int compare(Batch o1, Batch o2) {
            int c;
            int i;
            if (o1.columns.length != o2.columns.length) {
                return o1.columns.length - o2.columns.length;
            }
            for (i = 0; i < o1.columns.length; ++i) {
                c = o1.columns[i].getName().compareTo(o2.columns[i].getName());
                if (c == 0) continue;
                return c;
            }
            for (i = 0; i < o1.columns.length; ++i) {
                c = this.compare(o1.valueSets[i], o2.valueSets[i]);
                if (c == 0) continue;
                return c;
            }
            return 0;
        }

        @Override
        <T> int compare(Set<T> set1, Set<T> set2) {
            if (set1.size() != set2.size()) {
                return set1.size() - set2.size();
            }
            Iterator<T> iter1 = set1.iterator();
            Iterator<T> iter2 = set2.iterator();
            while (iter1.hasNext()) {
                T v2;
                T v1 = iter1.next();
                int c = Util.compareKey(v1, v2 = iter2.next());
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
    }

    class BatchKey {
        BitKey key;
        RolapStar star;

        BatchKey(BitKey key, RolapStar star) {
            this.key = key;
            this.star = star;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.star.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof BatchKey) {
                BatchKey bkey = (BatchKey)other;
                return this.key.equals(bkey.key) && this.star.equals(bkey.star);
            }
            return false;
        }

        public String toString() {
            return this.star.getFactTable().getTableName() + " " + this.key.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Batch {
        final RolapStar.Column[] columns;
        final BitKey constrainedColumnsBitKey;
        final List<RolapStar.Measure> measuresList = new ArrayList<RolapStar.Measure>();
        final Set<StarColumnPredicate>[] valueSets;

        public Batch(CellRequest request) {
            this.columns = request.getConstrainedColumns();
            this.constrainedColumnsBitKey = request.getConstrainedColumnsBitKey();
            this.valueSets = new HashSet[this.columns.length];
            for (int i = 0; i < this.valueSets.length; ++i) {
                this.valueSets[i] = new HashSet<StarColumnPredicate>();
            }
        }

        public void add(CellRequest request) {
            List<StarColumnPredicate> values = request.getValueList();
            for (int j = 0; j < this.columns.length; ++j) {
                this.valueSets[j].add(values.get(j));
            }
            RolapStar.Measure measure = request.getMeasure();
            if (!this.measuresList.contains(measure)) {
                assert (this.measuresList.size() == 0 || measure.getStar() == this.measuresList.get(0).getStar()) : "Measure must belong to same star as other measures";
                this.measuresList.add(measure);
            }
        }

        private RolapStar getStar() {
            RolapStar.Measure measure = this.measuresList.get(0);
            return measure.getStar();
        }

        void loadAggregation() {
            int measureCount;
            boolean tooManyDistinctMeasures;
            if (generateAggregateSql) {
                RolapCube cube = FastBatchingCellReader.this.cube;
                if (cube == null || cube.isVirtual()) {
                    StringBuilder buf = new StringBuilder(64);
                    buf.append("AggGen: Sorry, can not create SQL for virtual Cube \"");
                    buf.append(FastBatchingCellReader.this.cube.getName());
                    buf.append("\", operation not currently supported");
                    BATCH_LOGGER.error((Object)buf.toString());
                } else {
                    AggGen aggGen = new AggGen(FastBatchingCellReader.this.cube.getStar(), this.columns);
                    if (aggGen.isReady()) {
                        System.out.println("createLost:" + Util.nl + aggGen.createLost());
                        System.out.println("insertIntoLost:" + Util.nl + aggGen.insertIntoLost());
                        System.out.println("createCollapsed:" + Util.nl + aggGen.createCollapsed());
                        System.out.println("insertIntoCollapsed:" + Util.nl + aggGen.insertIntoCollapsed());
                    } else {
                        BATCH_LOGGER.error((Object)"AggGen failed");
                    }
                }
            }
            long t1 = System.currentTimeMillis();
            AggregationManager aggmgr = AggregationManager.instance();
            StarColumnPredicate[] predicates = new StarColumnPredicate[this.columns.length];
            for (int j = 0; j < this.columns.length; ++j) {
                AbstractColumnPredicate predicate;
                Set<StarColumnPredicate> valueSet = this.valueSets[j];
                if (valueSet == null) {
                    predicate = LiteralStarPredicate.FALSE;
                } else {
                    ValueColumnPredicate[] values = valueSet.toArray(new ValueColumnPredicate[valueSet.size()]);
                    Arrays.sort(values, ValueColumnConstraintComparator.instance);
                    predicate = new ListColumnPredicate(this.columns[j], Arrays.asList((StarColumnPredicate[])values));
                }
                predicates[j] = predicate;
            }
            SqlQuery.Dialect dialect = this.getStar().getSqlQueryDialect();
            int distinctMeasureCount = this.getDistinctMeasureCount(this.measuresList);
            boolean bl = tooManyDistinctMeasures = distinctMeasureCount > 0 && !dialect.allowsCountDistinct() || distinctMeasureCount > 1 && !dialect.allowsMultipleCountDistinct();
            if (tooManyDistinctMeasures) {
                RolapStar.Measure distinctMeasure;
                while ((distinctMeasure = this.getFirstDistinctMeasure(this.measuresList)) != null) {
                    String expr = distinctMeasure.getExpression().getGenericExpression();
                    ArrayList<RolapStar.Measure> distinctMeasuresList = new ArrayList<RolapStar.Measure>();
                    int i = 0;
                    while (i < this.measuresList.size()) {
                        RolapStar.Measure measure = this.measuresList.get(i);
                        if (measure.getAggregator().isDistinct() && measure.getExpression().getGenericExpression().equals(expr)) {
                            this.measuresList.remove(i);
                            distinctMeasuresList.add(distinctMeasure);
                            continue;
                        }
                        ++i;
                    }
                    RolapStar.Measure[] measures = distinctMeasuresList.toArray(new RolapStar.Measure[distinctMeasuresList.size()]);
                    aggmgr.loadAggregation(measures, this.columns, this.constrainedColumnsBitKey, predicates, FastBatchingCellReader.this.pinnedSegments);
                }
            }
            if ((measureCount = this.measuresList.size()) > 0) {
                RolapStar.Measure[] measures = this.measuresList.toArray(new RolapStar.Measure[measureCount]);
                aggmgr.loadAggregation(measures, this.columns, this.constrainedColumnsBitKey, predicates, FastBatchingCellReader.this.pinnedSegments);
            }
            if (BATCH_LOGGER.isDebugEnabled()) {
                long t2 = System.currentTimeMillis();
                BATCH_LOGGER.debug((Object)("Batch.loadAggregation (millis) " + (t2 - t1)));
            }
        }

        RolapStar.Measure getFirstDistinctMeasure(List<RolapStar.Measure> measuresList) {
            for (RolapStar.Measure measure : measuresList) {
                if (!measure.getAggregator().isDistinct()) continue;
                return measure;
            }
            return null;
        }

        int getDistinctMeasureCount(List<RolapStar.Measure> measuresList) {
            int count = 0;
            for (RolapStar.Measure measure : measuresList) {
                if (!measure.getAggregator().isDistinct()) continue;
                ++count;
            }
            return count;
        }
    }
}

