/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.AbstractStringCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.SetToStrFunDef;
import mondrian.olap.type.TypeUtil;

class TupleToStrFunDef
extends FunDefBase {
    static final TupleToStrFunDef instance = new TupleToStrFunDef();

    private TupleToStrFunDef() {
        super("TupleToStr", "TupleToStr(<Tuple>)", "Constructs a string from a tuple.", "fSt");
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        if (TypeUtil.couldBeMember(call.getArg(0).getType())) {
            final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
            return new AbstractStringCalc(call, new Calc[]{memberCalc}){

                public String evaluateString(Evaluator evaluator) {
                    Member member = memberCalc.evaluateMember(evaluator);
                    if (member.isNull()) {
                        return "";
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append(member.getUniqueName());
                    return buf.toString();
                }
            };
        }
        final TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
        return new AbstractStringCalc(call, new Calc[]{tupleCalc}){

            public String evaluateString(Evaluator evaluator) {
                Member[] members = tupleCalc.evaluateTuple(evaluator);
                if (members == null) {
                    return "";
                }
                StringBuilder buf = new StringBuilder();
                SetToStrFunDef.appendTuple(buf, members);
                return buf.toString();
            }
        };
    }
}

