/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.DriverPool;
import com.jaspersoft.ireport.designer.connection.gui.JDBCConnectionEditor;
import com.jaspersoft.ireport.designer.connection.gui.PasswordDialog;
import com.jaspersoft.ireport.designer.data.WizardFieldsProvider;
import com.jaspersoft.ireport.designer.data.fieldsproviders.SQLFieldsProvider;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCConnection
extends IReportConnection
implements WizardFieldsProvider {
    private String JDBCDriver;
    private String username;
    private String password = null;
    private String url;
    private String database;
    private boolean savePassword;
    private String name;
    private String serverAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() {
        try {
            try {
                String string = this.getJDBCDriver();
                IReportManager.getInstance();
                DriverPool.registerDriver(string, IReportManager.getReportClassLoader());
            }
            catch (Exception ex) {
                DriverPool.registerDriver(this.getJDBCDriver(), this.getClass().getClassLoader());
            }
            Driver driver = DriverPool.getDriver(this.url);
            Properties connectProps = new Properties();
            if ((this.password == null || this.password.equals("")) && !this.isSavePassword()) {
                this.password = this.getPassword();
            }
            connectProps.setProperty("user", this.username);
            connectProps.setProperty("password", this.password);
            Connection conn = driver.connect(this.url, connectProps);
            if (this.getJDBCDriver().toLowerCase().indexOf("oracle") >= 0 && (IReportManager.getInstance().getProperty("oracle_language", "").trim().length() > 0 || IReportManager.getInstance().getProperty("oracle_territory", "").trim().length() > 0)) {
                Statement stmt = null;
                try {
                    stmt = conn.createStatement();
                    if (IReportManager.getInstance().getProperty("oracle_language", "").trim().length() > 0) {
                        stmt.execute("ALTER SESSION SET NLS_LANGUAGE = '" + IReportManager.getInstance().getProperty("oracle_language", "").trim() + "'");
                    }
                    if (IReportManager.getInstance().getProperty("oracle_territory", "").trim().length() > 0) {
                        stmt.execute("ALTER SESSION SET NLS_TERRITORY='" + IReportManager.getInstance().getProperty("oracle_territory", "").trim() + "'");
                    }
                }
                catch (Exception ex) {
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            return conn;
        }
        catch (NoClassDefFoundError ex) {
            this.showErrorMessage(Misc.formatString("{0}\nNoClassDefFoundError!!\nCheck your classpath!\n{1}", new Object[]{"" + this.getName(), "" + ex.getMessage()}), "Exception", ex);
            return null;
        }
        catch (ClassNotFoundException ex) {
            this.showErrorMessage(Misc.formatString("{0}\nClassNotFoundError!\nMsg: {1}\nPossible not found class: {2}\nCheck your classpath!", new Object[]{"" + this.getName(), "" + ex.getMessage(), "" + this.getJDBCDriver()}), "Exception", ex);
            return null;
        }
        catch (SQLException ex) {
            if (!this.savePassword) {
                this.password = null;
            }
            this.showErrorMessage(Misc.formatString("{0}\nSQL problems: {1}\n{2}", new Object[]{"" + this.getName(), "" + ex.getMessage(), "" + this.url}), "Exception", ex);
            return null;
        }
        catch (Exception ex) {
            this.showErrorMessage(Misc.formatString("{0}\nGeneral problem: {1}\nPlease check your username and password. The DBMS is running?!", new Object[]{"" + this.getName(), "" + ex.getMessage()}), "Exception", ex);
            return null;
        }
    }

    private void showErrorMessage(String errorMsg, String title, Throwable theException) {
        final JXErrorPane pane = new JXErrorPane();
        String[] lines = errorMsg.split("\r\n|\n|\r");
        String shortMessage = errorMsg;
        if (lines.length > 4) {
            shortMessage = "";
            for (int i = 0; i < 4; ++i) {
                shortMessage = shortMessage + lines[i] + "\n";
            }
            shortMessage = shortMessage.trim() + "\n...";
        }
        final ErrorInfo ei = new ErrorInfo(title, shortMessage, null, null, theException, null, null);
        Runnable r = new Runnable(){

            public void run() {
                pane.setErrorInfo(ei);
                JXErrorPane.showDialog((Component)Misc.getMainWindow(), (JXErrorPane)pane);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } else {
            r.run();
        }
    }

    @Override
    public JRDataSource getJRDataSource() {
        return new JREmptyDataSource();
    }

    @Override
    public boolean isJDBCConnection() {
        return true;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getJDBCDriver() {
        return this.JDBCDriver;
    }

    public void setJDBCDriver(String JDBCDriver) {
        this.JDBCDriver = JDBCDriver;
    }

    public String getPassword() {
        if (this.isSavePassword()) {
            return this.password;
        }
        try {
            return PasswordDialog.askPassword();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("JDBCDriver", Misc.nvl(this.getJDBCDriver(), ""));
        map.put("Url", Misc.nvl(this.getUrl(), ""));
        map.put("Database", Misc.nvl(this.getDatabase(), ""));
        map.put("Username", Misc.nvl(this.getUsername(), ""));
        if (this.isSavePassword()) {
            map.put("Password", Misc.nvl(this.getPassword(), ""));
        } else {
            map.put("Password", "");
        }
        map.put("SavePassword", "" + this.isSavePassword());
        map.put("ServerAddress", Misc.nvl(this.getServerAddress(), ""));
        return map;
    }

    @Override
    public void loadProperties(HashMap map) {
        this.setJDBCDriver((String)map.get("JDBCDriver"));
        this.setUrl((String)map.get("Url"));
        this.setDatabase((String)map.get("Database"));
        this.setUsername((String)map.get("Username"));
        this.setSavePassword(("" + map.get("SavePassword")).equals("true"));
        if (this.isSavePassword()) {
            this.setPassword(Misc.nvl((String)map.get("Password"), ""));
        }
        this.setServerAddress(Misc.nvl((String)map.get("ServerAddress"), ""));
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    @Override
    public String getDescription() {
        return "Database JDBC connection";
    }

    @Override
    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JDBCConnectionEditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void test() throws Exception {
        Connection conn = null;
        try {
            conn = this.getConnection();
            if (conn == null) {
                throw new Exception("");
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
    }

    @Override
    public String getQueryLanguage() {
        return "SQL";
    }

    @Override
    public List<JRDesignField> readFields(String query) throws Exception {
        SQLFieldsProvider provider = new SQLFieldsProvider();
        ArrayList<JRDesignField> result = new ArrayList<JRDesignField>();
        JRDesignDataset dataset = new JRDesignDataset(true);
        JRDesignQuery dquery = new JRDesignQuery();
        dquery.setLanguage("SQL");
        dquery.setText(query);
        dataset.setQuery(dquery);
        JRField[] fields = provider.getFields(this, (JRDataset)dataset, new HashMap());
        for (int i = 0; i < fields.length; ++i) {
            result.add((JRDesignField)fields[i]);
        }
        return result;
    }

    @Override
    public boolean supportsDesign() {
        return true;
    }

    @Override
    public String designQuery(String query) {
        try {
            SQLFieldsProvider provider = new SQLFieldsProvider();
            return provider.designQuery(this, query, null);
        }
        catch (Exception ex) {
            return query;
        }
    }
}

