/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import org.netbeans.modules.palette.CategoryNode;
import org.netbeans.modules.palette.Utils;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;

public final class RootNode
extends FilterNode {
    static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    private Action[] actions;

    public RootNode(Node node, Lookup lookup) {
        this(node, new InstanceContent(), lookup);
    }

    private RootNode(Node node, InstanceContent instanceContent, Lookup lookup) {
        super(node, (org.openide.nodes.Children)new Children(node, lookup), (Lookup)new ProxyLookup(new Lookup[]{lookup, new AbstractLookup((AbstractLookup.Content)instanceContent), node.getLookup()}));
        DataFolder dataFolder = (DataFolder)this.getOriginal().getCookie(DataFolder.class);
        if (null != dataFolder) {
            instanceContent.add((Object)new DataFolder.Index(dataFolder, (Node)this));
        }
        instanceContent.add((Object)this);
        this.setDisplayName(Utils.getBundleString("CTL_Component_palette"));
    }

    public NewType[] getNewTypes() {
        NewType[] newTypeArray = super.getNewTypes();
        if (null == newTypeArray || newTypeArray.length == 0) {
            newTypeArray = new NewType[]{new NewCategory()};
        }
        return newTypeArray;
    }

    public Action[] getActions(boolean bl) {
        PaletteActions paletteActions;
        if (this.actions == null) {
            this.actions = new Action[]{new Utils.NewCategoryAction((Node)this), null, new Utils.SortCategoriesAction((Node)this), null, new Utils.RefreshPaletteAction()};
        }
        if (null != (paletteActions = (PaletteActions)this.getLookup().lookup(PaletteActions.class))) {
            return Utils.mergeActions(this.actions, paletteActions.getCustomPaletteActions());
        }
        return this.actions;
    }

    public Node.PropertySet[] getPropertySets() {
        return NO_PROPERTIES;
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        return null;
    }

    public void refreshChildren() {
        ((Children)this.getChildren()).refreshNodes();
    }

    void createNewCategory() throws IOException {
        ResourceBundle resourceBundle = Utils.getBundle();
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(resourceBundle.getString("CTL_NewCategoryName"), resourceBundle.getString("CTL_NewCategoryTitle"));
        inputLine.setInputText(resourceBundle.getString("CTL_NewCategoryValue"));
        while (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION) {
            String string = inputLine.getInputText();
            if (!CategoryNode.checkCategoryName((Node)this, string, null)) continue;
            DataFolder dataFolder = (DataFolder)this.getCookie(DataFolder.class);
            FileObject fileObject = dataFolder.getPrimaryFile();
            String string2 = CategoryNode.convertCategoryToFolderName(fileObject, string, null);
            FileObject fileObject2 = fileObject.createFolder(string2);
            if (string2.equals(string)) break;
            fileObject2.setAttribute("categoryName", (Object)string);
            break;
        }
    }

    public boolean canCut() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return Utils.getHelpCtx((Node)this, super.getHelpCtx());
    }

    private static class Children
    extends FilterNode.Children {
        private PaletteFilter filter;
        private Lookup lkp;

        public Children(Node node, Lookup lookup) {
            super(node);
            this.lkp = lookup;
            this.filter = (PaletteFilter)lookup.lookup(PaletteFilter.class);
        }

        protected Node copyNode(Node node) {
            return new CategoryNode(node, this.lkp);
        }

        protected Node[] createNodes(Node node) {
            if (null == this.filter || this.filter.isValidCategory(node.getLookup())) {
                return new Node[]{this.copyNode(node)};
            }
            return null;
        }

        public void refreshNodes() {
            Object[] objectArray = this.original.getChildren().getNodes();
            List list = Collections.emptyList();
            this.setKeys(list);
            this.setKeys(objectArray);
        }
    }

    final class NewCategory
    extends NewType {
        NewCategory() {
        }

        public String getName() {
            return Utils.getBundleString("CTL_NewCategory");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(NewCategory.class);
        }

        public void create() throws IOException {
            RootNode.this.createNewCategory();
        }
    }
}

