/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lexer;

import java.util.Set;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.TokenIdImpl;
import org.netbeans.lib.lexer.token.CustomTextToken;
import org.netbeans.lib.lexer.token.DefaultToken;
import org.netbeans.lib.lexer.token.PropertyToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.TokenPropertyProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenFactory<T extends TokenId> {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    public static final Token SKIP_TOKEN = new TextToken<TokenIdImpl>(new TokenIdImpl("skip-token-id; special id of TokenFactory.SKIP_TOKEN;  It should never be part of token sequence", 0, null), "");
    private final LexerInputOperation<T> operation;

    TokenFactory(LexerInputOperation<T> lexerInputOperation) {
        this.operation = lexerInputOperation;
    }

    public Token<T> createToken(T t) {
        return this.createToken(t, this.operation.readIndex());
    }

    public Token<T> createToken(T t, int n) {
        if (this.isSkipToken(t)) {
            this.operation.tokenRecognized(n, true);
            return this.skipToken();
        }
        if (this.operation.tokenRecognized(n, false)) {
            return new DefaultToken<T>(t, this.operation.tokenLength());
        }
        return new DefaultToken<T>(t, this.operation.tokenLength());
    }

    public Token<T> createToken(T t, int n, PartType partType) {
        this.checkPartTypeNonNull(partType);
        if (partType == PartType.COMPLETE) {
            return this.createToken(t, n);
        }
        if (this.isSkipToken(t)) {
            this.operation.tokenRecognized(n, true);
            return this.skipToken();
        }
        if (this.operation.tokenRecognized(n, false)) {
            return new PropertyToken<T>(t, this.operation.tokenLength(), null, partType);
        }
        return new PropertyToken<T>(t, this.operation.tokenLength(), null, partType);
    }

    public Token<T> getFlyweightToken(T t, String string) {
        assert (string.length() <= this.operation.readIndex());
        if (testing) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == this.operation.readExisting(i)) continue;
                throw new IllegalArgumentException("Flyweight text in TokenFactory.getFlyweightToken(" + t + ", \"" + CharSequenceUtilities.debugText((CharSequence)string) + "\") " + "differs from recognized text: '" + CharSequenceUtilities.debugChar((char)this.operation.readExisting(i)) + "' != '" + CharSequenceUtilities.debugChar((char)string.charAt(i)) + "' at index=" + i);
            }
        }
        if (this.isSkipToken(t)) {
            this.operation.tokenRecognized(string.length(), true);
            return this.skipToken();
        }
        if (this.operation.tokenRecognized(string.length(), false)) {
            return new DefaultToken<T>(t, this.operation.tokenLength());
        }
        if (this.operation.isFlyTokenAllowed()) {
            LanguageOperation<T> languageOperation = this.operation.languageOperation();
            return languageOperation.getFlyweightToken(t, string);
        }
        return new DefaultToken<T>(t, this.operation.tokenLength());
    }

    public Token<T> createPropertyToken(T t, int n, TokenPropertyProvider tokenPropertyProvider, PartType partType) {
        this.checkPartTypeNonNull(partType);
        if (this.isSkipToken(t)) {
            this.operation.tokenRecognized(n, true);
            return this.skipToken();
        }
        if (this.operation.tokenRecognized(n, false)) {
            return new PropertyToken<T>(t, this.operation.tokenLength(), tokenPropertyProvider, partType);
        }
        return new PropertyToken<T>(t, this.operation.tokenLength(), tokenPropertyProvider, partType);
    }

    public Token<T> createCustomTextToken(T t, CharSequence charSequence, int n, PartType partType) {
        this.checkPartTypeNonNull(partType);
        if (this.isSkipToken(t)) {
            this.operation.tokenRecognized(n, true);
            return this.skipToken();
        }
        if (this.operation.tokenRecognized(n, false)) {
            return new CustomTextToken<T>(t, this.operation.tokenLength(), charSequence, partType);
        }
        return new CustomTextToken<T>(t, this.operation.tokenLength(), charSequence, partType);
    }

    private boolean isSkipToken(T t) {
        Set<T> set = this.operation.skipTokenIds();
        return set != null && set.contains(t);
    }

    private Token<T> skipToken() {
        return SKIP_TOKEN;
    }

    private void checkPartTypeNonNull(PartType partType) {
        if (partType == null) {
            throw new IllegalArgumentException("partType must be non-null");
        }
    }
}

