/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class PropertyDialogManager
implements VetoableChangeListener,
ActionListener {
    private static final String PROPERTY_DESCRIPTION = "description";
    private static Throwable doNotNotify;
    private PropertyChangeListener listener;
    private Object oldValue;
    private PropertyEditor editor;
    private PropertyModel model;
    private Node.Property prop;
    private boolean changed = false;
    private Component component;
    private Window dialog;
    private JButton okButton;
    private Runnable errorPerformer;
    private boolean okButtonState = true;
    private Object envStateBeforeDisplay = null;
    private PropertyEnv env;
    private Object lastValueFromEditor;
    private boolean cancelled = false;
    private boolean ok = false;
    private boolean reset = false;

    public PropertyDialogManager(String string, boolean bl, PropertyEditor propertyEditor, PropertyModel propertyModel, PropertyEnv propertyEnv) {
        Object object;
        this.editor = propertyEditor;
        if (propertyEnv != null) {
            propertyEnv.addVetoableChangeListener(this);
        }
        this.component = propertyEditor.getCustomEditor();
        if (this.component == null) {
            throw new NullPointerException("Cannot create a dialog for a null component. Offending property editor class:" + propertyEditor.getClass().getName());
        }
        this.model = propertyModel;
        this.env = propertyEnv;
        HelpCtx helpCtx = null;
        if (propertyEnv != null && (object = propertyEnv.getFeatureDescriptor().getValue("helpID")) != null && object instanceof String && this.component != null && this.component instanceof JComponent) {
            HelpCtx.setHelpIDString((JComponent)((JComponent)this.component), (String)((String)object));
            helpCtx = new HelpCtx((String)object);
        }
        if (this.component instanceof JComponent && (object = ((JComponent)this.component).getClientProperty("title")) instanceof String) {
            string = (String)object;
        }
        this.createDialog(bl, string, helpCtx);
        this.initializeListeners();
    }

    public Window getDialog() {
        return this.dialog;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (this.env != null && "state".equals(propertyChangeEvent.getPropertyName())) {
            boolean bl = this.okButtonState = propertyChangeEvent.getNewValue() != PropertyEnv.STATE_INVALID;
            if (this.okButton != null) {
                this.okButton.setEnabled(this.okButtonState);
            }
        }
    }

    private void createDialog(boolean bl, String string, HelpCtx helpCtx) {
        Object[] objectArray;
        JButton jButton;
        Object object;
        if (this.component instanceof Window) {
            this.dialog = (Window)this.component;
            this.dialog.pack();
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.model instanceof ExPropertyModel && (object = ((ExPropertyModel)this.model).getFeatureDescriptor()) instanceof Node.Property) {
            this.prop = (Node.Property)object;
            bl2 = !this.prop.canWrite();
            bl3 = PropUtils.shallBeRDVEnabled(this.prop);
        }
        if (this.editor == null || bl2) {
            jButton = new JButton(PropertyDialogManager.getString("CTL_Close"));
            jButton.getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_Close"));
            objectArray = new Object[]{jButton};
            object = jButton;
        } else {
            this.okButton = new JButton(PropertyDialogManager.getString("CTL_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_OK"));
            jButton = new JButton(PropertyDialogManager.getString("CTL_Cancel"));
            jButton.setVerifyInputWhenFocusTarget(false);
            jButton.getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_Cancel"));
            jButton.setDefaultCapable(false);
            if (bl3) {
                JButton jButton2 = new JButton();
                String string2 = PropertyDialogManager.getString("CTL_Default");
                Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)string2);
                jButton2.setActionCommand(string2);
                jButton2.getAccessibleContext().setAccessibleDescription(PropertyDialogManager.getString("ACSD_CTL_Default"));
                jButton2.setDefaultCapable(false);
                jButton2.setVerifyInputWhenFocusTarget(false);
                objectArray = "Aqua".equals(UIManager.getLookAndFeel().getID()) ? new Object[]{jButton2, jButton, this.okButton} : new Object[]{this.okButton, jButton2, jButton};
            } else {
                objectArray = "Aqua".equals(UIManager.getLookAndFeel().getID()) ? new Object[]{jButton, this.okButton} : new Object[]{this.okButton, jButton};
            }
            object = this.okButton;
        }
        if (this.env != null && this.okButton != null) {
            boolean bl4 = this.okButtonState = this.env.getState() != PropertyEnv.STATE_INVALID;
            if (this.okButton != null) {
                this.okButton.setEnabled(this.okButtonState);
            }
        }
        if (this.env != null) {
            this.envStateBeforeDisplay = this.env.getState();
        }
        jButton = new DialogDescriptor((Object)this.component, string, bl, objectArray, object, 0, helpCtx, (ActionListener)this);
        this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)jButton);
    }

    private void initializeListeners() {
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (PropertyDialogManager.this.editor != null && !(PropertyDialogManager.this.component instanceof Window)) {
                    PropertyDialogManager.this.cancelled = true;
                    PropertyDialogManager.this.cancelValue();
                }
                if (PropertyDialogManager.this.env != null) {
                    PropertyDialogManager.this.env.removeVetoableChangeListener(PropertyDialogManager.this);
                }
                PropertyDialogManager.this.dialog.dispose();
            }

            public void windowClosed(WindowEvent windowEvent) {
                if (PropertyDialogManager.this.component instanceof Window) {
                    if (PropertyDialogManager.this.component instanceof EnhancedCustomPropertyEditor) {
                        try {
                            Object object = ((EnhancedCustomPropertyEditor)((Object)PropertyDialogManager.this.component)).getPropertyValue();
                            PropertyDialogManager.this.model.setValue(object);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            PropertyDialogManager.notifyUser(invocationTargetException);
                        }
                        catch (IllegalStateException illegalStateException) {
                            PropertyDialogManager.notifyUser(illegalStateException);
                        }
                    } else if (PropertyDialogManager.this.env != null && !PropertyDialogManager.this.env.isChangeImmediate()) {
                        try {
                            PropertyDialogManager.this.model.setValue(PropertyDialogManager.this.lastValueFromEditor);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            PropertyDialogManager.notifyUser(invocationTargetException);
                        }
                        catch (IllegalStateException illegalStateException) {
                            PropertyDialogManager.notifyUser(illegalStateException);
                        }
                    }
                }
                if (PropertyDialogManager.this.listener != null) {
                    PropertyDialogManager.this.editor.removePropertyChangeListener(PropertyDialogManager.this.listener);
                }
                PropertyDialogManager.this.dialog.removeWindowListener(this);
            }
        });
        if (this.editor != null) {
            try {
                this.oldValue = this.model.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastValueFromEditor = this.editor.getValue();
            this.listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PropertyDialogManager.this.changed = true;
                    PropertyDialogManager.this.lastValueFromEditor = PropertyDialogManager.this.editor.getValue();
                    if ("propertyValueValid".equals(propertyChangeEvent.getPropertyName()) && PropertyDialogManager.this.okButton != null && propertyChangeEvent.getNewValue() instanceof Boolean) {
                        Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                        PropertyDialogManager.this.okButtonState = bl;
                        if (PropertyDialogManager.this.env != null) {
                            PropertyDialogManager.this.env.setState(PropertyDialogManager.this.okButtonState ? PropertyEnv.STATE_VALID : PropertyEnv.STATE_INVALID);
                        } else {
                            PropertyDialogManager.this.okButton.setEnabled(PropertyDialogManager.this.okButtonState);
                        }
                        if (propertyChangeEvent.getOldValue() instanceof Runnable) {
                            PropertyDialogManager.this.errorPerformer = (Runnable)propertyChangeEvent.getOldValue();
                        } else {
                            PropertyDialogManager.this.errorPerformer = null;
                        }
                    }
                }
            };
            this.editor.addPropertyChangeListener(this.listener);
            if (this.component == null) {
                throw new NullPointerException(this.editor.getClass().getName() + " returned null from getCustomEditor()");
            }
            this.listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("helpCtx".equals(propertyChangeEvent.getPropertyName()) && PropertyDialogManager.this.dialog instanceof PropertyChangeListener) {
                        ((PropertyChangeListener)((Object)PropertyDialogManager.this.dialog)).propertyChange(propertyChangeEvent);
                    }
                }
            };
            this.component.addPropertyChangeListener(this.listener);
        }
    }

    private void cancelValue() {
        try {
            this.editor.setValue(this.oldValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.changed || this.component instanceof EnhancedCustomPropertyEditor || this.env != null && !this.env.isChangeImmediate()) {
            if (this.env != null && this.envStateBeforeDisplay != null) {
                this.env.setState(this.envStateBeforeDisplay);
            }
            return;
        }
        try {
            this.model.setValue(this.oldValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public boolean wasOK() {
        return this.ok;
    }

    public boolean wasReset() {
        return this.reset;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(PropertyDialogManager.getString("CTL_Cancel"))) {
            this.cancelled = true;
            this.cancelValue();
        }
        this.ok = false;
        this.reset = false;
        if (string.equals(PropertyDialogManager.getString("CTL_Default"))) {
            this.reset = true;
            if (this.prop != null) {
                try {
                    this.prop.restoreDefaultValue();
                }
                catch (IllegalAccessException illegalAccessException) {
                    PropertyDialogManager.notifyUser(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    PropertyDialogManager.notifyUser(invocationTargetException);
                }
            }
        }
        if (string.equals(PropertyDialogManager.getString("CTL_OK"))) {
            this.ok = true;
            if (this.env != null && this.env.getState() == PropertyEnv.STATE_NEEDS_VALIDATION) {
                this.env.setState(PropertyEnv.STATE_VALID);
                if (this.env.getState() != PropertyEnv.STATE_VALID) {
                    return;
                }
            }
            if (this.component instanceof EnhancedCustomPropertyEditor) {
                try {
                    Object object = ((EnhancedCustomPropertyEditor)((Object)this.component)).getPropertyValue();
                    this.model.setValue(object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    PropertyDialogManager.notifyUser(invocationTargetException);
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    PropertyDialogManager.notifyUser(illegalStateException);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    PropertyDialogManager.notifyUser(illegalArgumentException);
                    return;
                }
            }
            if (this.env != null && !this.env.isChangeImmediate()) {
                try {
                    this.model.setValue(this.lastValueFromEditor);
                }
                catch (InvocationTargetException invocationTargetException) {
                    PropertyDialogManager.notifyUser(invocationTargetException);
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    PropertyDialogManager.notifyUser(illegalStateException);
                    return;
                }
            }
            if (!this.okButtonState) {
                if (this.errorPerformer != null) {
                    this.errorPerformer.run();
                }
                return;
            }
        }
        this.changed = false;
        if (this.env != null) {
            this.env.removeVetoableChangeListener(this);
        }
        this.dialog.dispose();
    }

    private static String getString(String string) {
        return NbBundle.getBundle(PropertyDialogManager.class).getString(string);
    }

    static void doNotNotify(Throwable throwable) {
        doNotNotify = throwable;
    }

    static void notify(Throwable throwable) {
        Throwable throwable2 = doNotNotify;
        doNotNotify = null;
        if (throwable2 == throwable) {
            return;
        }
        if (throwable instanceof PropertyVetoException) {
            Exceptions.attachLocalizedMessage((Throwable)throwable, (String)throwable.getLocalizedMessage());
        }
        Exceptions.printStackTrace((Throwable)throwable);
    }

    private static void notifyUser(Exception exception) {
        String string = Exceptions.findLocalizedMessage((Throwable)exception);
        if (string != null) {
            Exceptions.printStackTrace((Throwable)exception);
        } else {
            Logger.getLogger(PropertyDialogManager.class.getName()).log(Level.INFO, null, exception);
        }
    }

    Component getComponent() {
        return this.component;
    }

    PropertyEditor getEditor() {
        return this.editor;
    }
}

