/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.LookupMerger;
import org.netbeans.spi.project.LookupProvider;
import org.openide.ErrorManager;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LookupProviderSupport {
    private LookupProviderSupport() {
    }

    public static Lookup createCompositeLookup(Lookup lookup, String string) {
        return new DelegatingLookupImpl(lookup, string);
    }

    public static LookupMerger<Sources> createSourcesMerger() {
        return new SourcesMerger();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegatingLookupImpl
    extends ProxyLookup
    implements LookupListener {
        private Lookup baseLookup;
        private Lookup.Result<LookupProvider> providerResult;
        private LookupListener providerListener;
        private List<LookupProvider> old = Collections.emptyList();
        private List<Lookup> currentLookups;
        private Lookup.Result<LookupMerger> mergers;
        private Reference<LookupListener> listenerRef;
        private List<Lookup.Result<?>> results = new ArrayList();

        public DelegatingLookupImpl(Lookup lookup, String string) {
            this(lookup, Lookups.forPath((String)string), string);
        }

        public DelegatingLookupImpl(Lookup lookup, Lookup lookup2, String string) {
            assert (lookup != null);
            this.baseLookup = lookup;
            this.providerResult = lookup2.lookup(new Lookup.Template(LookupProvider.class));
            assert (this.isAllJustLookupProviders(lookup2)) : "Layer content at " + string + " contains other than LookupProvider instances! See messages.log file for more details.";
            this.doDelegate(this.providerResult.allInstances());
            this.providerListener = new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    DelegatingLookupImpl.this.doDelegate(DelegatingLookupImpl.this.providerResult.allInstances());
                }
            };
            this.providerResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.providerListener, this.providerResult));
        }

        private boolean isAllJustLookupProviders(Lookup lookup) {
            Lookup.Result result = lookup.lookupResult(Object.class);
            Set set = result.allClasses();
            for (Class clazz : set) {
                if (LookupProvider.class.isAssignableFrom(clazz)) continue;
                Logger.getLogger(LookupProviderSupport.class.getName()).warning("" + clazz.getName() + " is not instance of LookupProvider.");
                return false;
            }
            return true;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.doDelegate(this.providerResult.allInstances());
        }

        private synchronized void doDelegate(Collection<? extends LookupProvider> collection) {
            LookupListener lookupListener;
            for (Lookup.Result<?> object22 : this.results) {
                object22.removeLookupListener((LookupListener)this);
            }
            ArrayList arrayList = new ArrayList();
            for (LookupProvider lookupProvider : collection) {
                if (this.old.contains(lookupProvider)) {
                    int n = this.old.indexOf(lookupProvider);
                    arrayList.add(this.currentLookups.get(n));
                    continue;
                }
                Lookup lookup = lookupProvider.createAdditionalLookup(this.baseLookup);
                assert (lookup != null);
                arrayList.add(lookup);
            }
            this.old = new ArrayList<LookupProvider>(collection);
            this.currentLookups = arrayList;
            arrayList.add(this.baseLookup);
            ProxyLookup proxyLookup = new ProxyLookup(arrayList.toArray(new Lookup[arrayList.size()]));
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            LookupListener lookupListener2 = lookupListener = this.listenerRef != null ? this.listenerRef.get() : null;
            if (lookupListener != null) {
                this.mergers.removeLookupListener(lookupListener);
            }
            this.mergers = proxyLookup.lookupResult(LookupMerger.class);
            lookupListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.mergers);
            this.listenerRef = new WeakReference<LookupListener>(lookupListener);
            this.mergers.addLookupListener(lookupListener);
            for (LookupMerger lookupMerger : this.mergers.allInstances()) {
                Class clazz = lookupMerger.getMergeableClass();
                if (arrayList2.contains(clazz)) {
                    ErrorManager.getDefault().log(16, "Two LookupMerger registered for class " + clazz + ". Only first one will be used");
                    continue;
                }
                arrayList2.add(clazz);
                arrayList3.add(lookupMerger.merge((Lookup)proxyLookup));
                Lookup.Result result = proxyLookup.lookupResult(clazz);
                result.addLookupListener((LookupListener)this);
                this.results.add(result);
            }
            Lookup lookup = Lookups.exclude((Lookup)proxyLookup, (Class[])arrayList2.toArray(new Class[arrayList2.size()]));
            Lookup lookup2 = Lookups.fixed((Object[])arrayList3.toArray(new Object[arrayList3.size()]));
            this.setLookups(new Lookup[]{lookup2, lookup});
        }
    }

    private static class SourcesImpl
    implements Sources,
    ChangeListener,
    LookupListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private Lookup.Result<Sources> delegates;
        private Collection<Sources> currentDelegates = new ArrayList<Sources>();

        private void setLookup(Lookup lookup) {
            if (this.currentDelegates.size() > 0) {
                for (Sources object : this.currentDelegates) {
                    object.removeChangeListener(this);
                }
                this.currentDelegates.clear();
            }
            if (this.delegates != null) {
                this.delegates.removeLookupListener((LookupListener)this);
            }
            Lookup.Result result = lookup.lookupResult(Sources.class);
            for (Sources sources : result.allInstances()) {
                sources.addChangeListener(this);
                this.currentDelegates.add(sources);
            }
            result.addLookupListener((LookupListener)this);
            this.delegates = result;
            this.changeSupport.fireChange();
        }

        public SourceGroup[] getSourceGroups(String string) {
            assert (this.delegates != null);
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
            for (Sources sources : this.delegates.allInstances()) {
                SourceGroup[] sourceGroupArray = sources.getSourceGroups(string);
                if (sourceGroupArray == null) continue;
                arrayList.addAll(Arrays.asList(sourceGroupArray));
            }
            return arrayList.toArray(new SourceGroup[arrayList.size()]);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.changeSupport.fireChange();
        }

        public void resultChanged(LookupEvent lookupEvent) {
            if (this.currentDelegates.size() > 0) {
                for (Sources sources : this.currentDelegates) {
                    sources.removeChangeListener(this);
                }
                this.currentDelegates.clear();
            }
            for (Sources sources : this.delegates.allInstances()) {
                sources.addChangeListener(this);
                this.currentDelegates.add(sources);
            }
            this.changeSupport.fireChange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourcesMerger
    implements LookupMerger<Sources> {
        private SourcesImpl merger;

        private SourcesMerger() {
        }

        @Override
        public Class<Sources> getMergeableClass() {
            return Sources.class;
        }

        @Override
        public Sources merge(Lookup lookup) {
            if (this.merger == null) {
                this.merger = new SourcesImpl();
            }
            this.merger.setLookup(lookup);
            return this.merger;
        }
    }
}

