/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.standalone;

import com.jaspersoft.ireport.designer.wizards.CustomChooserWizardPanel;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

public final class EmptyReportWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            WizardDescriptor.Panel targetChooserPanel = null;
            boolean useCustomChooserPanel = false;
            if (this.wizard.getProperty("useCustomChooserPanel") != null && this.wizard.getProperty("useCustomChooserPanel").equals("true")) {
                targetChooserPanel = new CustomChooserWizardPanel(this.wizard);
            } else {
                System.out.println("Using regular panel...");
                System.out.flush();
                targetChooserPanel = ((TemplateWizard)this.wizard).targetChooser();
            }
            this.panels = new WizardDescriptor.Panel[]{targetChooserPanel};
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        if (this.wizard.getProperty("filename") != null) {
            File f = new File("" + this.wizard.getProperty("filename"));
            ((TemplateWizard)this.wizard).setTargetFolder(DataFolder.findFolder((FileObject)FileUtil.toFileObject((File)f.getParentFile())));
            ((TemplateWizard)this.wizard).setTargetName(f.getName());
        }
        if (((TemplateWizard)this.wizard).getTargetFolder() != null) {
            String fname = ((TemplateWizard)this.wizard).getTargetName();
            String directory = ((TemplateWizard)this.wizard).getTargetFolder().getPrimaryFile().getPath();
            if (fname == null) {
                fname = "Report.jrxml";
                File f = new File(directory, fname);
                int i = 1;
                while (f.exists()) {
                    fname = "Report_" + i + ".jrxml";
                    f = new File(directory, fname);
                    ++i;
                }
            }
            ((TemplateWizard)this.wizard).setTargetName(fname);
        }
        DataFolder df = ((TemplateWizard)this.wizard).getTargetFolder();
        DataObject dTemplate = ((TemplateWizard)this.wizard).getTemplate();
        String targetName = ((TemplateWizard)this.wizard).getTargetName();
        if (targetName.toLowerCase().endsWith(".jrxml")) {
            targetName = targetName.substring(0, targetName.length() - 6);
        }
        DataObject dobj = dTemplate.createFromTemplate(df, targetName);
        OpenCookie cookie = (OpenCookie)dobj.getCookie(OpenCookie.class);
        cookie.open();
        return Collections.singleton(dobj.getPrimaryFile());
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] res = new String[this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.panels[i].getComponent().getName();
        }
        return res;
    }
}

