/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.CLIHandler;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.ExitDialog;
import org.netbeans.core.HtmlBrowserComponent;
import org.netbeans.core.IDESettings;
import org.netbeans.core.LoaderPoolNode;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ModuleSystem;
import org.netbeans.core.startup.layers.SessionManager;
import org.netbeans.core.ui.SwingBrowser;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NbTopManager {
    public static final int IL_MAIN_WINDOW = 1;
    public static final int IL_WINDOWS = 2;
    public static final int IL_WORKSPACES = 4;
    public static final int IL_ALL = 65535;
    private static NbTopManager defaultTopManager;
    private static boolean doingExit;

    public NbTopManager() {
        assert (defaultTopManager == null) : "Only one instance allowed";
        defaultTopManager = this;
        Lookup lookup = Lookup.getDefault();
        if (!(lookup instanceof MainLookup)) {
            throw new ClassCastException("Wrong Lookup impl found: " + lookup);
        }
        MainLookup.startedNbTopManager();
    }

    public static NbTopManager get() {
        assert (defaultTopManager != null) : "Must be initialized already";
        return defaultTopManager;
    }

    public static NbTopManager getUninitialized() {
        return NbTopManager.get();
    }

    public static synchronized boolean isInitialized() {
        return defaultTopManager != null;
    }

    public abstract boolean isInteractive(int var1);

    public final void register(Object object) {
        MainLookup.register((Object)object);
    }

    public final <T, R> void register(T t, InstanceContent.Convertor<T, R> convertor) {
        MainLookup.register(t, convertor);
    }

    public final void unregister(Object object) {
        MainLookup.unregister((Object)object);
    }

    public final <T, R> void unregister(T t, InstanceContent.Convertor<T, R> convertor) {
        MainLookup.unregister(t, convertor);
    }

    public void showHelp(HelpCtx helpCtx) {
        try {
            Class<?> clazz = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass("org.netbeans.api.javahelp.Help");
            Object object = Lookup.getDefault().lookup(clazz);
            if (object != null) {
                Method method = clazz.getMethod("showHelp", HelpCtx.class);
                method.invoke(object, helpCtx);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            Logger.getLogger(NbTopManager.class.getName()).log(Level.WARNING, null, exception);
        }
        Toolkit.getDefaultToolkit().beep();
    }

    private static void saveAll() {
        SaveCookie saveCookie;
        DataObject dataObject = null;
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        DataObject[] dataObjectArray = DataObject.getRegistry().getModified();
        if (dataObjectArray.length == 0) {
            return;
        }
        for (int i = 0; i < dataObjectArray.length; ++i) {
            try {
                dataObject = dataObjectArray[i];
                saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                if (saveCookie == null) continue;
                StatusDisplayer.getDefault().setStatusText(MessageFormat.format(NbBundle.getBundle(NbTopManager.class).getString("CTL_FMT_SavingMessage"), dataObject.getName()));
                saveCookie.save();
                continue;
            }
            catch (IOException iOException) {
                Logger.getLogger(NbTopManager.class.getName()).log(Level.WARNING, null, iOException);
                arrayList.add(dataObject);
            }
        }
        saveCookie = arrayList.iterator();
        while (saveCookie.hasNext()) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle(NbTopManager.class).getString("CTL_Cannot_save"), ((DataObject)saveCookie.next()).getPrimaryFile().getName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getBundle(NbTopManager.class).getString("MSG_AllSaved"));
    }

    public static boolean isModalDialogPresent() {
        return NbTopManager.hasModalDialog(WindowManager.getDefault().getMainWindow()) || NbTopManager.hasModalDialog(new JDialog().getOwner());
    }

    private static boolean hasModalDialog(Window window) {
        Window[] windowArray = window.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i] instanceof Dialog && ((Dialog)windowArray[i]).isModal()) {
                return true;
            }
            if (!NbTopManager.hasModalDialog(windowArray[i])) continue;
            return true;
        }
        return false;
    }

    public static void exit() {
        if (SwingUtilities.isEventDispatchThread()) {
            NbTopManager.doExit();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NbTopManager.doExit();
                }
            });
        }
    }

    public static boolean isExiting() {
        return doingExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doExit() {
        block11: {
            if (doingExit) {
                return;
            }
            doingExit = true;
            try {
                if (System.getProperty("netbeans.close") == null && !ExitDialog.showDialog()) break block11;
                final WindowSystem windowSystem = (WindowSystem)Lookup.getDefault().lookup(WindowSystem.class);
                Runnable runnable = new Runnable(){

                    public void run() {
                        CLIHandler.stopServer();
                        if (windowSystem != null) {
                            windowSystem.hide();
                            windowSystem.save();
                        }
                        if (Boolean.getBoolean("netbeans.close.when.invisible")) {
                            TopSecurityManager.exit((int)0);
                        }
                    }
                };
                if (!Main.getModuleSystem().shutDown(runnable)) break block11;
                try {
                    try {
                        LoaderPoolNode.store();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(NbTopManager.class.getName()).log(Level.WARNING, null, iOException);
                    }
                    try {
                        ((MainLookup)Lookup.getDefault()).storeCache();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(NbTopManager.class.getName()).log(Level.WARNING, null, iOException);
                    }
                    SessionManager.getDefault().close();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Exceptions.printStackTrace((Throwable)throwable);
                }
                Task task = new Task(new Runnable(){

                    public void run() {
                        TopSecurityManager.exit((int)0);
                    }
                });
                RequestProcessor.getDefault().post((Runnable)task);
                task.waitFinished();
            }
            finally {
                doingExit = false;
            }
        }
    }

    public abstract ModuleSystem getModuleSystem();

    public static Lookup getModuleLookup() {
        return Main.getModuleSystem().getManager().getModuleLookup();
    }

    public static List getModuleJars() {
        return Main.getModuleSystem().getModuleJars();
    }

    static {
        doingExit = false;
    }

    public static class NbBrowser {
        private HtmlBrowserComponent brComp;
        private PreferenceChangeListener idePCL;
        private static Lookup.Result factoryResult = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);

        public NbBrowser() {
            HtmlBrowser.Factory factory = IDESettings.getWWWBrowser();
            if (factory == null) {
                factory = new SwingBrowser();
            }
            if (factory.createHtmlBrowserImpl().getComponent() != null) {
                this.brComp = this.findOpenedBrowserComponent();
            }
            if (this.brComp == null) {
                this.brComp = new HtmlBrowserComponent(factory, true, true);
                this.brComp.putClientProperty("TabPolicy", "HideWhenAlone");
            }
            this.setListener();
        }

        private HtmlBrowserComponent findOpenedBrowserComponent() {
            for (Mode mode : WindowManager.getDefault().getModes()) {
                if (!"editor".equals(mode.getName())) continue;
                TopComponent[] topComponentArray = mode.getTopComponents();
                for (int i = 0; i < topComponentArray.length; ++i) {
                    if (!(topComponentArray[i] instanceof HtmlBrowserComponent)) continue;
                    return (HtmlBrowserComponent)topComponentArray[i];
                }
            }
            return null;
        }

        private void showUrl(URL uRL) {
            this.brComp.open();
            this.brComp.requestActive();
            this.brComp.setURL(uRL);
        }

        private void setListener() {
            if (this.idePCL != null) {
                return;
            }
            try {
                this.idePCL = new PreferenceChangeListener(){

                    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                        if ("WWWBrowser".equals(preferenceChangeEvent.getKey())) {
                            ((NbURLDisplayer)HtmlBrowser.URLDisplayer.getDefault()).htmlViewer = null;
                            if (NbBrowser.this.idePCL != null) {
                                IDESettings.getPreferences().removePreferenceChangeListener(NbBrowser.this.idePCL);
                                NbBrowser.this.idePCL = null;
                                NbBrowser.this.brComp = null;
                            }
                        }
                    }
                };
                IDESettings.getPreferences().addPreferenceChangeListener(this.idePCL);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        static {
            factoryResult.allItems();
            factoryResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ((NbURLDisplayer)HtmlBrowser.URLDisplayer.getDefault()).htmlViewer = null;
                }
            });
        }
    }

    public static final class NbLifecycleManager
    extends LifecycleManager {
        public void saveAll() {
            NbTopManager.saveAll();
        }

        public void exit() {
            NbTopManager.exit();
        }
    }

    public static final class NbStatusDisplayer
    extends StatusDisplayer {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private String text = "";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStatusText(String string) {
            NbStatusDisplayer nbStatusDisplayer = this;
            synchronized (nbStatusDisplayer) {
                this.text = string;
            }
            this.cs.fireChange();
            Logger.getLogger(NbStatusDisplayer.class.getName()).log(Level.FINE, "Status text updated: {0}", string);
        }

        public synchronized String getStatusText() {
            return this.text;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }
    }

    public static final class NbURLDisplayer
    extends HtmlBrowser.URLDisplayer {
        private NbBrowser htmlViewer;

        public void showURL(final URL uRL) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (NbURLDisplayer.this.htmlViewer == null) {
                        NbURLDisplayer.this.htmlViewer = new NbBrowser();
                    }
                    NbURLDisplayer.this.htmlViewer.showUrl(uRL);
                }
            });
        }
    }

    public static interface WindowSystem {
        public void show();

        public void hide();

        public void load();

        public void save();

        public void clear();
    }
}

