/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractStringCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Validator;
import mondrian.olap.fun.ArrayHolder;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;

class GenerateFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver ListResolver = new ReflectiveMultiResolver("Generate", "Generate(<Set1>, <Set2>[, ALL])", "Applies a set to each member of another set and joins the resulting sets by union.", new String[]{"fxxx", "fxxxy"}, GenerateFunDef.class);
    static final ReflectiveMultiResolver StringResolver = new ReflectiveMultiResolver("Generate", "Generate(<Set>, <String>[, <String>])", "Applies a set to a string expression and joins resulting sets by string concatenation.", new String[]{"fSxS", "fSxSS"}, GenerateFunDef.class);
    private static final String[] ReservedWords = new String[]{"ALL"};

    public GenerateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Type getResultType(Validator validator, Exp[] args) {
        Type type = args[1].getType();
        if (type instanceof StringType) {
            return type;
        }
        Type memberType = TypeUtil.toMemberOrTupleType(type);
        return new SetType(memberType);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        boolean tuple = ((SetType)listCalc.getType()).getElementType() instanceof TupleType;
        if (call.getArg(1).getType() instanceof StringType) {
            StringCalc stringCalc = compiler.compileString(call.getArg(1));
            StringCalc delimCalc = call.getArgCount() == 3 ? compiler.compileString(call.getArg(2)) : ConstantCalc.constantString("");
            return new GenerateStringCalcImpl(call, listCalc, stringCalc, tuple, delimCalc);
        }
        ListCalc listCalc2 = compiler.compileList(call.getArg(1));
        String literalArg = GenerateFunDef.getLiteralArg(call, 2, "", ReservedWords);
        boolean all = literalArg.equalsIgnoreCase("ALL");
        return new GenerateListCalcImpl(call, listCalc, listCalc2, tuple, all);
    }

    private static class GenerateStringCalcImpl
    extends AbstractStringCalc {
        private final ListCalc listCalc;
        private final StringCalc stringCalc;
        private final boolean tuple;
        private final StringCalc sepCalc;

        public GenerateStringCalcImpl(ResolvedFunCall call, ListCalc listCalc, StringCalc stringCalc, boolean tuple, StringCalc sepCalc) {
            super(call, new Calc[]{listCalc, stringCalc});
            this.listCalc = listCalc;
            this.stringCalc = stringCalc;
            this.tuple = tuple;
            this.sepCalc = sepCalc;
        }

        public String evaluateString(Evaluator evaluator) {
            StringBuilder buf = new StringBuilder();
            int k = 0;
            if (this.tuple) {
                List list1 = this.listCalc.evaluateList(evaluator);
                Evaluator evaluator2 = evaluator.push();
                for (Member[] members : list1) {
                    evaluator2.setContext(members);
                    if (k++ > 0) {
                        String sep = this.sepCalc.evaluateString(evaluator2);
                        buf.append(sep);
                    }
                    String result2 = this.stringCalc.evaluateString(evaluator2);
                    buf.append(result2);
                }
            } else {
                List list1 = this.listCalc.evaluateList(evaluator);
                Evaluator evaluator2 = evaluator.push();
                for (Member member : list1) {
                    evaluator2.setContext(member);
                    if (k++ > 0) {
                        String sep = this.sepCalc.evaluateString(evaluator2);
                        buf.append(sep);
                    }
                    String result2 = this.stringCalc.evaluateString(evaluator2);
                    buf.append(result2);
                }
            }
            return buf.toString();
        }

        public boolean dependsOn(Dimension dimension) {
            return GenerateStringCalcImpl.anyDependsButFirst(this.getCalcs(), dimension);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenerateListCalcImpl
    extends AbstractListCalc {
        private final ListCalc listCalc1;
        private final ListCalc listCalc2;
        private final boolean tuple;
        private final boolean all;

        public GenerateListCalcImpl(ResolvedFunCall call, ListCalc listCalc1, ListCalc listCalc2, boolean tuple, boolean all) {
            super(call, new Calc[]{listCalc1, listCalc2});
            this.listCalc1 = listCalc1;
            this.listCalc2 = listCalc2;
            this.tuple = tuple;
            this.all = all;
        }

        @Override
        public List evaluateList(Evaluator evaluator) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (this.tuple) {
                List list1 = this.listCalc1.evaluateList(evaluator);
                Evaluator evaluator2 = evaluator.push();
                if (this.all) {
                    for (Member[] members : list1) {
                        evaluator2.setContext(members);
                        List result2 = this.listCalc2.evaluateList(evaluator2);
                        result.addAll(result2);
                    }
                } else {
                    HashSet<Object> emitted = new HashSet<Object>();
                    for (Member[] members : list1) {
                        evaluator2.setContext(members);
                        List result2 = this.listCalc2.evaluateList(evaluator2);
                        this.addDistinct(result, result2, emitted);
                    }
                }
            } else {
                List list1 = this.listCalc1.evaluateList(evaluator);
                Evaluator evaluator2 = evaluator.push();
                if (this.all) {
                    for (Member member : list1) {
                        evaluator2.setContext(member);
                        List result2 = this.listCalc2.evaluateList(evaluator2);
                        result.addAll(result2);
                    }
                } else {
                    HashSet<Object> emitted = new HashSet<Object>();
                    for (Member member : list1) {
                        evaluator2.setContext(member);
                        List result2 = this.listCalc2.evaluateList(evaluator2);
                        this.addDistinct(result, result2, emitted);
                    }
                }
            }
            return result;
        }

        private void addDistinct(List<Object> result, List<Object> result2, Set<Object> emitted) {
            for (ArrayHolder<Member> arrayHolder : result2) {
                ArrayHolder<Member> entry = arrayHolder;
                if (entry instanceof Member[]) {
                    entry = new ArrayHolder<Member>((Member[])entry);
                }
                if (!emitted.add(entry)) continue;
                result.add(arrayHolder);
            }
        }

        @Override
        public boolean dependsOn(Dimension dimension) {
            return GenerateListCalcImpl.anyDependsButFirst(this.getCalcs(), dimension);
        }
    }
}

