/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import mondrian.gui.MondrianGuiDef;

public class PropertyTableModel
extends AbstractTableModel {
    private Object parentTarget;
    private String factTable;
    private String factTableSchema;
    private ArrayList names;
    private String errorMsg = null;
    String[] propertyNames;
    Object target;

    public PropertyTableModel(Object t, String[] pNames) {
        this.propertyNames = pNames;
        this.target = t;
    }

    public String getColumnName(int i) {
        if (i == 0) {
            return "Attribute";
        }
        if (i == 1) {
            return "Value";
        }
        return "?";
    }

    public String getRowName(int i) {
        String pName = this.propertyNames[i];
        int j = -1;
        j = pName.indexOf(124);
        if (j != -1) {
            return pName.substring(0, j).trim();
        }
        return this.propertyNames[i];
    }

    public boolean isCellEditable(int row, int col) {
        if (col == 1) {
            Object cellObj = this.getValueAt(row, col);
            return !(cellObj instanceof MondrianGuiDef.Join);
        }
        return false;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.propertyNames.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.propertyNames[rowIndex];
        }
        try {
            String pName = this.propertyNames[rowIndex];
            if (pName.indexOf(124) != -1) {
                Object obj = null;
                String[] pNames = pName.split("\\|", 0);
                for (int j = 0; j < pNames.length; ++j) {
                    if (pNames[j].indexOf(46) != -1) {
                        Field f;
                        String[] pNamesField = pNames[j].trim().split("\\.", 0);
                        if (pNamesField.length > 1 && (obj = (f = this.target.getClass().getField(pNamesField[0].trim())).get(this.target)) != null) {
                            Field f2 = obj.getClass().getField(pNamesField[1].trim());
                            Object obj2 = f2.get(obj);
                            return obj2;
                        }
                        return null;
                    }
                    Field f = this.target.getClass().getField(pNames[j].trim());
                    obj = f.get(this.target);
                    if (obj == null) continue;
                    return obj;
                }
                return obj;
            }
            Field f = this.target.getClass().getField(this.propertyNames[rowIndex]);
            Object obj = f.get(this.target);
            return obj;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "#ERROR";
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setErrorMsg(null);
        try {
            String pName = this.propertyNames[rowIndex];
            int i = -1;
            i = pName.indexOf(124);
            if (i != -1) {
                Field f = this.target.getClass().getField(this.propertyNames[rowIndex].substring(0, i).trim());
                f.set(this.target, aValue);
                String[] pNames = pName.split("\\|", 0);
                for (int j = 1; j < pNames.length; ++j) {
                    String[] pNamesField = pNames[j].trim().split("\\.", 0);
                    Field f2 = this.target.getClass().getField(pNamesField[0].trim());
                    f2.set(this.target, null);
                }
            } else if (this.target instanceof MondrianGuiDef.Level && pName.equals("ordinalExp")) {
                ((MondrianGuiDef.Level)((Object)this.target)).ordinalExp.expressions[0] = (MondrianGuiDef.SQL)((Object)aValue);
            } else if (this.target instanceof MondrianGuiDef.Table && pName.equals("name") || this.target instanceof MondrianGuiDef.Hierarchy && pName.equals("primaryKeyTable") || this.target instanceof MondrianGuiDef.Level && pName.equals("table")) {
                if (aValue != null) {
                    String[] aValues = ((String)aValue).split("->");
                    if (aValues.length == 2) {
                        if (this.target instanceof MondrianGuiDef.Table) {
                            ((MondrianGuiDef.Table)((Object)this.target)).name = aValues[1];
                            ((MondrianGuiDef.Table)((Object)this.target)).schema = aValues[0];
                            this.fireTableDataChanged();
                        } else {
                            Field f = this.target.getClass().getField(this.propertyNames[rowIndex]);
                            f.set(this.target, aValues[1]);
                        }
                    } else {
                        Field f = this.target.getClass().getField(this.propertyNames[rowIndex]);
                        f.set(this.target, aValue);
                    }
                }
            } else if (this.target instanceof MondrianGuiDef.Dimension && pName.equals("foreignKey") || this.target instanceof MondrianGuiDef.DimensionUsage && pName.equals("foreignKey") || this.target instanceof MondrianGuiDef.Measure && pName.equals("column") || this.target instanceof MondrianGuiDef.Hierarchy && pName.equals("primaryKey") || this.target instanceof MondrianGuiDef.Level && pName.equals("column") || this.target instanceof MondrianGuiDef.Property && pName.equals("column")) {
                if (aValue != null) {
                    String[] aValues = ((String)aValue).split("->");
                    Field f = this.target.getClass().getField(this.propertyNames[rowIndex]);
                    f.set(this.target, aValues[aValues.length - 1]);
                }
            } else if (this.propertyNames[rowIndex].equals("name") && !(this.target instanceof MondrianGuiDef.Table) && !aValue.equals(this.target.getClass().getField(this.propertyNames[rowIndex]).get(this.target)) && this.duplicateName(aValue)) {
                this.setErrorMsg("Error setting name property. '" + aValue + "' already exists");
            } else {
                Field f = this.target.getClass().getField(this.propertyNames[rowIndex]);
                f.set(this.target, aValue);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Object getValue() {
        return this.target;
    }

    public Object getParentTarget() {
        return this.parentTarget;
    }

    public void setParentTarget(Object parentTarget) {
        this.parentTarget = parentTarget;
    }

    public String getFactTable() {
        return this.factTable;
    }

    public void setFactTable(String factTable) {
        this.factTable = factTable;
    }

    public String getFactTableSchema() {
        return this.factTableSchema;
    }

    public void setFactTableSchema(String factTableSchema) {
        this.factTableSchema = factTableSchema;
    }

    private boolean duplicateName(Object aValue) {
        return this.names != null && this.names.contains(aValue);
    }

    public ArrayList getNames() {
        return this.names;
    }

    public void setNames(ArrayList names) {
        this.names = names;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}

