/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.netbeans.core.windows.view.ui.toolbars.ConfigureToolbarPanel;
import org.netbeans.core.windows.view.ui.toolbars.ResetToolbarsAction;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConstraints;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarDnDListener;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarLayout;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarProcessor;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarRow;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.XMLDataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public final class ToolbarConfiguration
implements ToolbarPool.Configuration,
PropertyChangeListener {
    protected static final String TOOLBAR_DTD_WEB = "http://www.netbeans.org/dtds/toolbar.dtd";
    protected static final String TOOLBAR_DTD_PUBLIC_ID = "-//NetBeans IDE//DTD toolbar//EN";
    protected static final Class TOOLBAR_PROCESSOR_CLASS = ToolbarProcessor.class;
    protected static final String TOOLBAR_ICON_BASE = "/org/netbeans/core/windows/toolbars/xmlToolbars";
    private static Logger ERR = Logger.getLogger("org.netbeans.core.windows.toolbars");
    private volatile long lastReload;
    protected static final String EXT_XML = "xml";
    protected static final String TAG_CONFIG = "Configuration";
    protected static final String TAG_ROW = "Row";
    protected static final String TAG_TOOLBAR = "Toolbar";
    protected static final String ATT_TOOLBAR_NAME = "name";
    protected static final String ATT_TOOLBAR_POSITION = "position";
    protected static final String ATT_TOOLBAR_VISIBLE = "visible";
    private static JPanel toolbarPanel;
    private static WeakHashMap<ToolbarConfiguration, String> confs2Names;
    private ToolbarLayout toolbarLayout;
    private ToolbarDnDListener toolbarListener;
    private WeakHashMap<String, ToolbarConstraints> allToolbars;
    private Vector<ToolbarRow> toolbarRows;
    private HashMap<ToolbarConstraints, Integer> invisibleToolbars;
    private static JMenu toolbarMenu;
    private WeakHashMap<String, ToolbarConstraints> waitingToolbars;
    private String configName;
    private String configDisplayName;
    private int prefWidth;
    private boolean togglingIconSize = false;
    private final ThreadLocal<Boolean> WRITE_IN_PROGRESS = new ThreadLocal();
    private int lastConfigurationHash = -1;
    PropertyChangeSupport pcs;

    public ToolbarConfiguration(String string, String string2) {
        this.configName = string;
        this.configDisplayName = string2;
        if (this.configDisplayName.endsWith(".xml")) {
            this.configDisplayName = this.configDisplayName.substring(0, this.configDisplayName.length() - ".xml".length());
        }
        this.initInstance();
        confs2Names.put(this, string);
    }

    public ToolbarConfiguration(XMLDataObject xMLDataObject) throws IOException {
        this(xMLDataObject.getNodeDelegate().getName(), xMLDataObject.getNodeDelegate().getDisplayName());
        this.readConfig(xMLDataObject);
    }

    private void readConfig(XMLDataObject xMLDataObject) throws IOException {
        Parser parser = xMLDataObject.createParser();
        ToolbarParser toolbarParser = new ToolbarParser();
        parser.setEntityResolver(toolbarParser);
        parser.setDocumentHandler(toolbarParser);
        InputStream inputStream = null;
        try {
            inputStream = xMLDataObject.getPrimaryFile().getInputStream();
            parser.parse(new InputSource(inputStream));
        }
        catch (Exception exception) {
            throw (IOException)new IOException(exception.toString()).initCause(exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(ToolbarConfiguration.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
        this.checkToolbarRows();
    }

    private void initInstance() {
        this.allToolbars = new WeakHashMap();
        this.waitingToolbars = new WeakHashMap();
        this.toolbarRows = new Vector();
        this.invisibleToolbars = new HashMap();
        this.toolbarListener = new ToolbarDnDListener(this);
    }

    static final String getBundleString(String string) {
        return NbBundle.getMessage(ToolbarConfiguration.class, (String)string);
    }

    public static final ToolbarConfiguration findConfiguration(String string) {
        Map.Entry<ToolbarConfiguration, String> entry2 = null;
        for (Map.Entry<ToolbarConfiguration, String> entry2 : confs2Names.entrySet()) {
            if (!string.equals(entry2.getValue())) continue;
            return entry2.getKey();
        }
        return null;
    }

    void addToolbar(ToolbarRow toolbarRow, ToolbarConstraints toolbarConstraints) {
        if (toolbarConstraints == null) {
            return;
        }
        if (toolbarConstraints.isVisible()) {
            toolbarRow.addToolbar(toolbarConstraints);
        } else {
            int n = toolbarRow == null ? this.toolbarRows.size() : this.toolbarRows.indexOf(toolbarRow);
            this.invisibleToolbars.put(toolbarConstraints, n);
        }
        this.allToolbars.put(toolbarConstraints.getName(), toolbarConstraints);
    }

    ToolbarConstraints removeToolbar(String string) {
        ToolbarConstraints toolbarConstraints = this.allToolbars.remove(string);
        if (toolbarConstraints.destroy()) {
            this.checkToolbarRows();
        }
        return toolbarConstraints;
    }

    void addRow(ToolbarRow toolbarRow) {
        this.addRow(toolbarRow, this.toolbarRows.size());
    }

    void addRow(ToolbarRow toolbarRow, int n) {
        ToolbarRow toolbarRow2 = null;
        ToolbarRow toolbarRow3 = null;
        int n2 = this.toolbarRows.size();
        if (n > 0 && n <= n2) {
            toolbarRow2 = this.toolbarRows.elementAt(n - 1);
        }
        if (n >= 0 && n < n2) {
            toolbarRow3 = this.toolbarRows.elementAt(n);
        }
        if (toolbarRow2 != null) {
            toolbarRow2.setNextRow(toolbarRow);
        }
        toolbarRow.setPrevRow(toolbarRow2);
        toolbarRow.setNextRow(toolbarRow3);
        if (toolbarRow3 != null) {
            toolbarRow3.setPrevRow(toolbarRow);
        }
        this.toolbarRows.insertElementAt(toolbarRow, n);
        this.updateBounds(toolbarRow);
    }

    void removeRow(ToolbarRow toolbarRow) {
        ToolbarRow toolbarRow2 = toolbarRow.getPrevRow();
        ToolbarRow toolbarRow3 = toolbarRow.getNextRow();
        if (toolbarRow2 != null) {
            toolbarRow2.setNextRow(toolbarRow3);
        }
        if (toolbarRow3 != null) {
            toolbarRow3.setPrevRow(toolbarRow2);
        }
        this.toolbarRows.removeElement(toolbarRow);
        this.updateBounds(toolbarRow3);
        this.revalidateWindow();
    }

    void updateBounds(ToolbarRow toolbarRow) {
        while (toolbarRow != null) {
            toolbarRow.updateBounds();
            toolbarRow = toolbarRow.getNextRow();
        }
    }

    private static final ToolbarPool toolbarPool() {
        return ToolbarPool.getDefault();
    }

    void revalidateWindow() {
        ToolbarConfiguration.toolbarPanel().revalidate();
    }

    int rowIndex(ToolbarRow toolbarRow) {
        return this.toolbarRows.indexOf(toolbarRow);
    }

    void updatePrefWidth() {
        this.prefWidth = 0;
        for (ToolbarRow toolbarRow : this.toolbarRows) {
            this.prefWidth = Math.max(this.prefWidth, toolbarRow.getPrefWidth());
        }
    }

    int getPrefWidth() {
        return this.prefWidth;
    }

    int getPrefHeight() {
        if (this.getRowCount() == 0) {
            return 0;
        }
        ToolbarRow toolbarRow = this.toolbarRows.lastElement();
        return this.getRowVertLocation(toolbarRow) + toolbarRow.getPreferredHeight();
    }

    void checkToolbarRows() {
        Object[] objectArray = this.toolbarRows.toArray();
        for (int i = objectArray.length - 1; i >= 0; --i) {
            ToolbarRow toolbarRow = (ToolbarRow)objectArray[i];
            if (!toolbarRow.isEmpty()) continue;
            this.removeRow(toolbarRow);
        }
    }

    int getRowCount() {
        return this.toolbarRows.size();
    }

    ToolbarConstraints getToolbarConstraints(String string) {
        return this.allToolbars.get(string);
    }

    ToolbarConstraints checkToolbarConstraints(String string, Integer n, Boolean bl, int n2) {
        ToolbarConstraints toolbarConstraints = this.allToolbars.get(string);
        if (toolbarConstraints == null) {
            toolbarConstraints = new ToolbarConstraints(this, string, n, bl, n2);
        } else {
            toolbarConstraints.checkNextPosition(n, bl);
        }
        return toolbarConstraints;
    }

    boolean checkConfigurationOver() {
        ToolbarConstraints toolbarConstraints;
        String string;
        int n;
        boolean bl = false;
        String[] stringArray = this.waitingToolbars.keySet().toArray(new String[0]);
        String[] stringArray2 = this.allToolbars.keySet().toArray(new String[0]);
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (ToolbarConfiguration.toolbarPool().findToolbar(string) == null) continue;
            toolbarConstraints = this.waitingToolbars.remove(string);
            this.allToolbars.put(string, toolbarConstraints);
            this.addVisible(toolbarConstraints);
            bl = true;
        }
        for (n = 0; n < stringArray2.length; ++n) {
            string = stringArray2[n];
            if (ToolbarConfiguration.toolbarPool().findToolbar(string) != null) continue;
            toolbarConstraints = this.removeToolbar(string);
            this.waitingToolbars.put(string, toolbarConstraints);
            this.invisibleToolbars.put(toolbarConstraints, toolbarConstraints.rowIndex());
            bl = true;
        }
        if (bl || Utilities.arrayHashCode((Object[])ToolbarConfiguration.toolbarPool().getConfigurations()) != this.lastConfigurationHash) {
            this.rebuildMenu();
        }
        return bl;
    }

    void refresh() {
        this.togglingIconSize = true;
        this.rebuildPanel();
        this.togglingIconSize = false;
        this.rebuildMenu();
    }

    public void rebuildMenu() {
        if (toolbarMenu != null) {
            toolbarMenu.removeAll();
            this.fillToolbarsMenu(toolbarMenu, false);
            this.revalidateWindow();
        }
    }

    private void removeVisible(ToolbarConstraints toolbarConstraints) {
        this.invisibleToolbars.put(toolbarConstraints, toolbarConstraints.rowIndex());
        if (toolbarConstraints.destroy()) {
            this.checkToolbarRows();
        }
        toolbarConstraints.setVisible(false);
    }

    private void addVisible(ToolbarConstraints toolbarConstraints) {
        int n = this.toolbarRows.size();
        int n2 = this.invisibleToolbars.remove(toolbarConstraints);
        toolbarConstraints.setVisible(true);
        for (int i = n2; i < n2 + toolbarConstraints.getRowCount(); ++i) {
            this.getRow(i).addToolbar(toolbarConstraints, toolbarConstraints.getPosition());
        }
        if (n != this.toolbarRows.size()) {
            this.revalidateWindow();
        }
    }

    ToolbarRow getRow(int n) {
        ToolbarRow toolbarRow;
        int n2 = this.toolbarRows.size();
        if (n < 0) {
            toolbarRow = new ToolbarRow(this);
            this.addRow(toolbarRow, 0);
        } else if (n >= n2) {
            toolbarRow = new ToolbarRow(this);
            this.addRow(toolbarRow);
        } else {
            toolbarRow = this.toolbarRows.elementAt(n);
        }
        return toolbarRow;
    }

    ToolbarRow createLastRow() {
        return this.getRow(this.toolbarRows.size());
    }

    void reactivatePanel(boolean bl, boolean bl2) {
        ToolbarConfiguration.toolbarPanel().removeAll();
        this.prefWidth = 0;
        Toolbar[] toolbarArray = ToolbarConfiguration.toolbarPool().getToolbars();
        ToolbarRow toolbarRow = null;
        for (int i = 0; i < toolbarArray.length; ++i) {
            Toolbar toolbar = toolbarArray[i];
            String string = toolbar.getName();
            ToolbarConstraints toolbarConstraints = this.allToolbars.get(string);
            if (toolbarConstraints == null) {
                if (toolbarRow == null) {
                    toolbarRow = this.toolbarRows.isEmpty() ? this.createLastRow() : this.getRow(this.toolbarRows.size() - 1);
                }
                toolbarConstraints = new ToolbarConstraints(this, string, null, Boolean.TRUE);
                this.addToolbar(toolbarRow, toolbarConstraints);
            }
            ToolbarConfiguration.toolbarPanel().add((Component)toolbar, toolbarConstraints);
        }
        this.revalidateWindow();
    }

    private void rebuildPanel() {
        ToolbarConfiguration.toolbarPanel().removeAll();
        this.prefWidth = 0;
        Toolbar[] toolbarArray = ToolbarConfiguration.toolbarPool().getToolbars();
        ToolbarRow toolbarRow = null;
        boolean bl = ToolbarPool.getDefault().getPreferredIconSize() == 16;
        for (int i = 0; i < toolbarArray.length; ++i) {
            Toolbar toolbar = toolbarArray[i];
            String string = toolbar.getName();
            Component[] componentArray = toolbar.getComponents();
            for (int j = 0; j < componentArray.length; ++j) {
                if (!(componentArray[j] instanceof JComponent)) continue;
                if (bl) {
                    ((JComponent)componentArray[j]).putClientProperty("PreferredIconSize", null);
                    continue;
                }
                ((JComponent)componentArray[j]).putClientProperty("PreferredIconSize", 24);
            }
            ToolbarConstraints toolbarConstraints = this.allToolbars.get(string);
            if (toolbarConstraints == null) {
                if (toolbarRow == null) {
                    toolbarRow = this.createLastRow();
                }
                toolbarConstraints = new ToolbarConstraints(this, string, null, Boolean.TRUE);
                this.addToolbar(toolbarRow, toolbarConstraints);
            }
            ToolbarConfiguration.toolbarPanel().add((Component)toolbar, toolbarConstraints);
        }
        this.revalidateWindow();
    }

    boolean isImportantActivateComponent() {
        Toolbar[] toolbarArray;
        Object[] objectArray = this.allToolbars.keySet().toArray();
        if (objectArray.length != (toolbarArray = ToolbarConfiguration.toolbarPool().getToolbars()).length) {
            return true;
        }
        return !this.configName.equals(ToolbarConfiguration.toolbarPool().getConfiguration());
    }

    void reflectChanges() {
        try {
            this.writeDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Component activate() {
        return this.activate(this.isImportantActivateComponent(), true);
    }

    private Component activate(boolean bl, boolean bl2) {
        ToolbarConfiguration.toolbarPool().setToolbarsListener((Toolbar.DnDListener)this.toolbarListener);
        boolean bl3 = this.checkConfigurationOver();
        if (bl || bl3) {
            this.toolbarLayout = new ToolbarLayout(this);
            ToolbarConfiguration.toolbarPanel().setLayout(this.toolbarLayout);
            this.reactivatePanel(bl3, bl2);
            this.rebuildMenu();
        }
        return ToolbarConfiguration.toolbarPanel();
    }

    public String getName() {
        return this.configName;
    }

    public String getDisplayName() {
        return this.configDisplayName;
    }

    public JPopupMenu getContextMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.fillToolbarsMenu(jPopupMenu, true);
        return jPopupMenu;
    }

    public JMenu getToolbarsMenu(JMenu jMenu) {
        this.fillToolbarsMenu(jMenu, false);
        toolbarMenu = jMenu;
        return jMenu;
    }

    public static void resetToolbarIconSize() {
        ToolbarPool.getDefault().setPreferredIconSize(24);
        String string = ToolbarPool.getDefault().getConfiguration();
        ToolbarConfiguration toolbarConfiguration = ToolbarConfiguration.findConfiguration(string);
        if (toolbarConfiguration != null) {
            toolbarConfiguration.refresh();
        }
    }

    private void fillToolbarsMenu(JComponent jComponent, boolean bl) {
        Object object;
        Object object2;
        MainWindow mainWindow = (MainWindow)WindowManager.getDefault().getMainWindow();
        boolean bl2 = mainWindow.isFullScreenMode();
        this.lastConfigurationHash = Utilities.arrayHashCode((Object[])ToolbarPool.getDefault().getConfigurations());
        for (Toolbar toolbar : Arrays.asList(ToolbarPool.getDefault().getToolbars())) {
            object2 = toolbar.getName();
            object = this.allToolbars.get(toolbar.getName());
            if (object == null || toolbar == null) {
                this.checkConfigurationOver();
            }
            if (object == null || toolbar == null) continue;
            Component[] componentArray = new JCheckBoxMenuItem(toolbar.getDisplayName(), ((ToolbarConstraints)object).isVisible());
            componentArray.putClientProperty("ToolbarName", object2);
            componentArray.addActionListener(new ActionListener((String)object2, toolbar){
                final /* synthetic */ String val$tbName;
                final /* synthetic */ Toolbar val$tb;
                {
                    this.val$tbName = string;
                    this.val$tb = toolbar;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ToolbarConstraints toolbarConstraints = (ToolbarConstraints)ToolbarConfiguration.this.allToolbars.get(this.val$tbName);
                    ToolbarConfiguration.this.setToolbarVisible(this.val$tb, !toolbarConstraints.isVisible());
                }
            });
            componentArray.setEnabled(!bl2);
            jComponent.add((Component)componentArray);
        }
        jComponent.add(new JPopupMenu.Separator());
        boolean bl3 = ToolbarPool.getDefault().getPreferredIconSize() == 16;
        object2 = new JCheckBoxMenuItem(ToolbarConfiguration.getBundleString("PROP_smallToolbarIcons"), bl3);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                    boolean bl = jCheckBoxMenuItem.getState();
                    if (bl) {
                        ToolbarPool.getDefault().setPreferredIconSize(16);
                    } else {
                        ToolbarPool.getDefault().setPreferredIconSize(24);
                    }
                    String string = ToolbarPool.getDefault().getConfiguration();
                    ToolbarConfiguration toolbarConfiguration = ToolbarConfiguration.findConfiguration(string);
                    if (toolbarConfiguration != null) {
                        toolbarConfiguration.refresh();
                    }
                }
            }
        });
        ((JMenuItem)object2).setEnabled(!bl2);
        jComponent.add((Component)object2);
        jComponent.add(new JPopupMenu.Separator());
        object = new JMenuItem(new ResetToolbarsAction());
        ((JMenuItem)object).setEnabled(!bl2);
        jComponent.add((Component)object);
        object = new JMenuItem(ToolbarConfiguration.getBundleString("CTL_CustomizeToolbars"));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureToolbarPanel.showConfigureDialog();
            }
        });
        ((JMenuItem)object).setEnabled(!bl2);
        jComponent.add((Component)object);
        for (Component component : jComponent instanceof JPopupMenu ? jComponent.getComponents() : ((JMenu)jComponent).getPopupMenu().getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            AbstractButton abstractButton = (AbstractButton)component;
            if (bl) {
                abstractButton.setText(Actions.cutAmpersand((String)abstractButton.getText()));
                continue;
            }
            Mnemonics.setLocalizedText((AbstractButton)abstractButton, (String)abstractButton.getText());
        }
    }

    boolean isTogglingIconSize() {
        return this.togglingIconSize;
    }

    public void setToolbarVisible(Toolbar toolbar, boolean bl) {
        ToolbarConstraints toolbarConstraints = this.getToolbarConstraints(toolbar.getName());
        if (bl) {
            this.addVisible(toolbarConstraints);
        } else {
            this.removeVisible(toolbarConstraints);
        }
        if (toolbarMenu != null) {
            Component[] componentArray = toolbarMenu.getMenuComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                JComponent jComponent = (JComponent)componentArray[i];
                String string = (String)jComponent.getClientProperty("ToolbarName");
                if (string == null || !string.equals(toolbar.getName())) continue;
                ((JCheckBoxMenuItem)jComponent).setSelected(bl);
                break;
            }
        }
        toolbar.setVisible(bl);
        this.reflectChanges();
        this.firePropertyChange();
    }

    public boolean isToolbarVisible(Toolbar toolbar) {
        ToolbarConstraints toolbarConstraints = this.getToolbarConstraints(toolbar.getName());
        return toolbarConstraints.isVisible();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private void firePropertyChange() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange("constraints", null, null);
        }
    }

    public void writeDocument() throws IOException {
        this.writeDocument(this.configName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(final String string) throws IOException {
        ERR.fine("writeDocument: " + string);
        WritableToolbarConfiguration writableToolbarConfiguration = new WritableToolbarConfiguration(this.toolbarRows, this.invisibleToolbars);
        final StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\"?>\n\n");
        stringBuffer.append("<!DOCTYPE ").append(TAG_CONFIG).append(" PUBLIC \"").append(TOOLBAR_DTD_PUBLIC_ID).append("\" \"").append(TOOLBAR_DTD_WEB).append("\">\n\n").append(writableToolbarConfiguration.toString());
        final FileObject fileObject = NbPlaces.getDefault().toolbars().getPrimaryFile();
        FileSystem fileSystem = fileObject.getFileSystem();
        Boolean bl = this.WRITE_IN_PROGRESS.get();
        try {
            this.WRITE_IN_PROGRESS.set(Boolean.TRUE);
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileLock fileLock = null;
                    OutputStream outputStream = null;
                    FileObject fileObject2 = fileObject.getFileObject(string, ToolbarConfiguration.EXT_XML);
                    if (fileObject2 == null) {
                        fileObject2 = fileObject.createData(string, ToolbarConfiguration.EXT_XML);
                    }
                    try {
                        fileLock = fileObject2.lock();
                        outputStream = fileObject2.getOutputStream(fileLock);
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                        outputStreamWriter.write(stringBuffer.toString());
                        ((Writer)outputStreamWriter).close();
                    }
                    finally {
                        ToolbarConfiguration.this.lastReload = System.currentTimeMillis();
                        ERR.fine("Setting last reload: " + ToolbarConfiguration.this.lastReload);
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
            });
        }
        finally {
            this.WRITE_IN_PROGRESS.set(bl);
        }
        ERR.fine("writeDocument finished");
    }

    private static final synchronized JPanel toolbarPanel() {
        if (toolbarPanel == null) {
            toolbarPanel = new JPanel();
            toolbarPanel.setLayout(new FlowLayout(0));
        }
        return toolbarPanel;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"document".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if (Boolean.TRUE.equals(this.WRITE_IN_PROGRESS.get())) {
            return;
        }
        this.updateConfiguration((XMLDataObject)propertyChangeEvent.getSource());
    }

    void updateConfiguration(final XMLDataObject xMLDataObject) {
        long l = xMLDataObject.getPrimaryFile().lastModified().getTime();
        ERR.fine("Checking modified: " + this.lastReload);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ToolbarConfiguration.this.initInstance();
                    ToolbarConfiguration.this.readConfig(xMLDataObject);
                    ToolbarConfiguration.this.checkConfigurationOver();
                    if (ToolbarConfiguration.this.configName.equals(ToolbarConfiguration.toolbarPool().getConfiguration())) {
                        ERR.fine("Activating the configuration");
                        ToolbarConfiguration.this.activate(true, false);
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(ToolbarConfiguration.class.getName()).log(Level.WARNING, null, iOException);
                }
            }
        });
    }

    int getRowVertLocation(ToolbarRow toolbarRow) {
        int n = this.rowIndex(toolbarRow);
        int n2 = n * 1;
        Iterator<ToolbarRow> iterator = this.toolbarRows.iterator();
        for (int i = 0; i < n; ++i) {
            n2 += iterator.next().getPreferredHeight();
        }
        return n2;
    }

    static {
        confs2Names = new WeakHashMap(10);
    }

    private class ToolbarParser
    extends HandlerBase
    implements EntityResolver {
        private ToolbarRow currentRow = null;
        private int toolbarIndex = 0;

        private ToolbarParser() {
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            if (ToolbarConfiguration.TAG_ROW.equals(string)) {
                this.toolbarIndex = 0;
                this.currentRow = new ToolbarRow(ToolbarConfiguration.this);
                ToolbarConfiguration.this.addRow(this.currentRow);
            } else if (this.currentRow != null && ToolbarConfiguration.TAG_TOOLBAR.equals(string)) {
                String string2;
                String string3 = attributeList.getValue(ToolbarConfiguration.ATT_TOOLBAR_NAME);
                if (string3 == null || string3.equals("")) {
                    return;
                }
                String string4 = attributeList.getValue(ToolbarConfiguration.ATT_TOOLBAR_POSITION);
                Integer n = null;
                if (string4 != null) {
                    n = new Integer(string4);
                }
                Boolean bl = (string2 = attributeList.getValue(ToolbarConfiguration.ATT_TOOLBAR_VISIBLE)) != null ? Boolean.valueOf(string2) : Boolean.TRUE;
                ToolbarConfiguration.this.addToolbar(this.currentRow, ToolbarConfiguration.this.checkToolbarConstraints(string3, n, bl, this.toolbarIndex++));
            }
        }

        public void endElement(String string) throws SAXException {
            if (ToolbarConfiguration.TAG_ROW.equals(string)) {
                this.currentRow = null;
            }
        }

        public InputSource resolveEntity(String string, String string2) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WritableToolbarConfiguration {
        Vector<ToolbarRow.WritableToolbarRow> rows;

        public WritableToolbarConfiguration(Vector<ToolbarRow> vector, Map map) {
            this.initRows(vector);
            this.initInvisible(map);
            this.removeEmptyRows();
        }

        void initRows(Vector<ToolbarRow> vector) {
            this.rows = new Vector();
            for (ToolbarRow toolbarRow : vector) {
                this.rows.addElement(new ToolbarRow.WritableToolbarRow(toolbarRow));
            }
        }

        void initInvisible(Map map) {
            for (ToolbarConstraints toolbarConstraints : map.keySet()) {
                int n;
                for (int i = n = ((Integer)map.get(toolbarConstraints)).intValue(); i < n + toolbarConstraints.getRowCount(); ++i) {
                    this.getRow(i).addToolbar(toolbarConstraints);
                }
            }
        }

        void removeEmptyRows() {
            for (int i = this.rows.size() - 1; i >= 0; --i) {
                ToolbarRow.WritableToolbarRow writableToolbarRow = this.rows.elementAt(i);
                if (!writableToolbarRow.isEmpty()) continue;
                this.rows.removeElement(writableToolbarRow);
            }
        }

        ToolbarRow.WritableToolbarRow getRow(int n) {
            try {
                return this.rows.elementAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.rows.addElement(new ToolbarRow.WritableToolbarRow());
                return this.getRow(n);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<").append(ToolbarConfiguration.TAG_CONFIG).append(">\n");
            Iterator<ToolbarRow.WritableToolbarRow> iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((Object)iterator.next()).toString());
            }
            stringBuffer.append("</").append(ToolbarConfiguration.TAG_CONFIG).append(">\n");
            return stringBuffer.toString();
        }
    }
}

