/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.merge.builtin.visualizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.merge.builtin.visualizer.MergePanel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.awt.JPopupMenuPlus;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class MergeDialogComponent
extends TopComponent
implements ChangeListener {
    public static final String PROP_PANEL_CLOSING = "panelClosing";
    public static final String PROP_ALL_CLOSED = "allPanelsClosed";
    public static final String PROP_ALL_CANCELLED = "allPanelsCancelled";
    public static final String PROP_PANEL_SAVE = "panelSave";
    private Map<MergePanel, MergeNode> nodesForPanels = new HashMap<MergePanel, MergeNode>();
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JButton helpButton;
    private JTabbedPane mergeTabbedPane;
    private JButton okButton;

    public MergeDialogComponent() {
        this.initComponents();
        this.initListeners();
        this.putClientProperty("PersistenceType", "Never");
        this.setName(NbBundle.getMessage(MergeDialogComponent.class, (String)"MergeDialogComponent.title"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MergeDialogComponent.class, (String)"ACSN_Merge_Dialog_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MergeDialogComponent.class, (String)"ACSD_Merge_Dialog_Component"));
        this.mergeTabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MergeDialogComponent.class, (String)"ACSN_Merge_Tabbed_Pane"));
        this.mergeTabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MergeDialogComponent.class, (String)"ACSD_Merge_Tabbed_Pane"));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MergeDialogComponent.class);
    }

    private void initComponents() {
        this.mergeTabbedPane = new JTabbedPane();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.mergeTabbedPane.setTabPlacement(3);
        this.mergeTabbedPane.setPreferredSize(new Dimension(600, 600));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.mergeTabbedPane, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(MergeDialogComponent.class, (String)"BTN_OK"));
        this.okButton.setToolTipText(NbBundle.getBundle(MergeDialogComponent.class).getString("ACS_BTN_OKA11yDesc"));
        this.okButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.buttonsPanel.add((Component)this.okButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(MergeDialogComponent.class, (String)"BTN_Cancel"));
        this.cancelButton.setToolTipText(NbBundle.getBundle(MergeDialogComponent.class).getString("ACS_BTN_CancelA11yDesc"));
        this.cancelButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.helpButton, (String)NbBundle.getMessage(MergeDialogComponent.class, (String)"BTN_Help"));
        this.helpButton.setToolTipText(NbBundle.getBundle(MergeDialogComponent.class).getString("ACS_BTN_HelpA11yDesc"));
        this.helpButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.buttonsPanel.add((Component)this.helpButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add(this.buttonsPanel, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void okButtonActionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        Component[] componentArray;
        MergeDialogComponent mergeDialogComponent = this;
        synchronized (mergeDialogComponent) {
            componentArray = this.mergeTabbedPane.getComponents();
        }
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<SaveCookie> arrayList2 = new ArrayList<SaveCookie>();
        for (int i = 0; i < componentArray.length; ++i) {
            MergeNode eventListener2;
            MergePanel mergePanel = (MergePanel)componentArray[i];
            if (mergePanel.getNumUnresolvedConflicts() > 0 && !bl) {
                bl = true;
            }
            if ((object2 = (SaveCookie)(eventListener2 = this.nodesForPanels.get(mergePanel)).getCookie(SaveCookie.class)) == null) continue;
            arrayList.add(mergePanel.getName());
            arrayList2.add((SaveCookie)object2);
        }
        if (arrayList.size() == 1) {
            object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)(bl ? NbBundle.getMessage(MergeDialogComponent.class, (String)"SaveFileWarningQuestion", arrayList.get(0)) : NbBundle.getMessage(MergeDialogComponent.class, (String)"SaveFileQuestion", arrayList.get(0))), 1));
        } else if (arrayList.size() > 1) {
            object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)(bl ? NbBundle.getMessage(MergeDialogComponent.class, (String)"SaveFilesWarningQuestion", (Object)new Integer(arrayList.size())) : NbBundle.getMessage(MergeDialogComponent.class, (String)"SaveFilesQuestion", (Object)new Integer(arrayList.size()))), 1));
        } else if (bl) {
            object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(MergeDialogComponent.class, (String)"WarningQuestion", (Object)new Integer(arrayList.size())), 2));
            if (object.equals(NotifyDescriptor.NO_OPTION)) {
                return;
            }
        } else {
            object = NotifyDescriptor.YES_OPTION;
        }
        if (!NotifyDescriptor.YES_OPTION.equals(object) && !NotifyDescriptor.NO_OPTION.equals(object)) {
            return;
        }
        if (NotifyDescriptor.YES_OPTION.equals(object) || NotifyDescriptor.OK_OPTION.equals(object)) {
            for (SaveCookie saveCookie : arrayList2) {
                object2 = null;
                try {
                    saveCookie.save();
                }
                catch (UserQuestionException userQuestionException) {
                    Object object3 = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)userQuestionException.getLocalizedMessage()));
                    if (object3 == NotifyDescriptor.OK_OPTION || object3 == NotifyDescriptor.YES_OPTION) {
                        boolean bl2;
                        try {
                            userQuestionException.confirmed();
                            bl2 = true;
                        }
                        catch (IOException iOException) {
                            bl2 = false;
                            object2 = iOException;
                        }
                        if (bl2) {
                            try {
                                saveCookie.save();
                            }
                            catch (IOException iOException) {
                                object2 = iOException;
                            }
                        }
                    }
                    if (object3 != NotifyDescriptor.NO_OPTION) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    object2 = iOException;
                }
                if (object2 == null) continue;
                ErrorManager.getDefault().notify((Throwable)object2);
                return;
            }
        }
        for (int i = 0; i < componentArray.length; ++i) {
            MergePanel mergePanel = (MergePanel)componentArray[i];
            try {
                this.fireVetoableChange(PROP_PANEL_CLOSING, null, mergePanel);
            }
            catch (PropertyVetoException propertyVetoException) {
                return;
            }
            this.removeMergePanel(mergePanel);
        }
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        Help help = (Help)Lookup.getDefault().lookup(Help.class);
        help.showHelp(this.getHelpCtx());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        MergeDialogComponent mergeDialogComponent = this;
        synchronized (mergeDialogComponent) {
            try {
                this.fireVetoableChange(PROP_ALL_CANCELLED, null, null);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentClosed() {
        Component[] componentArray;
        MergeDialogComponent mergeDialogComponent = this;
        synchronized (mergeDialogComponent) {
            try {
                this.fireVetoableChange(PROP_ALL_CANCELLED, null, null);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            componentArray = this.mergeTabbedPane.getComponents();
        }
        for (int i = 0; i < componentArray.length; ++i) {
            MergePanel mergePanel = (MergePanel)componentArray[i];
            this.removeMergePanel(mergePanel);
        }
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle = WindowManager.getDefault().getCurrentWorkspace().getBounds();
        return new Dimension(rectangle.width / 2, (int)((double)rectangle.height / 1.25));
    }

    public int getPersistenceType() {
        return 2;
    }

    public void addNotify() {
        super.addNotify();
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton(this.okButton);
        }
    }

    private void initListeners() {
        this.mergeTabbedPane.addMouseListener((MouseListener)((Object)new PopupMenuImpl()));
        this.mergeTabbedPane.addChangeListener(this);
    }

    public void open(Workspace workspace) {
        super.open(workspace);
        this.requestActive();
    }

    public synchronized void addMergePanel(MergePanel mergePanel) {
        this.mergeTabbedPane.addTab(mergePanel.getName(), mergePanel);
        MergeNode mergeNode = new MergeNode(mergePanel);
        this.nodesForPanels.put(mergePanel, mergeNode);
        this.mergeTabbedPane.setSelectedComponent(mergePanel);
        this.setActivatedNodes(new Node[]{mergeNode});
    }

    public synchronized void removeMergePanel(MergePanel mergePanel) {
        this.mergeTabbedPane.remove(mergePanel);
        this.nodesForPanels.remove(mergePanel);
        if (this.mergeTabbedPane.getTabCount() == 0) {
            try {
                this.fireVetoableChange(PROP_ALL_CLOSED, null, null);
            }
            catch (PropertyVetoException propertyVetoException) {
                return;
            }
            this.close();
        }
    }

    public MergePanel getSelectedMergePanel() {
        Component component = this.mergeTabbedPane.getSelectedComponent();
        if (component == null || !(component instanceof MergePanel)) {
            return null;
        }
        return (MergePanel)component;
    }

    private static JPopupMenu createPopupMenu(MergePanel mergePanel) {
        JPopupMenuPlus jPopupMenuPlus = new JPopupMenuPlus();
        SystemAction[] systemActionArray = mergePanel.getSystemActions();
        for (int i = 0; i < systemActionArray.length; ++i) {
            if (systemActionArray[i] == null) {
                jPopupMenuPlus.addSeparator();
                continue;
            }
            if (systemActionArray[i] instanceof CallableSystemAction) {
                jPopupMenuPlus.add(((CallableSystemAction)systemActionArray[i]).getPopupPresenter());
                continue;
            }
            if (!(systemActionArray[i] instanceof FileSystemAction)) continue;
            jPopupMenuPlus.add(((FileSystemAction)systemActionArray[i]).getPopupPresenter());
        }
        return jPopupMenuPlus;
    }

    private static void showPopupMenu(JPopupMenu jPopupMenu, Point point, Component component) {
        SwingUtilities.convertPointToScreen(point, component);
        Dimension dimension = jPopupMenu.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (point.x + dimension.width > dimension2.width) {
            point.x = dimension2.width - dimension.width;
        }
        if (point.y + dimension.height > dimension2.height) {
            point.y = dimension2.height - dimension.height;
        }
        SwingUtilities.convertPointFromScreen(point, component);
        jPopupMenu.show(component, point.x, point.y);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Node node;
        MergePanel mergePanel = (MergePanel)this.mergeTabbedPane.getSelectedComponent();
        if (mergePanel != null && (node = (Node)this.nodesForPanels.get(mergePanel)) != null) {
            this.setActivatedNodes(new Node[]{node});
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == MergeDialogComponent.this.okButton) {
                MergeDialogComponent.this.okButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == MergeDialogComponent.this.cancelButton) {
                MergeDialogComponent.this.cancelButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == MergeDialogComponent.this.helpButton) {
                MergeDialogComponent.this.helpButtonActionPerformed(actionEvent);
            }
        }
    }

    private class MergeNode
    extends AbstractNode
    implements PropertyChangeListener,
    SaveCookie {
        private Reference<MergePanel> mergePanelRef;

        public MergeNode(MergePanel mergePanel) {
            super(Children.LEAF);
            mergePanel.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)mergePanel));
            this.mergePanelRef = new WeakReference<MergePanel>(mergePanel);
            this.getCookieSet().add((Node.Cookie)new CloseCookieImpl());
        }

        private void activateSave() {
            this.getCookieSet().add((Node.Cookie)this);
        }

        private void deactivateSave() {
            this.getCookieSet().remove((Node.Cookie)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("canBeSaved".equals(propertyChangeEvent.getPropertyName())) {
                this.activateSave();
            } else if ("canNotBeSaved".equals(propertyChangeEvent.getPropertyName())) {
                this.deactivateSave();
            }
        }

        public void save() throws IOException {
            try {
                MergeDialogComponent.this.fireVetoableChange(MergeDialogComponent.PROP_PANEL_SAVE, null, this.mergePanelRef.get());
            }
            catch (PropertyVetoException propertyVetoException) {
                Throwable throwable = propertyVetoException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new IOException(propertyVetoException.getLocalizedMessage());
            }
        }

        private class CloseCookieImpl
        implements CloseCookie {
            public boolean close() {
                try {
                    MergeDialogComponent.this.fireVetoableChange(MergeDialogComponent.PROP_PANEL_CLOSING, null, MergeNode.this.mergePanelRef.get());
                }
                catch (PropertyVetoException propertyVetoException) {
                    return false;
                }
                MergeDialogComponent.this.removeMergePanel((MergePanel)MergeNode.this.mergePanelRef.get());
                return true;
            }
        }
    }

    private class PopupMenuImpl
    extends MouseUtils.PopupMouseAdapter {
        protected void showPopup(MouseEvent mouseEvent) {
            TabbedPaneUI tabbedPaneUI = MergeDialogComponent.this.mergeTabbedPane.getUI();
            int n = tabbedPaneUI.tabForCoordinate(MergeDialogComponent.this.mergeTabbedPane, mouseEvent.getX(), mouseEvent.getY());
            MergePanel mergePanel = MergeDialogComponent.this.getSelectedMergePanel();
            if (mergePanel == null) {
                return;
            }
            if (n != -1) {
                MergeDialogComponent.showPopupMenu(MergeDialogComponent.createPopupMenu(mergePanel), mouseEvent.getPoint(), MergeDialogComponent.this.mergeTabbedPane);
            }
        }
    }
}

