/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jaspersoft.ireport.designer.subreport;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.engine.design.JRDesignDataset;

public final class SubreportElementConnectionVisualPanel extends JPanel {

    private SubreportElementConnectionWizardPanel panel = null;
    
    /** Creates new form SubreportElementConnectionVisualPanel */
    public SubreportElementConnectionVisualPanel(SubreportElementConnectionWizardPanel panel) {
        initComponents();
        
        this.panel = panel;
        
        // Set the context...
        ExpressionContext context = new ExpressionContext( (JRDesignDataset)IReportManager.getInstance().getActiveReport().getMainDataset() ); 
        connectionExpressionEditorArea.setExpressionContext(context);
        datasourceExpressionEditorArea.setExpressionContext(context);
        
        connectionExpressionEditorArea.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent e) {
                getPanel().fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                getPanel().fireChangeEvent();
            }

            public void changedUpdate(DocumentEvent e) {
                getPanel().fireChangeEvent();
            }
        });
        
    }

    @Override
    public String getName() {
        return "Connection exp";
    }
    
    public void validateForm() throws IllegalArgumentException
    {
        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();
        connectionExpressionEditorArea = new com.jaspersoft.ireport.designer.editor.ExpressionEditorArea();
        jRadioButton3 = new javax.swing.JRadioButton();
        datasourceExpressionEditorArea = new com.jaspersoft.ireport.designer.editor.ExpressionEditorArea();
        jRadioButton4 = new javax.swing.JRadioButton();
        jRadioButton5 = new javax.swing.JRadioButton();

        setLayout(new java.awt.GridBagLayout());

        buttonGroup1.add(jRadioButton1);
        jRadioButton1.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButton1, "Use the same connection used to fill the master report");
        jRadioButton1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButton1StateChanged(evt);
            }
        });
        jRadioButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 10, 20);
        add(jRadioButton1, gridBagConstraints);

        buttonGroup1.add(jRadioButton2);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButton2, "Use another connection");
        jRadioButton2.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButton2StateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 20);
        add(jRadioButton2, gridBagConstraints);

        connectionExpressionEditorArea.setEnabled(false);
        connectionExpressionEditorArea.setMinimumSize(new java.awt.Dimension(48, 50));
        connectionExpressionEditorArea.setPreferredSize(new java.awt.Dimension(133, 50));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 40, 10, 20);
        add(connectionExpressionEditorArea, gridBagConstraints);

        buttonGroup1.add(jRadioButton3);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButton3, "Use a JRDatasource expression");
        jRadioButton3.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButton3StateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 20);
        add(jRadioButton3, gridBagConstraints);

        datasourceExpressionEditorArea.setEnabled(false);
        datasourceExpressionEditorArea.setMinimumSize(new java.awt.Dimension(48, 50));
        datasourceExpressionEditorArea.setPreferredSize(new java.awt.Dimension(133, 50));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 40, 10, 20);
        add(datasourceExpressionEditorArea, gridBagConstraints);

        buttonGroup1.add(jRadioButton4);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButton4, "Use an empty data source");
        jRadioButton4.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButton4StateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 10, 20);
        add(jRadioButton4, gridBagConstraints);

        buttonGroup1.add(jRadioButton5);
        org.openide.awt.Mnemonics.setLocalizedText(jRadioButton5, "Don't use any connection or data source");
        jRadioButton5.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRadioButton5StateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 20);
        add(jRadioButton5, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jRadioButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton1ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jRadioButton1ActionPerformed

    private void jRadioButton1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButton1StateChanged
        updateSelection();
    }//GEN-LAST:event_jRadioButton1StateChanged

    private void jRadioButton2StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButton2StateChanged
        updateSelection();
    }//GEN-LAST:event_jRadioButton2StateChanged

    private void jRadioButton5StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButton5StateChanged
        updateSelection();
    }//GEN-LAST:event_jRadioButton5StateChanged

    private void jRadioButton3StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButton3StateChanged
        updateSelection();
    }//GEN-LAST:event_jRadioButton3StateChanged

    private void jRadioButton4StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButton4StateChanged
        updateSelection();
    }//GEN-LAST:event_jRadioButton4StateChanged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private com.jaspersoft.ireport.designer.editor.ExpressionEditorArea connectionExpressionEditorArea;
    private com.jaspersoft.ireport.designer.editor.ExpressionEditorArea datasourceExpressionEditorArea;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JRadioButton jRadioButton3;
    private javax.swing.JRadioButton jRadioButton4;
    private javax.swing.JRadioButton jRadioButton5;
    // End of variables declaration//GEN-END:variables

    
    private void updateSelection()
    {
        connectionExpressionEditorArea.setEnabled(jRadioButton2.isSelected());
        datasourceExpressionEditorArea.setEnabled(jRadioButton3.isSelected());
        getPanel().fireChangeEvent();
    }
    
    public SubreportElementConnectionWizardPanel getPanel() {
        return panel;
    }

    public void setPanel(SubreportElementConnectionWizardPanel panel) {
        this.panel = panel;
    }

    /**
     * 
     * @return the expression of the selected expression type...
     */
    public String getConnectionExpression()
    {
        if (jRadioButton1.isSelected())
            return "$P{REPORT_CONNECTION}";
        
        if (jRadioButton2.isSelected())
            return connectionExpressionEditorArea.getText();
        return null;
    }
    
    
    public String getDatasourceExpression()
    {
        if (jRadioButton3.isSelected())
            return datasourceExpressionEditorArea.getText();
        
        if (jRadioButton4.isSelected())
            return "new net.sf.jasperreports.engine.JRDataSource()";
        
        return null;
    }
}

