/*
 * ElementPropertiesFactory.java
 * 
 * Created on 31-ott-2007, 23.03.43
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jaspersoft.ireport.designer.sheet.properties;

import net.sf.jasperreports.engine.design.JRDesignElement;

    
/**
 *  Class to manage the JRDesignElement.PROPERTY_WIDTH property
 */
public final class WidthProperty extends IntegerProperty
{
    private final JRDesignElement element;

    @SuppressWarnings("unchecked")
    public WidthProperty(JRDesignElement element)
    {
        super(element);
        this.element = element;
    }

    @Override
    public String getName()
    {
        return JRDesignElement.PROPERTY_WIDTH;
    }

    @Override
    public String getDisplayName()
    {
        return "Width";
    }

    @Override
    public String getShortDescription()
    {
        return "Element width.";
    }

    @Override
    public Integer getInteger()
    {
        return element.getWidth();
    }

    @Override
    public Integer getOwnInteger()
    {
        return element.getWidth();
    }

    @Override
    public Integer getDefaultInteger()
    {
        return 10;//FIXMETD is this a fair default? do we even have a default?
    }

    @Override
    public void setInteger(Integer width)
    {
        element.setWidth(width);
    }

    @Override
    public void validateInteger(Integer width)
    {
        if (width < 0)
        {
            throw annotateException("The width cannot be a negative number.");
        }
    }
}
