/*
 * Decompiled with CFR 0.152.
 */
package rex.metadata.resultelements;

import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.metadata.resultelements.Member;
import rex.utils.DOM;
import rex.utils.I18n;
import rex.utils.S;

public class Tuple {
    private Vector members;
    private boolean lastMemberInTuple;

    public Tuple(Node tupleNode, Tuple prevTuple) {
        NodeList ml = tupleNode.getChildNodes();
        this.members = new Vector();
        int memberCount = DOM.getCountOfChildNodesOfType(tupleNode, (short)1);
        if (ml.getLength() > 0) {
            int j = 0;
            for (int i = 0; i < ml.getLength(); ++i) {
                if (ml.item(i).getNodeType() != 1) continue;
                this.lastMemberInTuple = j == memberCount - 1;
                if (prevTuple != null) {
                    this.members.add(new Member(ml.item(i), prevTuple.getMemberAt(j), this.lastMemberInTuple));
                } else {
                    this.members.add(new Member(ml.item(i), this.lastMemberInTuple));
                }
                ++j;
            }
        }
    }

    public Tuple(Vector _members) {
        this.members = _members;
    }

    public int getMemberCount() {
        if (this.members != null) {
            return this.members.size();
        }
        return 0;
    }

    public Member getMemberAt(int i) {
        if (i >= 0 && i <= this.members.size()) {
            return (Member)this.members.elementAt(i);
        }
        S.out("assert: Tuple.getmemberAt(i) - i = " + i + " is out of the array range = 0.." + (this.members.size() - 1));
        return null;
    }

    public Member getMemberByHierarchyName(String hierarchy) {
        for (int i = 0; i <= this.members.size(); ++i) {
            if (!hierarchy.equals(((Member)this.members.elementAt(i)).getHierarchy())) continue;
            return (Member)this.members.elementAt(i);
        }
        return null;
    }

    public boolean equals(Tuple otherTuple) {
        for (int i = 0; i < this.getMemberCount(); ++i) {
            if (otherTuple.getMemberAt(i).equals(this.getMemberAt(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "(";
        for (int i = 0; i < this.getMemberCount(); ++i) {
            s = s + this.getMemberAt(i).getUniqueName() + ", ";
        }
        return s + ")";
    }

    public String getShortCaption() {
        if (this.getMemberCount() > 0) {
            String s = "";
            for (int i = 0; i < this.getMemberCount(); ++i) {
                s = s + this.getMemberAt(i).getCaption() + ", ";
            }
            return s.substring(0, s.length() - 2);
        }
        return I18n.getString("toolTip.noMembers");
    }

    public String getToolTip() {
        if (this.getMemberCount() > 0) {
            String s = "<html>" + I18n.getString("toolTip.tuple");
            for (int i = 0; i < this.getMemberCount(); ++i) {
                s = s + "<hr>" + i + ".member <b>Unique" + I18n.getString("toolTip.name") + "</b>" + this.getMemberAt(i).getUniqueName();
            }
            s = s + "<hr></html>";
            return s;
        }
        return I18n.getString("toolTip.noMembers");
    }
}

