/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.engine.JRPrintElement;

public class CutsInfo {
    public static final int USAGE_NOT_EMPTY = 1;
    public static final int USAGE_SPANNED = 2;
    private final List cuts = new ArrayList();
    private int[] cutUsage;

    public CutsInfo() {
        this.addCut(new Integer(0));
    }

    public CutsInfo(int lastCut) {
        this();
        this.addCut(new Integer(lastCut));
    }

    public List getCuts() {
        return this.cuts;
    }

    public int size() {
        return this.cuts.size();
    }

    public void use() {
        if (this.cutUsage == null) {
            this.cutUsage = new int[this.cuts.size()];
        }
    }

    public int getCut(int index) {
        return (Integer)this.cuts.get(index);
    }

    public void addXCuts(JRPrintElement element, int offset) {
        this.addCut(element.getX() + offset);
        this.addCut(element.getX() + element.getWidth() + offset);
    }

    public void addYCuts(JRPrintElement element, int offset) {
        this.addCut(element.getY() + offset);
        this.addCut(element.getY() + element.getHeight() + offset);
    }

    private boolean addCut(int cut) {
        return this.addCut(new Integer(cut));
    }

    public void addUsage(int index, int usage) {
        int n = index;
        this.cutUsage[n] = this.cutUsage[n] | usage;
    }

    private boolean addCut(Integer cut) {
        int idx = Collections.binarySearch(this.cuts, cut);
        if (idx >= 0) {
            return false;
        }
        this.cuts.add(-idx - 1, cut);
        return true;
    }

    public int indexOfCut(int cut) {
        return this.indexOfCut(new Integer(cut));
    }

    private int indexOfCut(Integer cut) {
        int idx = Collections.binarySearch(this.cuts, cut);
        if (idx < 0) {
            idx = -1;
        }
        return idx;
    }

    public boolean isCutNotEmpty(int index) {
        return (this.cutUsage[index] & 1) > 0;
    }

    public boolean isCutSpanned(int index) {
        return (this.cutUsage[index] & 2) > 0;
    }
}

