/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.charts;

import java.util.LinkedList;
import java.util.List;
import org.jfree.data.DefaultCategoryDataset;
import rex.metadata.CubeSlicer;
import rex.metadata.ExecuteResult;
import rex.metadata.resultelements.Axis;
import rex.utils.S;

public class ExecuteResultToCategoryDatasetBridge
extends DefaultCategoryDataset {
    private ExecuteResult executeResult;
    private CubeSlicer cubeSlicer;
    private Axis rowAxis;
    private Axis columnAxis;

    public ExecuteResultToCategoryDatasetBridge(ExecuteResult _executeResult, CubeSlicer _cubeSlicer) {
        this.executeResult = _executeResult;
        this.cubeSlicer = _cubeSlicer;
        this.rowAxis = this.executeResult.getAxis(this.cubeSlicer.getColAxisName());
        this.columnAxis = this.executeResult.getAxis(this.cubeSlicer.getRowAxisName());
    }

    public String getHorizontalChartCaption() {
        return this.getChartCaption(this.rowAxis);
    }

    public String getVerticalChartCaption() {
        return this.getChartCaption(this.columnAxis);
    }

    private String getChartCaption(Axis axis) {
        StringBuffer rv = new StringBuffer("");
        for (int i = 0; i < axis.getHierarchyInfoCount(); ++i) {
            rv.append(axis.getHierarchyInfoAt(i).getCaption());
            if (i == axis.getHierarchyInfoCount() - 1) continue;
            rv.append(" - ");
        }
        return rv.toString();
    }

    public int getRowCount() {
        return this.rowAxis.getTupleCount();
    }

    public int getColumnCount() {
        return this.columnAxis.getTupleCount();
    }

    public Number getValue(int row, int column) {
        String retVal = this.executeResult.getRowCol(column, row, this.cubeSlicer).getCellValue();
        if (retVal != null && !retVal.equals("")) {
            return new Double(retVal);
        }
        return new Double(0.0);
    }

    public Comparable getRowKey(int row) {
        return this.rowAxis.getTupleAt(row).getShortCaption();
    }

    public int getRowIndex(Comparable key) {
        for (int i = 0; i < this.rowAxis.getTupleCount(); ++i) {
            if (!((String)((Object)key)).equals(this.rowAxis.getTupleAt(i).getShortCaption())) continue;
            return i;
        }
        return -1;
    }

    public List getRowKeys() {
        LinkedList<String> retVal = new LinkedList<String>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            retVal.add(this.rowAxis.getTupleAt(i).getShortCaption());
        }
        return retVal;
    }

    public Comparable getColumnKey(int column) {
        return this.columnAxis.getTupleAt(column).getShortCaption();
    }

    public int getColumnIndex(Comparable key) {
        for (int i = 0; i < this.columnAxis.getTupleCount(); ++i) {
            if (!((String)((Object)key)).equals(this.columnAxis.getTupleAt(i).getShortCaption())) continue;
            return i;
        }
        return -1;
    }

    public List getColumnKeys() {
        LinkedList<String> retVal = new LinkedList<String>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            retVal.add(this.columnAxis.getTupleAt(i).getShortCaption());
        }
        return retVal;
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        S.out("getValue zajebani called");
        return this.getValue(this.getRowIndex(rowKey), this.getColumnIndex(columnKey));
    }
}

