/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.merge.builtin.visualizer;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.merge.builtin.visualizer.MergePanel;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class MergeControl
implements ActionListener,
VetoableChangeListener {
    private Color colorUnresolvedConflict;
    private Color colorResolvedConflict;
    private Color colorOtherConflict;
    private MergePanel panel;
    private Difference[] diffs;
    private int[][] diffShifts;
    private int currentDiffLine = 0;
    private int[] resultDiffLocations;
    private Set<Difference> resolvedConflicts = new HashSet<Difference>();
    private StreamSource resultSource;
    private boolean firstNewlineIsFake;
    private boolean secondNewlineIsFake;

    public MergeControl(MergePanel mergePanel) {
        this.panel = mergePanel;
    }

    public void initialize(Difference[] differenceArray, StreamSource streamSource, StreamSource streamSource2, StreamSource streamSource3, Color color, Color color2, Color color3) {
        if (differenceArray.length > 0) {
            Difference difference = differenceArray[differenceArray.length - 1];
            if (!difference.getFirstText().endsWith("\n")) {
                this.firstNewlineIsFake = true;
            }
            if (!difference.getSecondText().endsWith("\n")) {
                this.secondNewlineIsFake = true;
            }
            if (this.firstNewlineIsFake || this.secondNewlineIsFake) {
                differenceArray[differenceArray.length - 1] = new Difference(difference.getType(), difference.getFirstStart(), difference.getFirstEnd(), difference.getSecondStart(), difference.getSecondEnd(), difference.getFirstText() + (this.firstNewlineIsFake ? "\n" : ""), difference.getSecondText() + (this.secondNewlineIsFake ? "\n" : ""));
            }
        }
        this.diffs = differenceArray;
        this.diffShifts = new int[differenceArray.length][2];
        this.resultDiffLocations = new int[differenceArray.length];
        this.panel.setMimeType1(streamSource.getMIMEType());
        this.panel.setMimeType2(streamSource2.getMIMEType());
        this.panel.setMimeType3(streamSource3.getMIMEType());
        this.panel.setSource1Title(streamSource.getTitle());
        this.panel.setSource2Title(streamSource2.getTitle());
        this.panel.setResultSourceTitle(streamSource3.getTitle());
        this.panel.setName(streamSource.getName());
        try {
            this.panel.setSource1(streamSource.createReader());
            this.panel.setSource2(streamSource2.createReader());
            this.panel.setResultSource(new StringReader(""));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        this.colorUnresolvedConflict = color;
        this.colorResolvedConflict = color2;
        this.colorOtherConflict = color3;
        this.insertEmptyLines(true);
        this.setDiffHighlight(true);
        this.copyToResult();
        this.panel.setNumConflicts(differenceArray.length);
        this.panel.addControlActionListener(this);
        this.showCurrentLine();
        this.resultSource = streamSource3;
    }

    private void insertEmptyLines(boolean bl) {
        int n = this.diffs.length;
        block5: for (int i = 0; i < n; ++i) {
            Difference difference = this.diffs[i];
            int n2 = difference.getFirstStart() + this.diffShifts[i][0];
            int n3 = difference.getFirstEnd() + this.diffShifts[i][0];
            int n4 = difference.getSecondStart() + this.diffShifts[i][1];
            int n5 = difference.getSecondEnd() + this.diffShifts[i][1];
            if (bl && i < n - 1) {
                this.diffShifts[i + 1][0] = this.diffShifts[i][0];
                this.diffShifts[i + 1][1] = this.diffShifts[i][1];
            }
            switch (difference.getType()) {
                case 0: {
                    this.panel.addEmptyLines2(n4, n3 - n2 + 1);
                    if (!bl || i >= n - 1) continue block5;
                    int[] nArray = this.diffShifts[i + 1];
                    nArray[1] = nArray[1] + (n3 - n2 + 1);
                    continue block5;
                }
                case 1: {
                    this.panel.addEmptyLines1(n2, n5 - n4 + 1);
                    if (!bl || i >= n - 1) continue block5;
                    int[] nArray = this.diffShifts[i + 1];
                    nArray[0] = nArray[0] + (n5 - n4 + 1);
                    continue block5;
                }
                case 2: {
                    int n6 = n3 - n2;
                    int n7 = n5 - n4;
                    if (n6 < n7) {
                        this.panel.addEmptyLines1(n3, n7 - n6);
                        if (!bl || i >= n - 1) continue block5;
                        int[] nArray = this.diffShifts[i + 1];
                        nArray[0] = nArray[0] + (n7 - n6);
                        continue block5;
                    }
                    if (n6 <= n7) continue block5;
                    this.panel.addEmptyLines2(n5, n6 - n7);
                    if (!bl || i >= n - 1) continue block5;
                    int[] nArray = this.diffShifts[i + 1];
                    nArray[1] = nArray[1] + (n6 - n7);
                }
            }
        }
    }

    private void setDiffHighlight(boolean bl) {
        int n = this.diffs.length;
        block5: for (int i = 0; i < n; ++i) {
            Difference difference = this.diffs[i];
            int n2 = difference.getFirstStart() + this.diffShifts[i][0];
            int n3 = difference.getFirstEnd() + this.diffShifts[i][0];
            int n4 = difference.getSecondStart() + this.diffShifts[i][1];
            int n5 = difference.getSecondEnd() + this.diffShifts[i][1];
            switch (difference.getType()) {
                case 0: {
                    if (bl) {
                        this.panel.highlightRegion1(n2, n3, this.colorUnresolvedConflict);
                        continue block5;
                    }
                    this.panel.highlightRegion1(n2, n3, Color.white);
                    continue block5;
                }
                case 1: {
                    if (bl) {
                        this.panel.highlightRegion2(n4, n5, this.colorUnresolvedConflict);
                        continue block5;
                    }
                    this.panel.highlightRegion2(n4, n5, Color.white);
                    continue block5;
                }
                case 2: {
                    if (bl) {
                        this.panel.highlightRegion1(n2, n3, this.colorUnresolvedConflict);
                        this.panel.highlightRegion2(n4, n5, this.colorUnresolvedConflict);
                        continue block5;
                    }
                    this.panel.highlightRegion1(n2, n3, Color.white);
                    this.panel.highlightRegion2(n4, n5, Color.white);
                }
            }
        }
    }

    private void copyToResult() {
        int n = this.diffs.length;
        int n2 = 1;
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            int n4;
            Difference difference = this.diffs[i];
            int n5 = difference.getFirstStart() + this.diffShifts[i][0];
            int n6 = difference.getFirstEnd() + this.diffShifts[i][0];
            int n7 = difference.getSecondStart() + this.diffShifts[i][1];
            int n8 = difference.getSecondEnd() + this.diffShifts[i][1];
            int n9 = n4 = difference.getType() != 1 ? n5 - 1 : n5;
            if (n4 >= n2) {
                this.panel.copySource1ToResult(n2, n4, n3);
                n3 += n4 + 1 - n2;
            }
            int n10 = Math.max(n6 - n5, n8 - n7);
            this.panel.addEmptyLines3(n3, n10 + 1);
            this.panel.highlightRegion3(n3, n3 + n10, this.colorUnresolvedConflict);
            this.resultDiffLocations[i] = n3;
            n3 += n10 + 1;
            n2 = Math.max(n6, n8) + 1;
        }
        this.panel.copySource1ToResult(n2, -1, n3);
    }

    private void showCurrentLine() {
        Difference difference = this.diffs[this.currentDiffLine];
        int n = difference.getFirstStart() + this.diffShifts[this.currentDiffLine][0];
        if (difference.getType() == 1) {
            ++n;
        }
        int n2 = difference.getFirstEnd() - difference.getFirstStart() + 1;
        int n3 = difference.getSecondEnd() - difference.getSecondStart() + 1;
        int n4 = Math.max(n2, n3);
        this.panel.setCurrentLine(n, n4, this.currentDiffLine, this.resultDiffLocations[this.currentDiffLine]);
    }

    private void doResolveConflict(boolean bl, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Difference difference = this.diffs[n];
        int[] nArray = this.diffShifts[n];
        if (difference.getType() == 1) {
            n6 = difference.getFirstStart() + nArray[0] + 1;
            n5 = n6 - 1;
        } else {
            n6 = difference.getFirstStart() + nArray[0];
            n5 = difference.getFirstEnd() + nArray[0];
        }
        if (difference.getType() == 0) {
            n4 = difference.getSecondStart() + nArray[1] + 1;
            n3 = n4 - 1;
        } else {
            n4 = difference.getSecondStart() + nArray[1];
            n3 = difference.getSecondEnd() + nArray[1];
        }
        int n7 = this.resolvedConflicts.contains(difference) ? (bl ? n5 - n6 : n3 - n4) : Math.max(n5 - n6, n3 - n4);
        if (bl) {
            this.panel.replaceSource2InResult(n4, Math.max(n3, 0), this.resultDiffLocations[n], this.resultDiffLocations[n] + n7);
            n2 = n7 - (n3 - n4);
            this.panel.highlightRegion1(n6, Math.max(n5, 0), this.colorOtherConflict);
            this.panel.highlightRegion2(n4, Math.max(n3, 0), this.colorResolvedConflict);
        } else {
            this.panel.replaceSource1InResult(n6, Math.max(n5, 0), this.resultDiffLocations[n], this.resultDiffLocations[n] + n7);
            n2 = n7 - (n5 - n6);
            this.panel.highlightRegion1(n6, Math.max(n5, 0), this.colorResolvedConflict);
            this.panel.highlightRegion2(n4, Math.max(n3, 0), this.colorOtherConflict);
        }
        if (bl && n3 >= n4 || !bl && n5 >= n6) {
            this.panel.highlightRegion3(this.resultDiffLocations[n], this.resultDiffLocations[n] + n7 - n2, this.colorResolvedConflict);
        } else {
            this.panel.unhighlightRegion3(this.resultDiffLocations[n], this.resultDiffLocations[n]);
        }
        int n8 = n + 1;
        while (n8 < this.diffs.length) {
            int n9 = n8++;
            this.resultDiffLocations[n9] = this.resultDiffLocations[n9] - n2;
        }
        this.resolvedConflicts.add(difference);
        this.panel.setNeedsSaveState(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("firstConflict".equals(string)) {
            this.currentDiffLine = 0;
            this.showCurrentLine();
        } else if ("lastConflict".equals(string)) {
            this.currentDiffLine = this.diffs.length - 1;
            this.showCurrentLine();
        } else if ("previousConflict".equals(string)) {
            --this.currentDiffLine;
            if (this.currentDiffLine < 0) {
                this.currentDiffLine = this.diffs.length - 1;
            }
            this.showCurrentLine();
        } else if ("nextConflict".equals(string)) {
            ++this.currentDiffLine;
            if (this.currentDiffLine >= this.diffs.length) {
                this.currentDiffLine = 0;
            }
            this.showCurrentLine();
        } else if ("acceptRight".equals(string)) {
            this.doResolveConflict(true, this.currentDiffLine);
        } else if ("acceptLeft".equals(string)) {
            this.doResolveConflict(false, this.currentDiffLine);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        MergePanel mergePanel;
        if ("panelSave".equals(propertyChangeEvent.getPropertyName()) && this.panel == (mergePanel = (MergePanel)propertyChangeEvent.getNewValue())) {
            ArrayList<Difference> arrayList = new ArrayList<Difference>();
            int n = 0;
            for (int i = 0; i < this.diffs.length; ++i) {
                if (this.resolvedConflicts.contains(this.diffs[i])) continue;
                int n2 = this.resultDiffLocations[i] - n;
                Difference difference = new Difference(this.diffs[i].getType(), n2, n2 + this.diffs[i].getFirstEnd() - this.diffs[i].getFirstStart(), n2, n2 + this.diffs[i].getSecondEnd() - this.diffs[i].getSecondStart(), this.diffs[i].getFirstText(), this.diffs[i].getSecondText());
                arrayList.add(difference);
                n += Math.max(this.diffs[i].getFirstEnd() - this.diffs[i].getFirstStart() + 1, this.diffs[i].getSecondEnd() - this.diffs[i].getSecondStart() + 1);
            }
            try {
                mergePanel.writeResult(this.resultSource.createWriter(arrayList.toArray(new Difference[arrayList.size()])), this.firstNewlineIsFake | this.secondNewlineIsFake);
                mergePanel.setNeedsSaveState(false);
            }
            catch (IOException iOException) {
                PropertyVetoException propertyVetoException = new PropertyVetoException(NbBundle.getMessage(MergeControl.class, (String)"MergeControl.failedToSave", (Object)iOException.getLocalizedMessage()), propertyChangeEvent);
                propertyVetoException.initCause(iOException);
                throw propertyVetoException;
            }
        }
        if ("panelClosing".equals(propertyChangeEvent.getPropertyName()) && this.panel == (mergePanel = (MergePanel)propertyChangeEvent.getNewValue())) {
            this.resultSource.close();
        }
        if ("allPanelsClosed".equals(propertyChangeEvent.getPropertyName()) || "allPanelsCancelled".equals(propertyChangeEvent.getPropertyName())) {
            this.resultSource.close();
        }
    }
}

