/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.CloneDocumentAction;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ResetWindowsAction
extends AbstractAction {
    public ResetWindowsAction() {
        this.putValue("Name", NbBundle.getMessage(CloneDocumentAction.class, (String)"CTL_ResetWindows"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final NbTopManager.WindowSystem windowSystem = (NbTopManager.WindowSystem)Lookup.getDefault().lookup(NbTopManager.WindowSystem.class);
        if (null == windowSystem) {
            return;
        }
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        if (windowManagerImpl.getMainWindow() instanceof MainWindow) {
            ((MainWindow)windowManagerImpl.getMainWindow()).setFullScreenMode(false);
        }
        windowManagerImpl.getMainWindow().setExtendedState(0);
        final TopComponent[] topComponentArray = windowManagerImpl.getEditorTopComponents();
        windowManagerImpl.closeNonEditorViews();
        windowManagerImpl.getMainWindow().setVisible(false);
        final TopComponent topComponent = windowManagerImpl.getArbitrarySelectedEditorTopComponent();
        windowManagerImpl.deselectEditorTopComponents();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
                FileObject fileObject = fileSystem.getRoot().getFileObject("Windows2Local");
                if (null != fileObject) {
                    try {
                        for (FileObject fileObject2 : fileObject.getChildren()) {
                            if ("Components".equals(fileObject2.getName())) continue;
                            fileObject2.delete();
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
                windowSystem.hide();
                WindowManagerImpl.getInstance().resetModel();
                PersistenceManager.getDefault().reset();
                PersistenceHandler.getDefault().clear();
                windowSystem.load();
                windowSystem.show();
                for (int i = 0; i < topComponentArray.length; ++i) {
                    topComponentArray[i].open();
                }
                if (null != topComponent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            topComponent.requestActive();
                        }
                    });
                }
            }
        });
    }
}

