/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.eigenbase.xom.AssertFailure;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.XOMException;

public class DOMElementParser {
    private DOMWrapper wrapper;
    private DOMWrapper[] children;
    private int currentIndex;
    private DOMWrapper currentChild;
    private int optionIndex;
    private String prefix;
    private Class enclosure;
    static /* synthetic */ Class class$java$lang$Class;

    public DOMElementParser(DOMWrapper dOMWrapper, String string, Class clazz) throws XOMException {
        this.wrapper = dOMWrapper;
        this.children = dOMWrapper.getElementChildren();
        this.currentIndex = 0;
        this.currentChild = null;
        this.getNextElement();
        this.prefix = string;
        if (string == null) {
            this.prefix = "";
        }
        this.enclosure = clazz;
    }

    private void getNextElement() {
        this.currentChild = this.currentIndex >= this.children.length ? null : this.children[this.currentIndex++];
    }

    private void requiredName(String string) throws XOMException {
        String string2 = this.prefix + string;
        if (this.currentChild == null) {
            throw new XOMException("Expected <" + string2 + "> but found " + "nothing.");
        }
        if (!string2.equalsIgnoreCase(this.currentChild.getTagName())) {
            throw new XOMException("Expected <" + string2 + "> but found <" + this.currentChild.getTagName() + ">");
        }
    }

    private boolean optionalName(String string) {
        String string2 = this.prefix + string;
        if (this.currentChild == null) {
            return false;
        }
        return string2.equalsIgnoreCase(this.currentChild.getTagName());
    }

    private Class getEnclosureClass(Class clazz) {
        Class<?> clazz2 = this.enclosure;
        String string = clazz.getName();
        int n = string.indexOf(36);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            try {
                clazz2 = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertFailure("Enclosure class " + string2 + " not found.");
            }
        }
        return clazz2;
    }

    private boolean nameMatchesClass(Class clazz) throws XOMException {
        Class clazz2 = this.getEnclosureClass(clazz);
        Class clazz3 = ElementDef.getElementClass(this.currentChild, clazz2, this.prefix);
        return clazz3 != null && clazz.isAssignableFrom(clazz3);
    }

    public String requiredString(String string) throws XOMException {
        this.requiredName(string);
        String string2 = this.currentChild.getText().trim();
        this.getNextElement();
        return string2;
    }

    public String optionalString(String string) throws XOMException {
        if (this.optionalName(string)) {
            String string2 = this.currentChild.getText().trim();
            this.getNextElement();
            return string2;
        }
        return null;
    }

    public DOMWrapper requiredElement(String string) throws XOMException {
        this.requiredName(string);
        DOMWrapper dOMWrapper = this.currentChild;
        this.getNextElement();
        return dOMWrapper;
    }

    public String getText() {
        return this.wrapper.getText().trim();
    }

    public DOMWrapper optionalElement(String string) throws XOMException {
        if (this.optionalName(string)) {
            DOMWrapper dOMWrapper = this.currentChild;
            this.getNextElement();
            return dOMWrapper;
        }
        return null;
    }

    private String formatOption(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("<DM" + this.prefix);
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(">");
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(" or ");
        }
        return stringBuffer.toString();
    }

    public DOMWrapper requiredOption(String[] stringArray) throws XOMException {
        if (this.currentChild == null) {
            throw new XOMException("Expecting " + this.formatOption(stringArray) + " but found nothing.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "DM" + stringArray[i];
            if (!string.equalsIgnoreCase(this.currentChild.getTagName().toString())) continue;
            DOMWrapper dOMWrapper = this.currentChild;
            this.getNextElement();
            this.optionIndex = i;
            return dOMWrapper;
        }
        throw new XOMException("Expecting " + this.formatOption(stringArray) + " but found <" + this.currentChild.getTagName() + ">.");
    }

    public NodeDef requiredClass(Class clazz) throws XOMException {
        if (!this.nameMatchesClass(clazz)) {
            throw new XOMException("element <" + this.currentChild.getTagName() + "> does not match expected class " + clazz.getName());
        }
        Class clazz2 = ElementDef.getElementClass(this.currentChild, this.enclosure, this.prefix);
        DOMWrapper dOMWrapper = this.currentChild;
        this.getNextElement();
        return ElementDef.constructElement(dOMWrapper, clazz2);
    }

    public int lastOptionIndex() {
        return this.optionIndex;
    }

    public String requiredAttribute(String string) throws XOMException {
        String string2 = this.wrapper.getAttribute(string);
        if (string2 == null) {
            throw new XOMException("Required attribute '" + string + "' is not set.");
        }
        return string2.toString();
    }

    public static String requiredDefAttribute(DOMWrapper dOMWrapper, String string, String string2) throws XOMException {
        String string3 = dOMWrapper.getAttribute(string);
        if (string3 == null) {
            if (string2 == null) {
                throw new XOMException("Required attribute " + string + " is not set.");
            }
            return string2;
        }
        return string3.toString();
    }

    public String optionalAttribute(String string) throws XOMException {
        String string2 = this.wrapper.getAttribute(string);
        if (string2 == null) {
            return null;
        }
        return string2.toString();
    }

    public Integer optionalIntegerAttribute(String string) throws XOMException {
        String string2 = this.wrapper.getAttribute(string);
        if (string2 == null) {
            return null;
        }
        try {
            return new Integer(string2.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new XOMException("Illegal integer value \"" + string2.toString() + "\" for attribute " + string + ": " + numberFormatException.getMessage());
        }
    }

    public Double optionalDoubleAttribute(String string) throws XOMException {
        String string2 = this.wrapper.getAttribute(string);
        if (string2 == null) {
            return null;
        }
        try {
            return new Double(string2.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new XOMException("Illegal double value \"" + string2.toString() + "\" for attribute " + string + ": " + numberFormatException.getMessage());
        }
    }

    public Integer requiredIntegerAttribute(String string) throws XOMException {
        String string2 = this.wrapper.getAttribute(string);
        if (string2 == null) {
            throw new XOMException("Required integer attribute " + string + " is not set.");
        }
        try {
            return new Integer(string2.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new XOMException("Illegal integer value \"" + string2.toString() + "\" for attribute " + string + ": " + numberFormatException.getMessage());
        }
    }

    public Boolean optionalBooleanAttribute(String string) throws XOMException {
        String string2 = this.wrapper.getAttribute(string);
        if (string2 == null) {
            return null;
        }
        return new Boolean(string2.toString());
    }

    public Boolean requiredBooleanAttribute(String string) throws XOMException {
        String string2 = this.wrapper.getAttribute(string);
        if (string2 == null) {
            throw new XOMException("Required boolean attribute " + string + " is not set.");
        }
        return new Boolean(string2.toString());
    }

    public DOMWrapper[] optionalArray(String string, int n, int n2) throws XOMException {
        Vector<DOMWrapper> vector = new Vector<DOMWrapper>();
        String string2 = "DM" + string;
        while (this.currentChild != null && string2.equalsIgnoreCase(this.currentChild.getTagName())) {
            vector.addElement(this.currentChild);
            this.getNextElement();
        }
        if (n > 0 && vector.size() < n) {
            throw new XOMException("Expecting at least " + n + " <" + string + "> but found " + vector.size());
        }
        if (n2 > 0 && vector.size() > n2) {
            throw new XOMException("Expecting at most " + n2 + " <" + string + "> but found " + vector.size());
        }
        DOMWrapper[] dOMWrapperArray = new DOMWrapper[vector.size()];
        for (int i = 0; i < dOMWrapperArray.length; ++i) {
            dOMWrapperArray[i] = (DOMWrapper)vector.elementAt(i);
        }
        return dOMWrapperArray;
    }

    public NodeDef[] classArray(Class clazz, int n, int n2) throws XOMException {
        Class clazz2 = this.getEnclosureClass(clazz);
        Vector<DOMWrapper> vector = new Vector<DOMWrapper>();
        while (this.currentChild != null && this.nameMatchesClass(clazz)) {
            vector.addElement(this.currentChild);
            this.getNextElement();
        }
        if (n > 0 && vector.size() < n) {
            throw new XOMException("Expecting at least " + n + " <" + clazz.getName() + "> but found " + vector.size());
        }
        if (n2 > 0 && vector.size() > n2) {
            throw new XOMException("Expecting at most " + n2 + " <" + clazz.getName() + "> but found " + vector.size());
        }
        NodeDef[] nodeDefArray = new NodeDef[vector.size()];
        for (int i = 0; i < nodeDefArray.length; ++i) {
            nodeDefArray[i] = ElementDef.constructElement((DOMWrapper)vector.elementAt(i), clazz2, this.prefix);
        }
        return nodeDefArray;
    }

    public NodeDef getElement(Class clazz, boolean bl) throws XOMException {
        if (this.currentChild == null) {
            return null;
        }
        if (!this.nameMatchesClass(clazz)) {
            if (bl) {
                throw new XOMException("element <" + this.currentChild.getTagName() + "> is not of expected type " + clazz.getName());
            }
            return null;
        }
        Class clazz2 = this.getEnclosureClass(clazz);
        Class clazz3 = ElementDef.getElementClass(this.currentChild, clazz2, this.prefix);
        DOMWrapper dOMWrapper = this.currentChild;
        this.getNextElement();
        return ElementDef.constructElement(dOMWrapper, clazz3);
    }

    public NodeDef[] getArray(Class clazz, int n, int n2) throws XOMException {
        return this.classArray(clazz, n, n2);
    }

    public String getString(String string, boolean bl) throws XOMException {
        boolean bl2;
        if (bl) {
            this.requiredName(string);
            bl2 = true;
        } else {
            bl2 = this.optionalName(string);
        }
        if (bl2) {
            String string2 = this.currentChild.getText().trim();
            this.getNextElement();
            return string2;
        }
        return null;
    }

    public String[] getStringArray(String string, int n, int n2) throws XOMException {
        Vector<DOMWrapper> vector = new Vector<DOMWrapper>();
        String string2 = this.prefix + string;
        while (this.currentChild != null && string2.equalsIgnoreCase(this.currentChild.getTagName().toString())) {
            vector.addElement(this.currentChild);
            this.getNextElement();
        }
        if (n > 0 && vector.size() < n) {
            throw new XOMException("Expecting at least " + n + " <" + string + "> but found " + vector.size());
        }
        if (n2 > 0 && vector.size() > n2) {
            throw new XOMException("Expecting at most " + n2 + " <" + string + "> but found " + vector.size());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((DOMWrapper)vector.elementAt(i)).getText().trim();
        }
        return stringArray;
    }

    private boolean stringInArray(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private String arrayToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static Class getPluginClass(String string, String string2) throws XOMException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string + "." + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XOMException("Unable to locate plugin class " + string + "." + string2 + ": " + classNotFoundException.getMessage());
        }
        return DOMElementParser.getPluginClass(clazz);
    }

    public static Class getPluginClass(Class clazz) throws XOMException {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getParameterTypes().length != 0 || methodArray[i].getReturnType() != (class$java$lang$Class == null ? DOMElementParser.class$("java.lang.Class") : class$java$lang$Class) || !Modifier.isStatic(methodArray[i].getModifiers())) continue;
            try {
                Object[] objectArray = new Object[]{};
                return (Class)methodArray[i].invoke(null, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new XOMException("Exception while retrieving plugin class: " + invocationTargetException.getTargetException().toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XOMException("Illegal access while retrieving plugin class: " + illegalAccessException.getMessage());
            }
        }
        throw new XOMException("Plugin class " + clazz.getName() + " is not an appropriate plugin class; " + "getXMLDefClass() is not defined.");
    }

    public Object getAttribute(String string, String string2, String string3, String[] stringArray, boolean bl) throws XOMException {
        if (string2.indexOf(46) == -1) {
            string2 = "java.lang." + string2;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XOMException("Class could not be found for attribute type: " + string2 + ": " + classNotFoundException.getMessage());
        }
        Class[] classArray = new Class[]{String.class};
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new XOMException("Attribute type class " + string2 + " does not have a " + "constructor which takes a String: " + noSuchMethodException.getMessage());
        }
        String string4 = this.wrapper.getAttribute(string);
        if (string4 == null) {
            string4 = string3;
        }
        if (string4 == null) {
            if (bl) {
                throw new XOMException("Attribute '" + string + "' is unset and has no default value.");
            }
            return null;
        }
        if (stringArray != null && !this.stringInArray(string4.toString(), stringArray)) {
            throw new XOMException("Value '" + string4.toString() + "' of attribute '" + string + "' has illegal value '" + string4 + "'.  Legal values: " + this.arrayToString(stringArray));
        }
        Object[] objectArray = new Object[]{string4.toString()};
        try {
            return constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new XOMException("Unable to construct a " + string2 + " from value \"" + string4 + "\": " + instantiationException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XOMException("Unable to construct a " + string2 + " from value \"" + string4 + "\": " + invocationTargetException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XOMException("Unable to construct a " + string2 + " from value \"" + string4 + "\": " + illegalAccessException.getMessage());
        }
    }
}

