/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

public class QueryBuilderSqlTextArea
extends JEditorPane
implements ActionListener,
KeyListener {
    public static final boolean SYNTAX_HIGHLIGHT = true;
    String _lastGoodQuery = null;
    private boolean DEBUG = false;
    private QueryBuilder _queryBuilder;
    private JMenuItem runQueryMenuItem;
    private JMenuItem parseQueryMenuItem;
    private SimpleAttributeSet keyword = new SimpleAttributeSet();
    private SimpleAttributeSet schema = new SimpleAttributeSet();
    private SimpleAttributeSet column = new SimpleAttributeSet();
    private static ArrayList keywords = null;
    private static final String[] sqlReservedWords = new String[]{"ABSOLUTE", "ACTION", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHAR_LENGTH", "CHARACTER_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"};

    public QueryBuilderSqlTextArea(QueryBuilder queryBuilder) {
        this._queryBuilder = queryBuilder;
        this.createSqlTextPopup();
        this.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-sql"));
        this.addKeyListener(this);
        StyleConstants.setForeground(this.keyword, new Color(0, 0, 153));
        StyleConstants.setForeground(this.schema, new Color(0, 111, 0));
        StyleConstants.setForeground(this.column, new Color(120, 0, 0));
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    void createSqlTextPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.parseQueryMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderSqlTextArea.class, (String)"PARSE_QUERY"));
        this.parseQueryMenuItem.addActionListener(this);
        jPopupMenu.add(this.parseQueryMenuItem);
        this.runQueryMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderSqlTextArea.class, (String)"RUN_QUERY"));
        this.runQueryMenuItem.addActionListener(this);
        jPopupMenu.add(this.runQueryMenuItem);
        sqlTextListener sqlTextListener2 = new sqlTextListener(jPopupMenu);
        super.addMouseListener(sqlTextListener2);
    }

    public void setParseQueryMenuEnabled(boolean bl) {
        this.parseQueryMenuItem.setEnabled(bl);
    }

    public void setRunQueryMenuEnabled(boolean bl) {
        this.runQueryMenuItem.setEnabled(bl);
    }

    public boolean queryChanged() {
        return !this.getText().equals(this._lastGoodQuery);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem.getText().equals(NbBundle.getMessage(QueryBuilder.class, (String)"PARSE_QUERY"))) {
            String string = this.getText();
            if (string != null && string.trim().length() != 0) {
                QueryBuilder.showBusyCursor(true);
                this._queryBuilder.populate(string, true);
                QueryBuilder.showBusyCursor(false);
            }
        } else if (jMenuItem.getText().equals(NbBundle.getMessage(QueryBuilder.class, (String)"RUN_QUERY"))) {
            String string = this.getText();
            if (string != null && string.trim().length() != 0) {
                if (!string.trim().equals(this._lastGoodQuery)) {
                    QueryBuilder.showBusyCursor(true);
                    this._queryBuilder.populate(this.getText(), true);
                    QueryBuilder.showBusyCursor(false);
                }
            } else {
                return;
            }
            this._queryBuilder.executeQuery(this.getText());
        }
    }

    public void setText(String string) {
        if (this.DEBUG) {
            System.out.println("setQueryText called with " + string + "\n");
        }
        String string2 = string.trim();
        super.setText(string2);
        if (!string2.equals(this._lastGoodQuery)) {
            this._lastGoodQuery = string2;
        }
    }

    public void restoreLastGoodQuery() {
        super.setText(this._lastGoodQuery);
    }

    public void saveLastGoodQuery() {
        this._lastGoodQuery = this.getText();
    }

    void clear() {
        this.setText("");
    }

    static {
        keywords = new ArrayList();
        for (int i = 0; i < sqlReservedWords.length; ++i) {
            keywords.add(sqlReservedWords[i]);
        }
    }

    class sqlTextListener
    extends MouseAdapter {
        JPopupMenu popup;

        sqlTextListener(JPopupMenu jPopupMenu) {
            this.popup = jPopupMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mousePressed(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (((JEditorPane)mouseEvent.getComponent()).getText().trim().length() != 0) {
                    QueryBuilderSqlTextArea.this.parseQueryMenuItem.setEnabled(true);
                    QueryBuilderSqlTextArea.this.runQueryMenuItem.setEnabled(true);
                } else {
                    QueryBuilderSqlTextArea.this.parseQueryMenuItem.setEnabled(false);
                    QueryBuilderSqlTextArea.this.runQueryMenuItem.setEnabled(false);
                }
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

