/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.util.Map;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.convert.ElementConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRTextMeasurerUtil;

public abstract class TextElementConverter
extends ElementConverter {
    private final JRStyledTextParser styledTextParser = new JRStyledTextParser();

    protected void copyTextElement(ReportConverter reportConverter, JRTextElement textElement, JRBasePrintText printText) {
        this.copyElement(reportConverter, textElement, printText);
        printText.copyBox(textElement.getLineBox());
        printText.setBold(textElement.isOwnBold());
        printText.setFontName(textElement.getOwnFontName());
        printText.setFontSize(textElement.getOwnFontSize());
        printText.setHorizontalAlignment(textElement.getOwnHorizontalAlignment());
        printText.setItalic(textElement.isOwnItalic());
        printText.setLineSpacing(textElement.getOwnLineSpacing());
        printText.setPdfEmbedded(textElement.isOwnPdfEmbedded());
        printText.setPdfEncoding(textElement.getOwnPdfEncoding());
        printText.setPdfFontName(textElement.getOwnPdfFontName());
        printText.setReportFont(textElement.getReportFont());
        printText.setRotation(textElement.getOwnRotation());
        printText.setStrikeThrough(textElement.isOwnStrikeThrough());
        printText.setStyledText(textElement.isOwnStyledText());
        printText.setUnderline(textElement.isOwnUnderline());
        printText.setVerticalAlignment(textElement.getOwnVerticalAlignment());
    }

    protected void measureTextElement(JRPrintText printText, String text) {
        Map attributes;
        JRStyledText styledText;
        JRMeasuredText measuredText;
        JRTextMeasurer textMeasurer = JRTextMeasurerUtil.createTextMeasurer(printText);
        if (text == null) {
            text = "";
        }
        printText.setTextHeight((measuredText = textMeasurer.measure(styledText = this.styledTextParser.getStyledText(attributes = JRStyledTextAttributeSelector.NO_BACKCOLOR.getStyledTextAttributes(printText), text, printText.isStyledText()), 0, 0, false)).getTextHeight() < (float)printText.getHeight() ? measuredText.getTextHeight() : (float)printText.getHeight());
        printText.setLeadingOffset(measuredText.getLeadingOffset());
        printText.setLineSpacingFactor(measuredText.getLineSpacingFactor());
        int textEnd = measuredText.getTextOffset();
        String printedText = printText.isStyledText() ? this.styledTextParser.write(styledText, 0, textEnd) : text.substring(0, textEnd);
        printText.setText(printedText);
    }
}

