/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ChicletWrapper;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.openide.awt.HtmlRenderer;

public final class AquaViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int TXT_X_PAD = 5;
    private static final int ICON_X_PAD = 2;
    private static Map<Integer, String[]> buttonIconPaths;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();
    private static final ChicletWrapper chiclet;
    private boolean containsMouse = false;

    private AquaViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(100, 19);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 21 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 3;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        ColorUtil.setupAntialiasing(graphics);
        super.paint(graphics, jComponent);
        this.paintBottomBorder(graphics, jComponent);
    }

    protected Font getTxtFont() {
        return this.getDisplayer().getFont();
    }

    private void paintBottomBorder(Graphics graphics, JComponent jComponent) {
    }

    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        int n6 = n4;
        if (this.isSelected(n)) {
            Component component = this.getControlButtons();
            if (null != component) {
                Dimension dimension = component.getPreferredSize();
                n6 = n4 - (dimension.width + 2 + 10);
                if (n == this.getDataModel().size() - 1) {
                    n6 -= 3;
                }
                component.setLocation(n2 + n6 + 10, n3 + (n5 - dimension.height) / 2);
            }
        } else {
            n6 = n4 - 10;
        }
        if (string.length() == 0) {
            return;
        }
        int n7 = fontMetrics.getHeight();
        int n8 = n2 + 5;
        if (n == 0) {
            n8 = n2 + 5;
        }
        int n9 = n7 > n5 ? -1 * ((n7 - n5) / 2) + fontMetrics.getAscent() - 1 : n5 / 2 - n7 / 2 + fontMetrics.getAscent();
        HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)n8, (int)n9, (int)n6, (int)n5, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)true);
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = n == 0;
        boolean bl2 = n == this.getDataModel().size() - 1;
        int n6 = 0;
        if (this.isActive()) {
            n6 |= 4;
        }
        if (this.isSelected(n)) {
            n6 |= 2;
        }
        if (this.isAttention(n)) {
            n6 |= 0x10;
        }
        chiclet.setState(n6);
        chiclet.setBounds(n2, ++n3, n4, n5);
        chiclet.setArcs(bl ? 0.5f : 0.0f, bl2 ? 0.5f : 0.0f, bl ? 0.0f : 0.0f, bl2 ? 0.0f : 0.0f);
        chiclet.setNotch(false, false);
        graphics.translate(n2, n3);
        chiclet.draw((Graphics2D)graphics);
        graphics.translate(-n2, -n3);
    }

    private void setContainsMouse(boolean bl) {
        if (bl != this.containsMouse) {
            this.containsMouse = bl;
            this.getDisplayer().repaint();
        }
    }

    private boolean isContainsMouse() {
        return this.containsMouse;
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] stringArray;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_bigclose_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_bigclose_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/mac_bigclose_rollover.png"};
            buttonIconPaths.put(1, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_slideright_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/mac_slideright_rollover.png"};
            buttonIconPaths.put(6, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_slideleft_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/mac_slideleft_rollover.png"};
            buttonIconPaths.put(5, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_slidebottom_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/mac_slidebottom_rollover.png"};
            buttonIconPaths.put(7, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/mac_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/mac_pin_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/mac_pin_rollover.png"};
            buttonIconPaths.put(2, stringArray);
        }
    }

    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        AquaViewTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }

    static {
        chiclet = new ChicletWrapper();
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private OwnController() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            AquaViewTabDisplayerUI.this.setContainsMouse(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            AquaViewTabDisplayerUI.this.setContainsMouse(false);
        }
    }
}

