/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import org.openide.nodes.Node;

final class ExplorerDnDManager {
    private static ExplorerDnDManager defaultDnDManager;
    private Node[] draggedNodes;
    private Transferable draggedTransForCut;
    private Transferable draggedTransForCopy;
    private boolean isDnDActive = false;
    private int nodeAllowed = 0;
    private Cursor cursor = null;
    private boolean maybeExternalDnD = false;

    private ExplorerDnDManager() {
    }

    static synchronized ExplorerDnDManager getDefault() {
        if (defaultDnDManager == null) {
            defaultDnDManager = new ExplorerDnDManager();
        }
        return defaultDnDManager;
    }

    void setDraggedNodes(Node[] nodeArray) {
        this.draggedNodes = nodeArray;
    }

    Node[] getDraggedNodes() {
        return this.draggedNodes;
    }

    void setDraggedTransferable(Transferable transferable, boolean bl) {
        if (bl) {
            this.draggedTransForCut = transferable;
        } else {
            this.draggedTransForCopy = transferable;
        }
    }

    Transferable getDraggedTransferable(boolean bl) {
        if (bl) {
            return this.draggedTransForCut;
        }
        return this.draggedTransForCopy;
    }

    void setNodeAllowedActions(int n) {
        this.nodeAllowed = n;
    }

    final int getNodeAllowedActions() {
        if (!this.isDnDActive && this.maybeExternalDnD) {
            return 1;
        }
        return this.nodeAllowed;
    }

    void setDnDActive(boolean bl) {
        this.isDnDActive = bl;
    }

    boolean isDnDActive() {
        return this.isDnDActive || this.maybeExternalDnD;
    }

    int getAdjustedDropAction(int n, int n2) {
        int n3 = n;
        if ((n3 & n2) == 0) {
            n3 = n2;
        }
        if ((n3 & this.getNodeAllowedActions()) == 0) {
            n3 = this.getNodeAllowedActions();
        }
        return n3;
    }

    void setMaybeExternalDragAndDrop(boolean bl) {
        this.maybeExternalDnD = bl;
    }

    void prepareCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    Cursor getCursor() {
        return this.cursor;
    }
}

