/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.FeatureList;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.Rule;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.Parser;
import org.netbeans.modules.languages.parser.StringInput;
import org.netbeans.modules.languages.parser.TokenInputUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Language
extends org.netbeans.api.languages.Language {
    public static final String ACTION = "ACTION";
    public static final String AST = "AST";
    public static final String BRACE = "BRACE";
    public static final String BUNDLE = "BUNDLE";
    public static final String COLOR = "COLOR";
    public static final String COMMENT_LINE = "COMMENT_LINE";
    public static final String COMPLETE = "COMPLETE";
    public static final String COMPLETION = "COMPLETION";
    public static final String FOLD = "FOLD";
    public static final String HYPERLINK = "HYPERLINK";
    public static final String IMPORT = "IMPORT";
    public static final String INDENT = "INDENT";
    public static final String MARK = "MARK";
    public static final String NAVIGATOR = "NAVIGATOR";
    public static final String PARSE = "PARSE";
    public static final String PROPERTIES = "PROPERTIES";
    public static final String REFORMAT = "REFORMAT";
    public static final String SELECTION = "SELECTION";
    public static final String SKIP = "SKIP";
    public static final String STORE = "STORE";
    public static final String TOKEN = "TOKEN";
    public static final String TOOLTIP = "TOOLTIP";
    public static final String ERROR_TOKEN_TYPE_NAME = "error";
    public static final String EMBEDDING_TOKEN_TYPE_NAME = "PE";
    public static final String GAP_TOKEN_TYPE_NAME = "GAP";
    private Parser parser;
    private Map<String, Integer> tokenTypeToID = new HashMap<String, Integer>();
    private Map<Integer, String> idToTokenType;
    private String mimeType;
    private LLSyntaxAnalyser analyser;
    private List<Language> importedLangauges = new ArrayList<Language>();
    private boolean bundleResolved = false;
    private ResourceBundle bundle;
    private Map<String, Integer> ntToNTID;
    private Map<Integer, String> ntidToNt;
    private int tokenTypeCount = 0;
    private Feature preprocessorImport;
    private Map<String, Feature> tokenImports = new HashMap<String, Feature>();
    private FeatureList featureList = new FeatureList();

    public static Language create(String string, Map<Integer, String> map, List<Feature> list, Parser parser) {
        return new Language(string, map, list, parser);
    }

    public static Language create(String string) {
        return new Language(string, Collections.<Integer, String>emptyMap(), Collections.<Feature>emptyList(), null);
    }

    private Language(String string, Map<Integer, String> map, List<Feature> list, Parser parser) {
        this.mimeType = string;
        this.idToTokenType = map;
        for (int n : map.keySet()) {
            this.tokenTypeToID.put(this.idToTokenType.get(n), n);
            this.tokenTypeCount = Math.max(this.tokenTypeCount, n + 1);
        }
        for (Feature feature : list) {
            this.addFeature(feature);
        }
        this.parser = parser;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public Parser getParser() {
        return this.parser;
    }

    public int getTokenID(String string) {
        if (!this.tokenTypeToID.containsKey(string)) {
            System.err.println("unknown token type: " + string);
        }
        return this.tokenTypeToID.get(string);
    }

    public int getTokenTypeCount() {
        return this.tokenTypeCount;
    }

    public String getTokenType(int n) {
        return this.idToTokenType.get(n);
    }

    public LLSyntaxAnalyser getAnalyser() {
        return this.analyser;
    }

    public List<Language> getImportedLanguages() {
        return this.importedLangauges;
    }

    public String localize(String string) {
        if (!this.bundleResolved) {
            String string2;
            Feature feature = this.getFeature(BUNDLE);
            if (feature != null && (string2 = (String)feature.getValue()) != null) {
                try {
                    this.bundle = NbBundle.getBundle((String)string2);
                }
                catch (MissingResourceException missingResourceException) {
                    Utils.notify(missingResourceException);
                }
            }
            this.bundleResolved = true;
        }
        if (string == null) {
            return null;
        }
        if (this.bundle != null) {
            try {
                return this.bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string;
    }

    public int getNTID(String string) {
        if (this.ntidToNt == null) {
            this.ntidToNt = new HashMap<Integer, String>();
        }
        if (this.ntToNTID == null) {
            this.ntToNTID = new HashMap<String, Integer>();
        }
        if (!this.ntToNTID.containsKey(string)) {
            int n = this.ntToNTID.size();
            this.ntToNTID.put(string, n);
            this.ntidToNt.put(n, string);
        }
        return this.ntToNTID.get(string);
    }

    public int getNTCount() {
        if (this.ntToNTID == null) {
            return 0;
        }
        return this.ntToNTID.size();
    }

    public String getNT(int n) {
        return this.ntidToNt.get(n);
    }

    public Feature getPreprocessorImport() {
        return this.preprocessorImport;
    }

    public Map<String, Feature> getTokenImports() {
        return this.tokenImports;
    }

    void importLanguage(Feature feature) {
        String string = (String)feature.getValue("mimeType");
        if (feature.getPattern("start") != null) {
            assert (this.preprocessorImport == null);
            this.preprocessorImport = feature;
            try {
                this.importedLangauges.add(LanguagesManager.getDefault().getLanguage(string));
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                this.importedLangauges.add(Language.create(string));
            }
            return;
        }
        if (feature.getValue("state") == null) {
            String string2 = feature.getSelector().getAsString();
            assert (!this.tokenImports.containsKey(string2));
            this.tokenImports.put(string2, feature);
            try {
                this.importedLangauges.add(LanguagesManager.getDefault().getLanguage(string));
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                this.importedLangauges.add(Language.create(string));
            }
            return;
        }
        try {
            Language language = LanguagesManager.getDefault().getLanguage(string);
            String string3 = (String)feature.getValue("state");
            String string4 = feature.getSelector().getAsString();
            if (language.analyser != null) {
                try {
                    this.analyser = LLSyntaxAnalyser.create(this, language.analyser.getRules(), language.analyser.getSkipTokenTypes());
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
            this.importAllFeatures(language);
            this.importedLangauges.addAll(language.importedLangauges);
            this.tokenImports.putAll(language.tokenImports);
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            Utils.notify("Editors/" + string + "/language.nbs:", languageDefinitionNotFoundException);
        }
    }

    private void importAllFeatures(Language language) {
        this.featureList.importFeatures(language.featureList);
    }

    private void addFeature(Feature feature) {
        if (feature.getFeatureName().equals(IMPORT)) {
            this.importLanguage(feature);
        } else {
            this.featureList.add(feature);
        }
    }

    public List<Feature> getFeatures(String string) {
        return this.featureList.getFeaturesRec(string);
    }

    public Feature getFeature(String string) {
        List<Feature> list = this.getFeatures(string);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<Feature> getFeatures(String string, String string2) {
        return this.featureList.getFeatures(string, string2);
    }

    public Feature getFeature(String string, String string2) {
        List<Feature> list = this.getFeatures(string, string2);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<Feature> getFeatures(String string, int n) {
        String string2 = this.getTokenType(n);
        return this.featureList.getFeatures(string, string2);
    }

    public Feature getFeature(String string, int n) {
        String string2 = this.getTokenType(n);
        List<Feature> list = this.getFeatures(string, string2);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<Feature> getFeatures(String string, ASTPath aSTPath) {
        return this.featureList.getFeatures(string, aSTPath);
    }

    public Feature getFeature(String string, ASTPath aSTPath) {
        List<Feature> list = this.getFeatures(string, aSTPath);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    void evaluate(ParserManager.State state, List<ASTItem> list, Map<String, Set<ASTEvaluator>> map) {
        this.featureList.evaluate(state, list, map);
    }

    @Override
    public ASTNode parse(InputStream inputStream) throws IOException, ParseException {
        ASTNode aSTNode;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuilder.append(string).append('\n');
            string = bufferedReader.readLine();
        }
        TokenInput tokenInput = TokenInputUtils.create(this, this.getParser(), new StringInput(stringBuilder.toString()));
        ASTNode aSTNode2 = this.getAnalyser().read(tokenInput, true, new boolean[]{false});
        Feature feature = this.getFeature(AST);
        if (feature != null && aSTNode2 != null && (aSTNode = (ASTNode)feature.getValue("process", SyntaxContext.create(null, ASTPath.create(aSTNode2)))) != null) {
            aSTNode2 = aSTNode;
        }
        return aSTNode2;
    }

    public void setAnalyser(LLSyntaxAnalyser lLSyntaxAnalyser) {
        this.analyser = lLSyntaxAnalyser;
    }

    void print() {
        System.out.println("\nLanguage " + this.mimeType);
        System.out.println("Tokens:");
        System.out.println("Grammar Rules:");
        for (Rule rule : this.getAnalyser().getRules()) {
            System.out.println("  " + rule);
        }
        System.out.println("Features:");
        System.out.println(this.featureList.toString());
    }

    public String toString() {
        return "Language " + this.mimeType;
    }
}

