/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.mimelookup.impl.ClassInfoStorage;
import org.netbeans.modules.editor.mimelookup.impl.FolderPathLookup;
import org.netbeans.modules.editor.mimelookup.impl.InstanceProviderLookup;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchLookup
extends Lookup {
    private static final Logger LOG = Logger.getLogger(SwitchLookup.class.getName());
    static final String ROOT_FOLDER = "Editors";
    private MimePath mimePath;
    private final String LOCK = new String("SwitchLookup.LOCK");
    private MappingListener listener;
    private Map<String, UpdatableProxyLookup> classLookups = new HashMap<String, UpdatableProxyLookup>();
    private Map<List<String>, Lookup> pathsLookups = new HashMap<List<String>, Lookup>();
    private Map<String, ClassInfoStorage.Info> classInfos = new HashMap<String, ClassInfoStorage.Info>();
    private Map<List<String>, Set<String>> pathsToClasses = new HashMap<List<String>, Set<String>>();

    public SwitchLookup(MimePath mimePath) {
        this.mimePath = mimePath;
        this.listener = new MappingListener();
        ClassInfoStorage.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)ClassInfoStorage.getInstance()));
    }

    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        return this.findLookup(template.getType()).lookup(template);
    }

    public <T> T lookup(Class<T> clazz) {
        return (T)this.findLookup(clazz).lookup(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup findLookup(Class clazz) {
        String string = this.LOCK;
        synchronized (string) {
            String string2 = clazz.getName();
            UpdatableProxyLookup updatableProxyLookup = this.classLookups.get(string2);
            if (updatableProxyLookup == null) {
                ClassInfoStorage.Info info = ClassInfoStorage.getInstance().getInfo(string2);
                this.classInfos.put(string2, info);
                Lookup lookup = this.createLookup(info);
                updatableProxyLookup = new UpdatableProxyLookup(lookup);
                this.classLookups.put(string2, updatableProxyLookup);
            }
            return updatableProxyLookup;
        }
    }

    private Lookup createLookup(ClassInfoStorage.Info info) {
        Lookup lookup;
        List<String> list = SwitchLookup.computePaths(this.mimePath, ROOT_FOLDER, info.getExtraPath());
        if (info.getInstanceProviderClass() != null) {
            lookup = this.getLookupForProvider(list, info.getInstanceProvider());
        } else {
            Set<String> set = this.pathsToClasses.get(list);
            if (set == null) {
                set = new HashSet<String>();
                this.pathsToClasses.put(list, set);
            }
            set.add(info.getClassName());
            lookup = this.getLookupForPaths(list);
        }
        return lookup;
    }

    private Lookup getLookupForPaths(List<String> list) {
        Object object = this.pathsLookups.get(list);
        if (object == null) {
            object = new FolderPathLookup(list.toArray(new String[list.size()]));
            this.pathsLookups.put(list, (Lookup)object);
        }
        return object;
    }

    private Lookup getLookupForProvider(List<String> list, InstanceProvider instanceProvider) {
        return new InstanceProviderLookup(list.toArray(new String[list.size()]), instanceProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildLookup(String string) {
        String string2 = this.LOCK;
        synchronized (string2) {
            Lookup lookup;
            ClassInfoStorage.Info info;
            UpdatableProxyLookup updatableProxyLookup = this.classLookups.get(string);
            if (updatableProxyLookup == null) {
                return;
            }
            ClassInfoStorage.Info info2 = this.classInfos.get(string);
            if (info2.equals(info = ClassInfoStorage.getInstance().getInfo(string))) {
                return;
            }
            if (info2.getInstanceProviderClass() == null) {
                lookup = SwitchLookup.computePaths(this.mimePath, ROOT_FOLDER, info2.getExtraPath());
                Set<String> set = this.pathsToClasses.get(lookup);
                set.remove(string);
                if (set.isEmpty()) {
                    this.pathsToClasses.remove(lookup);
                    this.pathsLookups.remove(lookup);
                }
            }
            this.classInfos.put(string, info);
            lookup = this.createLookup(info);
            updatableProxyLookup.setLookupsEx(lookup);
        }
    }

    private static List<String> computePaths(MimePath mimePath, String string, String string2) {
        try {
            Method method = MimePath.class.getDeclaredMethod("getInheritedPaths", String.class, String.class);
            method.setAccessible(true);
            List list = (List)method.invoke((Object)mimePath, string, string2);
            return list;
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Can't call org.netbeans.api.editor.mimelookup.MimePath.getInheritedPaths method.", exception);
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null && string.length() > 0) {
                stringBuilder.append(string);
            }
            if (mimePath.size() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(mimePath.getPath());
            }
            if (string2 != null && string2.length() > 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append(string2);
            }
            return Collections.singletonList(stringBuilder.toString());
        }
    }

    private final class MappingListener
    implements PropertyChangeListener {
        private MappingListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            for (String string : NbCollections.checkedSetByFilter((Set)((Set)propertyChangeEvent.getNewValue()), String.class, (boolean)true)) {
                SwitchLookup.this.rebuildLookup(string);
            }
        }
    }

    private static final class UpdatableProxyLookup
    extends ProxyLookup {
        public UpdatableProxyLookup() {
        }

        public UpdatableProxyLookup(Lookup ... lookupArray) {
            super(lookupArray);
        }

        public void setLookupsEx(Lookup ... lookupArray) {
            this.setLookups(lookupArray);
        }
    }
}

