/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.designer.templates.DefaultReportGenerator;
import com.jaspersoft.ireport.designer.wizards.ConnectionSelectionWizardPanel;
import com.jaspersoft.ireport.designer.wizards.CustomChooserWizardPanel;
import com.jaspersoft.ireport.designer.wizards.FieldsSelectionWizardPanel;
import com.jaspersoft.ireport.designer.wizards.GroupingWizardPanel;
import com.jaspersoft.ireport.designer.wizards.NewJrxmlWizardPanel6;
import com.jaspersoft.ireport.designer.wizards.TemplateWizardPanel;
import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

public final class NewJrxmlWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            WizardDescriptor.Panel targetChooserPanel = null;
            boolean useCustomChooserPanel = false;
            targetChooserPanel = this.wizard.getProperty("useCustomChooserPanel") != null && this.wizard.getProperty("useCustomChooserPanel").equals("true") ? new CustomChooserWizardPanel(this.wizard) : ((TemplateWizard)this.wizard).targetChooser();
            this.panels = new WizardDescriptor.Panel[]{targetChooserPanel, new ConnectionSelectionWizardPanel(this.wizard), new FieldsSelectionWizardPanel(this.wizard), new GroupingWizardPanel(this.wizard), new TemplateWizardPanel(this.wizard), new NewJrxmlWizardPanel6(this.wizard)};
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        DefaultReportGenerator reportGenerator = new DefaultReportGenerator();
        FileObject createdFile = reportGenerator.generateReport(this.wizard);
        if (createdFile == null) {
            throw new IOException("Unable to create the report.");
        }
        DataObject createdDataObject = DataObject.find((FileObject)createdFile);
        OpenCookie cookie = (OpenCookie)createdDataObject.getCookie(OpenCookie.class);
        cookie.open();
        return Collections.singleton(createdFile);
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] res = new String[this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.panels[i].getComponent().getName();
        }
        return res;
    }
}

