/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.widgets;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.borders.SimpleLineBorder;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.draw.DrawVisitor;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class JRDesignElementWidget
extends Widget
implements PropertyChangeListener {
    private SelectionWidget selectionWidget = null;
    private boolean changing = false;
    JRDesignElement element = null;

    public JRDesignElement getElement() {
        return this.element;
    }

    public void setElement(JRDesignElement element) {
        this.element = element;
    }

    public JRDesignElementWidget(ReportObjectScene scene, JRDesignElement element) {
        super((Scene)scene);
        this.element = element;
        this.setBorder(new SimpleLineBorder());
        this.updateBounds();
        this.selectionWidget = new SelectionWidget(scene, this);
        this.notifyStateChanged(null, ObjectState.createNormal());
        this.selectionWidget.addDependency(new Widget.Dependency(){

            public void revalidateDependency() {
            }
        });
        element.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        this.selectionWidget.setVisible(state.isSelected());
        if (state.isSelected()) {
            this.selectionWidget.updateBounds();
        }
    }

    public void updateBounds() {
        JasperDesign jd = ((ReportObjectScene)this.getScene()).getJasperDesign();
        Point location = this.convertModelToLocalLocation(new Point(this.element.getX(), this.element.getY()));
        location.x -= this.getBorder().getInsets().left;
        location.y -= this.getBorder().getInsets().top;
        this.setPreferredLocation(location);
        this.setPreferredBounds(new Rectangle(0, 0, this.element.getWidth() + this.getBorder().getInsets().left + this.getBorder().getInsets().right, this.element.getHeight() + this.getBorder().getInsets().top + this.getBorder().getInsets().bottom));
    }

    public SelectionWidget getSelectionWidget() {
        return this.selectionWidget;
    }

    public void setSelectionWidget(SelectionWidget selectionWidget) {
        this.selectionWidget = selectionWidget;
    }

    public Point convertLocalToModelLocation(Point p) {
        return this.convertLocalToModelLocation(p, true);
    }

    public Point convertLocalToModelLocation(Point p, boolean out) {
        JasperDesign jd = ((ReportObjectScene)this.getScene()).getJasperDesign();
        Point base = ModelUtils.getParentLocation(jd, this.getElement());
        if (out) {
            base.x -= this.getBorder().getInsets().left;
            base.y -= this.getBorder().getInsets().top;
        }
        return new Point(p.x - base.x, p.y - base.y);
    }

    public Point convertModelToLocalLocation(Point p) {
        JasperDesign jd = ((ReportObjectScene)this.getScene()).getJasperDesign();
        Point base = ModelUtils.getParentLocation(jd, this.getElement());
        return new Point(base.x + p.x, base.y + p.y);
    }

    protected void paintWidget() {
        super.paintWidget();
        Graphics2D gr = this.getScene().getGraphics();
        Rectangle r = this.getPreferredBounds();
        long t = new Date().getTime();
        AffineTransform af = gr.getTransform();
        AffineTransform new_af = (AffineTransform)af.clone();
        AffineTransform translate = AffineTransform.getTranslateInstance(this.getBorder().getInsets().left + r.x, this.getBorder().getInsets().top + r.y);
        new_af.concatenate(translate);
        gr.setTransform(new_af);
        JasperDesign jd = ((ReportObjectScene)this.getScene()).getJasperDesign();
        JRDesignElement e = this.getElement();
        DrawVisitor dv = ((ReportObjectScene)this.getScene()).getDrawVisitor();
        if (dv == null) {
            return;
        }
        dv.setGraphics2D(gr);
        e.visit((JRVisitor)dv);
        gr.setTransform(af);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isChanging()) {
            return;
        }
        String propertyName = evt.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("height") || propertyName.equals("width") || propertyName.equals("elementGroup") || propertyName.equals("x") || propertyName.equals("y") || propertyName.equals("backcolor") || propertyName.equals("forecolor") || propertyName.equals("parentStyle") || propertyName.equals("parentStyleNameReference") || propertyName.equals("mode") || propertyName.equals("fill") || propertyName.equals("direction") || propertyName.equals("radius") || propertyName.equals("horizontalAlignment") || propertyName.equals("verticalAlignment") || propertyName.equals("scaleImage") || propertyName.equals("fontName") || propertyName.equals("fontSize") || propertyName.equals("bold") || propertyName.equals("italic") || propertyName.equals("isStyledText") || propertyName.equals("underline") || propertyName.equals("strikeThrough") || propertyName.equals("rotation") || propertyName.equals("lineSpacing") || propertyName.equals("text") || propertyName.equals("expression")) {
            this.updateBounds();
            this.repaint();
            this.getSelectionWidget().updateBounds();
            this.getScene().validate();
        }
        if (propertyName.equals("children") && this.getElement() instanceof JRElementGroup) {
            ((ReportObjectScene)this.getScene()).refreshElementGroup((JRElementGroup)this.getElement());
        }
    }

    public synchronized boolean isChanging() {
        return this.changing;
    }

    public synchronized boolean setChanging(boolean changing) {
        boolean b = this.changing;
        this.changing = changing;
        return b;
    }
}

